/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import org.eclipse.wb.core.gef.policy.validator.AbstractLayoutRequestValidator;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public class ComponentClassLayoutRequestValidator
extends AbstractLayoutRequestValidator {
    private final String m_requiredClass;

    public ComponentClassLayoutRequestValidator(String requiredClass) {
        this.m_requiredClass = requiredClass;
    }

    @Override
    protected boolean validate(EditPart host, Object child) {
        IComponentDescription description = GlobalState.getDescriptionHelper().getDescription(child);
        if (description != null) {
            return this.validateDescription(host, description);
        }
        return false;
    }

    @Override
    protected boolean validateDescription(EditPart host, IComponentDescription childDescription) {
        Class<?> componentClass = childDescription.getComponentClass();
        return this.isValidClass(componentClass);
    }

    protected boolean isValidClass(Class<?> componentClass) {
        return ReflectionUtils.isSuccessorOf(componentClass, this.m_requiredClass);
    }
}

