/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.WorkspacePluginInfo;
import org.eclipse.wb.internal.swt.support.ImageSupport;

public class ImageEvaluator
implements IExpressionEvaluator {
    private static final String[] IMAGE_SIGNATURES_OLD = new String[]{"getPluginImage(java.lang.Object,java.lang.String)", "getPluginImageDescriptor(java.lang.Object,java.lang.String)"};
    private static final String[] IMAGE_SIGNATURES_NEW = new String[]{"getPluginImage(java.lang.String,java.lang.String)", "getPluginImageDescriptor(java.lang.String,java.lang.String)"};

    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.ResourceManager", (String[])IMAGE_SIGNATURES_OLD)) {
            MethodInvocation invocation = (MethodInvocation)expression;
            List arguments = DomGenerics.arguments((MethodInvocation)invocation);
            IProject project = ImageEvaluator.getProjectOverActivator((Expression)arguments.get(0));
            return ImageEvaluator.getPluginImage(invocation, (List<Expression>)arguments, context, project);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static Object getPluginImage(MethodInvocation invocation, List<Expression> arguments, EvaluationContext context, final IProject project) throws Exception {
        if (project != null) {
            return ImageEvaluator.getPluginImage(invocation, arguments, context, new InputStreamProvider(){

                @Override
                public InputStream getInputStream(String imagePath) throws Exception {
                    IFile file = project.getFile(imagePath);
                    return file.exists() ? file.getContents(true) : null;
                }
            });
        }
        return null;
    }

    private static Object getPluginImage(MethodInvocation invocation, List<Expression> arguments, EvaluationContext context, InputStreamProvider provider) throws Exception {
        Object image;
        InputStream stream;
        block7: {
            String imagePath = (String)AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)arguments.get(1));
            try {
                stream = provider.getInputStream(imagePath);
                if (stream != null) break block7;
                return null;
            }
            catch (Throwable e) {
                return null;
            }
        }
        try {
            image = ImageSupport.createImage(stream);
        }
        finally {
            stream.close();
        }
        if ("getPluginImage".equals(invocation.getName().getIdentifier())) {
            return image;
        }
        Class<?> imageDescriptorClass = context.getClassLoader().loadClass("org.eclipse.jface.resource.ImageDescriptor");
        return ReflectionUtils.invokeMethod(imageDescriptorClass, (String)"createFromImage(org.eclipse.swt.graphics.Image)", (Object[])new Object[]{image});
    }

    public static String[] getPluginImageValue(Property property) throws Exception {
        String symbolicName;
        MethodInvocation invocation;
        List arguments;
        IProject project;
        Expression expression = ((GenericProperty)property).getExpression();
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.ResourceManager", (String[])IMAGE_SIGNATURES_NEW)) {
            MethodInvocation invocation2 = (MethodInvocation)expression;
            List arguments2 = DomGenerics.arguments((MethodInvocation)invocation2);
            String symbolicName2 = (String)JavaInfoEvaluationHelper.getValue((Expression)((Expression)arguments2.get(0)));
            String imagePath = (String)JavaInfoEvaluationHelper.getValue((Expression)((Expression)arguments2.get(1)));
            return new String[]{symbolicName2, imagePath};
        }
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.ResourceManager", (String[])IMAGE_SIGNATURES_OLD) && (project = ImageEvaluator.getProjectOverActivator((Expression)(arguments = DomGenerics.arguments((MethodInvocation)(invocation = (MethodInvocation)expression))).get(0))) != null && (symbolicName = WorkspacePluginInfo.getBundleSymbolicName(project)) != null) {
            String imagePath = (String)JavaInfoEvaluationHelper.getValue((Expression)((Expression)arguments.get(1)));
            return new String[]{symbolicName, imagePath};
        }
        return null;
    }

    private static IProject getProjectOverActivator(Expression activatorAccessNode) throws Exception {
        if (activatorAccessNode instanceof MethodInvocation) {
            IProject[] projects;
            MethodInvocation pluginAccessInvocation = (MethodInvocation)activatorAccessNode;
            String activatorClass = AstNodeUtils.getFullyQualifiedName((Expression)pluginAccessInvocation.getExpression(), (boolean)false);
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (activatorClass.equals(WorkspacePluginInfo.getBundleActivator(project))) {
                    return project;
                }
                ++n2;
            }
        }
        return null;
    }

    private static interface InputStreamProvider {
        public InputStream getInputStream(String var1) throws Exception;
    }
}

