/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uz extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab";
        final String metaValue_hy = "arman";
        final String metaValue_bn = "bengal";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cheroki";
        final String metaValue_el = "grek";
        final String metaValue_gu = "gujarot";
        final String metaValue_zh = "xitoy";
        final String metaValue_he = "ivrit";
        final String metaValue_ja = "yapon";
        final String metaValue_kn = "kannada";
        final String metaValue_lo = "laos";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_nqo = "nko";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singal";
        final String metaValue_su = "sundan";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tay";
        final String metaValue_bo = "tibet";
        final Object[][] data = new Object[][] {
            { "001", "Dunyo" },
            { "002", "Afrika" },
            { "003", "Shimoliy Amerika" },
            { "005", "Janubiy Amerika" },
            { "009", "Okeaniya" },
            { "011", "G\u2018arbiy Afrika" },
            { "013", "Markaziy Amerika" },
            { "014", "Sharqiy Afrika" },
            { "015", "Shimoliy Afrika" },
            { "017", "Markaziy Afrika" },
            { "018", "Janubiy Afrika" },
            { "019", "Amerika" },
            { "021", "Shimoliy Amerika \u2013 AQSH va Kanada" },
            { "029", "Karib havzasi" },
            { "030", "Sharqiy Osiyo" },
            { "034", "Janubiy Osiyo" },
            { "035", "Janubi-sharqiy Osiyo" },
            { "039", "Janubiy Yevropa" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "057", "Mikroneziya mintaqasi" },
            { "061", "Polineziya" },
            { "142", "Osiyo" },
            { "143", "Markaziy Osiyo" },
            { "145", "G\u2018arbiy Osiyo" },
            { "150", "Yevropa" },
            { "151", "Sharqiy Yevropa" },
            { "154", "Shimoliy Yevropa" },
            { "155", "G\u2018arbiy Yevropa" },
            { "202", "Sahro janubidagi Afrika" },
            { "419", "Lotin Amerikasi" },
            { "AC", "Me\u2019roj oroli" },
            { "AD", "Andorra" },
            { "AE", "Birlashgan Arab Amirliklari" },
            { "AF", "Afg\u02bboniston" },
            { "AG", "Antigua va Barbuda" },
            { "AI", "Angilya" },
            { "AL", "Albaniya" },
            { "AM", "Armaniston" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Amerika Samoasi" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "AX", "Aland orollari" },
            { "AZ", "Ozarbayjon" },
            { "BA", "Bosniya va Gertsegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgiya" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bolgariya" },
            { "BH", "Bahrayn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermuda orollari" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Boneyr, Sint-Estatius va Saba" },
            { "BR", "Braziliya" },
            { "BS", "Bagama orollari" },
            { "BT", "Butan" },
            { "BV", "Buve oroli" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kiling) orollari" },
            { "CD", "Kongo \u2013 Kinshasa" },
            { "CF", "Markaziy Afrika Respublikasi" },
            { "CG", "Kongo \u2013 Brazzavil" },
            { "CH", "Shveytsariya" },
            { "CI", "Kot-d\u2019Ivuar" },
            { "CK", "Kuk orollari" },
            { "CL", "Chili" },
            { "CM", "Kamerun" },
            { "CN", "Xitoy" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton oroli" },
            { "CR", "Kosta-Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "CW", "Kyurasao" },
            { "CX", "Rojdestvo oroli" },
            { "CY", "Kipr" },
            { "CZ", "Chexiya" },
            { "DE", "Germaniya" },
            { "DG", "Diyego-Garsiya" },
            { "DJ", "Jibuti" },
            { "DK", "Daniya" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikasi" },
            { "DZ", "Jazoir" },
            { "EA", "Seuta va Melilya" },
            { "EC", "Ekvador" },
            { "EE", "Estoniya" },
            { "EG", "Misr" },
            { "EH", "G\u2018arbiy Sahroi Kabir" },
            { "ER", "Eritreya" },
            { "ES", "Ispaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Yevropa Ittifoqi" },
            { "EZ", "Yevrozona" },
            { "FI", "Finlandiya" },
            { "FJ", "Fiji" },
            { "FK", "Folklend orollari" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer orollari" },
            { "FR", "Fransiya" },
            { "GA", "Gabon" },
            { "GB", "Buyuk Britaniya" },
            { "GD", "Grenada" },
            { "GE", "Gruziya" },
            { "GF", "Fransuz Gvianasi" },
            { "GG", "Gernsi" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandiya" },
            { "GM", "Gambiya" },
            { "GN", "Gvineya" },
            { "GP", "Gvadelupe" },
            { "GQ", "Ekvatorial Gvineya" },
            { "GR", "Gretsiya" },
            { "GS", "Janubiy Georgiya va Janubiy Sendvich orollari" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineya-Bisau" },
            { "GY", "Gayana" },
            { "HK", "Gonkong (Xitoy MMH)" },
            { "HM", "Xerd va Makdonald orollari" },
            { "HN", "Gonduras" },
            { "HR", "Xorvatiya" },
            { "HT", "Gaiti" },
            { "HU", "Vengriya" },
            { "IC", "Kanar orollari" },
            { "ID", "Indoneziya" },
            { "IE", "Irlandiya" },
            { "IL", "Isroil" },
            { "IM", "Men oroli" },
            { "IN", "Hindiston" },
            { "IO", "Britaniyaning Hind okeanidagi hududi" },
            { "IQ", "Iroq" },
            { "IR", "Eron" },
            { "IS", "Islandiya" },
            { "IT", "Italiya" },
            { "JE", "Jersi" },
            { "JM", "Yamayka" },
            { "JO", "Iordaniya" },
            { "JP", "Yaponiya" },
            { "KE", "Keniya" },
            { "KG", "Qirg\u02bbiziston" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komor orollari" },
            { "KN", "Sent-Kits va Nevis" },
            { "KP", "Shimoliy Koreya" },
            { "KR", "Janubiy Koreya" },
            { "KW", "Quvayt" },
            { "KY", "Kayman orollari" },
            { "KZ", "Qozog\u02bbiston" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "Sent-Lyusiya" },
            { "LI", "Lixtenshteyn" },
            { "LK", "Shri-Lanka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "Lyuksemburg" },
            { "LV", "Latviya" },
            { "LY", "Liviya" },
            { "MA", "Marokash" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Chernogoriya" },
            { "MF", "Sent-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall orollari" },
            { "MK", "Shimoliy Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma (Birma)" },
            { "MN", "Mongoliya" },
            { "MO", "Makao (Xitoy MMH)" },
            { "MP", "Shimoliy Mariana orollari" },
            { "MQ", "Martinika" },
            { "MR", "Mavritaniya" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mavrikiy" },
            { "MV", "Maldiv orollari" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiya" },
            { "NC", "Yangi Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk oroli" },
            { "NG", "Nigeriya" },
            { "NI", "Nikaragua" },
            { "NL", "Niderlandiya" },
            { "NO", "Norvegiya" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Yangi Zelandiya" },
            { "OM", "Ummon" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransuz Polineziyasi" },
            { "PG", "Papua \u2013 Yangi Gvineya" },
            { "PH", "Filippin" },
            { "PK", "Pokiston" },
            { "PL", "Polsha" },
            { "PM", "Sen-Pyer va Mikelon" },
            { "PN", "Pitkern orollari" },
            { "PR", "Puerto-Riko" },
            { "PS", "Falastin hududlari" },
            { "PT", "Portugaliya" },
            { "PW", "Palau" },
            { "PY", "Paragvay" },
            { "QA", "Qatar" },
            { "QO", "Tashqi Okeaniya" },
            { "RE", "Reyunion" },
            { "RO", "Ruminiya" },
            { "RS", "Serbiya" },
            { "RU", "Rossiya" },
            { "RW", "Ruanda" },
            { "SA", "Saudiya Arabistoni" },
            { "SB", "Solomon orollari" },
            { "SC", "Seyshel orollari" },
            { "SD", "Sudan" },
            { "SE", "Shvetsiya" },
            { "SG", "Singapur" },
            { "SH", "Muqaddas Yelena oroli" },
            { "SI", "Sloveniya" },
            { "SJ", "Shpitsbergen va Yan-Mayen" },
            { "SK", "Slovakiya" },
            { "SL", "Syerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "Janubiy Sudan" },
            { "ST", "San-Tome va Prinsipi" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "SZ", "Svazilend" },
            { "TA", "Tristan-da-Kunya" },
            { "TC", "Turks va Kaykos orollari" },
            { "TD", "Chad" },
            { "TF", "Fransuz Janubiy hududlari" },
            { "TG", "Togo" },
            { "TH", "Tailand" },
            { "TJ", "Tojikiston" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmaniston" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turkiya" },
            { "TT", "Trinidad va Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzaniya" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "AQSH yondosh orollari" },
            { "UN", "Birlashgan Millatlar Tashkiloti" },
            { "US", "Amerika Qo\u2018shma Shtatlari" },
            { "UY", "Urugvay" },
            { "UZ", "O\u02bbzbekiston" },
            { "VA", "Vatikan" },
            { "VC", "Sent-Vinsent va Grenadin" },
            { "VE", "Venesuela" },
            { "VG", "Britaniya Virgin orollari" },
            { "VI", "AQSH Virgin orollari" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Uollis va Futuna" },
            { "WS", "Samoa" },
            { "XA", "Qalbaki urg\u2018u" },
            { "XB", "Qalbaki Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yaman" },
            { "YT", "Mayotta" },
            { "ZA", "Janubiy Afrika Respublikasi" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Noma\u2019lum mintaqa" },
            { "aa", "afar" },
            { "ab", "abxaz" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amxar" },
            { "an", "aragon" },
            { "ar", metaValue_ar },
            { "as", "assam" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "ozarbayjon" },
            { "ba", "boshqird" },
            { "be", "belarus" },
            { "bg", "bolgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniy" },
            { "ca", "katalan" },
            { "ce", "chechen" },
            { "ch", "chamorro" },
            { "co", "korsikan" },
            { "cs", "chex" },
            { "cu", "slavyan (cherkov)" },
            { "cv", "chuvash" },
            { "cy", "valliy" },
            { "da", "dan" },
            { "de", "nemischa" },
            { "dv", "divexi" },
            { "dz", "dzongka" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "inglizcha" },
            { "eo", "esperanto" },
            { "es", "ispancha" },
            { "et", "estoncha" },
            { "eu", "bask" },
            { "fa", "fors" },
            { "ff", "fula" },
            { "fi", "fincha" },
            { "fj", "fiji" },
            { "fo", "farercha" },
            { "fr", "fransuzcha" },
            { "fy", "g\u2018arbiy friz" },
            { "ga", "irland" },
            { "gd", "shotland-gel" },
            { "gl", "galisiy" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "men" },
            { "ha", "xausa" },
            { "he", metaValue_he },
            { "hi", "hind" },
            { "hr", "xorvat" },
            { "ht", "gaityan" },
            { "hu", "venger" },
            { "hy", metaValue_hy },
            { "hz", "gerero" },
            { "ia", "interlingva" },
            { "id", "indonez" },
            { "ig", "igbo" },
            { "ii", "sichuan" },
            { "io", "ido" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "yavan" },
            { "ka", "gruzincha" },
            { "ki", "kikuyu" },
            { "kj", "kvanyama" },
            { "kk", "qozoqcha" },
            { "kl", "grenland" },
            { "km", "xmer" },
            { "kn", metaValue_kn },
            { "ko", "koreyscha" },
            { "kr", "kanuri" },
            { "ks", "kashmircha" },
            { "ku", "kurdcha" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "qirg\u02bbizcha" },
            { "la", "lotincha" },
            { "lb", "lyuksemburgcha" },
            { "lg", "ganda" },
            { "li", "limburg" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litva" },
            { "lu", "luba-katanga" },
            { "lv", "latishcha" },
            { "mg", "malagasiy" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "maratxi" },
            { "ms", "malay" },
            { "mt", "maltiy" },
            { "my", "birman" },
            { "na", "nauru" },
            { "nb", "norveg-bokmal" },
            { "nd", "shimoliy ndebele" },
            { "ne", "nepal" },
            { "ng", "ndonga" },
            { "nl", "niderland" },
            { "nn", "norveg-nyunorsk" },
            { "no", "norveg" },
            { "nr", "janubiy ndebel" },
            { "nv", "navaxo" },
            { "ny", "cheva" },
            { "oc", "oksitan" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osetin" },
            { "pa", "panjobcha" },
            { "pl", "polyakcha" },
            { "ps", "pushtu" },
            { "pt", "portugalcha" },
            { "qu", "kechua" },
            { "rm", "romansh" },
            { "rn", "rundi" },
            { "ro", "rumincha" },
            { "ru", "ruscha" },
            { "rw", "kinyaruanda" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sd", "sindhi" },
            { "se", "shimoliy saam" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "slovakcha" },
            { "sl", "slovencha" },
            { "sm", "samoa" },
            { "sn", "shona" },
            { "so", "somalicha" },
            { "sq", "alban" },
            { "sr", "serbcha" },
            { "ss", "svati" },
            { "st", "janubiy soto" },
            { "su", metaValue_su },
            { "sv", "shved" },
            { "sw", "suaxili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tojik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turkman" },
            { "tn", "tsvana" },
            { "to", "tongan" },
            { "tr", "turk" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "ty", "taiti" },
            { "ug", "uyg\u2018ur" },
            { "uk", "ukrain" },
            { "ur", "urdu" },
            { "uz", "o\u2018zbek" },
            { "ve", "venda" },
            { "vi", "vyetnam" },
            { "vo", "volapyuk" },
            { "wa", "vallon" },
            { "wo", "volof" },
            { "xh", "kxosa" },
            { "yi", "idish" },
            { "yo", "yoruba" },
            { "zh", metaValue_zh },
            { "zu", "zulu" },
            { "ace", "achin" },
            { "ada", "adangme" },
            { "ady", "adigey" },
            { "agq", "agem" },
            { "ain", "aynu" },
            { "ale", "aleut" },
            { "alt", "janubiy oltoy" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arn", "mapuche" },
            { "arp", "arapaxo" },
            { "ars", "najd arab" },
            { "asa", "asu" },
            { "ast", "asturiy" },
            { "atj", "atikamek" },
            { "awa", "avadxi" },
            { "ban", "bali" },
            { "bas", "basa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "g\u2018arbiy baluj" },
            { "bho", "bxojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "brx", "bodo" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cay", "kayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebuan" },
            { "cgg", "chiga" },
            { "chk", "chukot" },
            { "chm", "mari" },
            { "cho", "choktav" },
            { "chp", "chipevyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenn" },
            { "ckb", "sorani-kurd" },
            { "clc", "chilkotin" },
            { "crg", "michif" },
            { "crj", "janubi-sharqiy kri" },
            { "crk", "tekislik kri" },
            { "crl", "shomoli-sharqiy kri" },
            { "crm", "mus kri" },
            { "crr", "karolin algonkin" },
            { "crs", "kreol (Seyshel)" },
            { "csw", "botqoq kri" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "quyi sorb" },
            { "dua", "duala" },
            { "dyo", "diola-fogni" },
            { "dzg", "dazag" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "evondo" },
            { "fil", "filipincha" },
            { "fon", "fon" },
            { "frc", "kajun fransuz" },
            { "frr", "shimoliy friz" },
            { "fur", "friul" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan" },
            { "gez", "geez" },
            { "gil", "gilbert" },
            { "gor", "gorontalo" },
            { "gsw", "nemis (Shveytsariya)" },
            { "guz", "gusii" },
            { "gwi", "gvichin" },
            { "hai", "hayda" },
            { "haw", "gavaycha" },
            { "hax", "janubiy hayda" },
            { "hil", "hiligaynon" },
            { "hmn", "xmong" },
            { "hsb", "yuqori sorb" },
            { "hup", "xupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "sharqiy-kanada inuktitut" },
            { "ilo", "iloko" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabil" },
            { "kac", "kachin" },
            { "kaj", "kaji" },
            { "kam", "kamba" },
            { "kbd", "kabardin" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kxasi" },
            { "khq", "koyra-chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkan" },
            { "kpe", "kpelle" },
            { "krc", "qorachoy-bolqor" },
            { "krl", "karel" },
            { "kru", "kurux" },
            { "ksb", "shambala" },
            { "ksf", "bafiya" },
            { "ksh", "kyoln" },
            { "kum", "qo\u2018miq" },
            { "kwk", "kvakvala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lez", "lezgin" },
            { "lil", "lilluet" },
            { "lkt", "lakota" },
            { "lou", "luiziana kreol" },
            { "loz", "lozi" },
            { "lrc", "shimoliy luri" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushay" },
            { "luy", "luhya" },
            { "mad", "madur" },
            { "mag", "magahi" },
            { "mai", "maythili" },
            { "mak", "makasar" },
            { "mas", "masay" },
            { "mdf", "moksha" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mgh", "maxuva-mitto" },
            { "mgo", "meta" },
            { "mic", "mikmak" },
            { "min", "minangkabau" },
            { "mni", "manipur" },
            { "moe", "innu-aymun" },
            { "moh", "mohauk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "bir nechta til" },
            { "mus", "krik" },
            { "mwl", "miranda" },
            { "myv", "erzya" },
            { "mzn", "mozandaron" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "nds", "quyi nemis" },
            { "new", "nevar" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "nmg", "kvasio" },
            { "nnh", "ngiyembun" },
            { "nog", "no\u2018g\u2018ay" },
            { "nqo", metaValue_nqo },
            { "nso", "shimoliy soto" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "shimoli-g\u02bbarbiy ojibva" },
            { "ojc", "markaziy ijibve" },
            { "ojs", "oji-kri" },
            { "ojw", "g\u02bbarbiy ojibva" },
            { "oka", "okanagan" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiyamento" },
            { "pau", "palau" },
            { "pcm", "kreol (Nigeriya)" },
            { "pis", "pijin" },
            { "pqm", "maliset-passamakvoddi" },
            { "prg", "pruss" },
            { "quc", "kiche" },
            { "rap", "rapanui" },
            { "rar", "rarotongan" },
            { "rhg", "rohinja" },
            { "rof", "rombo" },
            { "rup", "arumin" },
            { "rwk", "ruanda" },
            { "sad", "sandave" },
            { "sah", "saxa" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sitsiliya" },
            { "sco", "shotland" },
            { "sdh", "janubiy kurd" },
            { "seh", "sena" },
            { "ses", "koyraboro-senni" },
            { "shi", "tashelxit" },
            { "shn", "shan" },
            { "slh", "janubiy lushutsid" },
            { "sma", "janubiy saam" },
            { "smj", "lule-saam" },
            { "smn", "inari-saam" },
            { "sms", "skolt-saam" },
            { "snk", "soninke" },
            { "srn", "sranan-tongo" },
            { "ssy", "saho" },
            { "str", "streyts salish" },
            { "suk", "sukuma" },
            { "swb", "qamar" },
            { "syr", "suriyacha" },
            { "tce", "janubiy tutchone" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "taltan" },
            { "tig", "tigre" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "tokipona" },
            { "tpi", "tok-piksin" },
            { "trv", "taroko" },
            { "ttm", "shimoliy tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasavak" },
            { "tyv", "tuva" },
            { "tzm", "markaziy atlas tamazigxt" },
            { "udm", "udmurt" },
            { "umb", "umbundu" },
            { "und", "noma\u2019lum til" },
            { "vai", "vai" },
            { "vun", "vunjo" },
            { "wae", "valis" },
            { "wal", "volamo" },
            { "war", "varay" },
            { "wbp", "valbiri" },
            { "wuu", "vu xitoy" },
            { "xal", "qalmoq" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nyengatu" },
            { "yue", "kanton" },
            { "zgh", "tamazigxt" },
            { "zun", "zuni" },
            { "zxx", "til tarkibi yo\u2018q" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nasta\u02bcliq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "brayl" },
            { "Cakm", metaValue_ccp },
            { "Cans", "kanada bo\u02bbg\u02bbin yozuvi" },
            { "Cher", metaValue_chr },
            { "Cyrl", "kirill" },
            { "Deva", "devanagari" },
            { "Ethi", "habash" },
            { "Geor", "gruzin" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukxi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", metaValue_zh },
            { "Hans", "soddalashgan" },
            { "Hant", "an\u02bcanaviy" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "katakana yoki hiragana" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", "kxmer" },
            { "Knda", metaValue_kn },
            { "Kore", "koreys" },
            { "Laoo", metaValue_lo },
            { "Latn", "lotin" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "manipuri" },
            { "Mymr", "myanma" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ol chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", "suryoniy" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinag" },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", "vay" },
            { "Yiii", "i" },
            { "Zmth", "matematik ifodalar" },
            { "Zsye", "emoji" },
            { "Zsym", "belgilar" },
            { "Zxxx", "yozuvsiz" },
            { "Zyyy", "umumiy" },
            { "Zzzz", "noma\u2019lum yozuv" },
            { "de_AT", "nemis (Avstriya)" },
            { "de_CH", "yuqori nemis (Shveytsariya)" },
            { "en_AU", "ingliz (Avstraliya)" },
            { "en_CA", "ingliz (Kanada)" },
            { "en_GB", "ingliz (Britaniya)" },
            { "en_US", "ingliz (Amerika)" },
            { "es_ES", "ispan (Yevropa)" },
            { "es_MX", "ispan (Meksika)" },
            { "fa_AF", "dari" },
            { "fr_CA", "fransuz (Kanada)" },
            { "fr_CH", "fransuz (Shveytsariya)" },
            { "nl_BE", "flamand" },
            { "pt_BR", "portugal (Braziliya)" },
            { "pt_PT", "portugal (Yevropa)" },
            { "ro_MD", "moldovan" },
            { "sw_CD", "suaxili (Kongo)" },
            { "ar_001", "standart arab" },
            { "es_419", "ispan (Lotin Amerikasi)" },
            { "key.ca", "taqvim" },
            { "key.cf", "valyuta formati" },
            { "key.co", "saralash tartibi" },
            { "key.cu", "valyuta" },
            { "key.hc", "soat tizimi (12 yoki 24)" },
            { "key.lb", "qatorni uzish uslubi" },
            { "key.ms", "o\u2018lchov tizimi" },
            { "key.nu", "raqamlar" },
            { "nds_NL", "quyi sakson" },
            { "zh_Hant", "xitoy (an\u2019anaviy)" },
            { "type.ca.roc", "mingo taqvimi" },
            { "type.hc.h11", "12 soatlik tizim (0\u201311)" },
            { "type.hc.h12", "12 soatlik tizim (1\u201312)" },
            { "type.hc.h23", "24 soatlik tizim (0\u201323)" },
            { "type.hc.h24", "24 soatlik tizim (1\u201324)" },
            { "type.nu.arab", "arab-hind raqamlari" },
            { "type.nu.armn", "arman raqamlari" },
            { "type.nu.beng", "bengal raqamlari" },
            { "type.nu.cakm", "chakma raqamlari" },
            { "type.nu.deva", "devanagari raqamlari" },
            { "type.nu.ethi", "habash raqamlari" },
            { "type.nu.geor", "gruzin raqamlari" },
            { "type.nu.grek", "grek raqamlari" },
            { "type.nu.gujr", "gujarot raqamlari" },
            { "type.nu.guru", "gurmukxi raqamlari" },
            { "type.nu.hans", "soddalashgan xitoy raqamlari" },
            { "type.nu.hant", "an\u2019anaviy xitoy raqamlari" },
            { "type.nu.hebr", "ivrit raqamlari" },
            { "type.nu.java", "yava raqamlari" },
            { "type.nu.jpan", "yapon raqamlari" },
            { "type.nu.khmr", "kxmer raqamlari" },
            { "type.nu.knda", "kannada raqamlari" },
            { "type.nu.laoo", "laos raqamlari" },
            { "type.nu.latn", "zamonaviy arab raqamlari" },
            { "type.nu.mlym", "malayalam raqamlari" },
            { "type.nu.mtei", "manipuri raqamlari" },
            { "type.nu.mymr", "birma raqamlari" },
            { "type.nu.olck", "ol chiki taqamlari" },
            { "type.nu.orya", "oriya raqamlari" },
            { "type.nu.taml", "an\u2019anaviy tamil raqamlari" },
            { "type.nu.telu", "telugu raqamlari" },
            { "type.nu.thai", "tay raqamlari" },
            { "type.nu.tibt", "tibet raqamlari" },
            { "type.nu.vaii", "vay raqamlari" },
            { "type.ca.dangi", "dangi taqvimi" },
            { "type.co.ducet", "standart Unicode saralash tartibi" },
            { "type.lb.loose", "qatorni yumshoq uzish" },
            { "type.nu.roman", "rim raqamlari" },
            { "type.ca.coptic", "qibtiy taqvim" },
            { "type.ca.hebrew", "yahudiy taqvimi" },
            { "type.co.search", "qidiruv" },
            { "type.lb.normal", "qatorni odatiy uzish" },
            { "type.lb.strict", "qatorni qat\u2019iy uzish" },
            { "type.ms.metric", "metrik tizim" },
            { "type.ca.chinese", "xitoy taqvimi" },
            { "type.ca.islamic", "islomiy taqvim" },
            { "type.ca.iso8601", "ISO-8601 taqvimi" },
            { "type.ca.persian", "fors taqvimi" },
            { "type.cf.account", "moliyaviy valyuta formati" },
            { "type.nu.arabext", "kengaytirilgan arab-hind raqamlari" },
            { "type.nu.armnlow", "arman kichik raqamlari" },
            { "type.nu.greklow", "kichik grek raqamlari" },
            { "type.nu.hanidec", "xitoy o\u2018nli raqamlari" },
            { "type.nu.hansfin", "soddalashgan xitoy raqamlari (moliyaviy)" },
            { "type.nu.hantfin", "an\u2019anaviy xitoy raqamlari (moliyaviy)" },
            { "type.nu.jpanfin", "yapon raqamlari (moliyaviy)" },
            { "type.nu.tamldec", "tamil raqamlari" },
            { "type.ca.buddhist", "buddizm taqvimi" },
            { "type.ca.ethiopic", "habash taqvimi" },
            { "type.ca.japanese", "yapon taqvimi" },
            { "type.cf.standard", "standart valyuta formati" },
            { "type.co.standard", "standart saralash tartibi" },
            { "type.ms.uksystem", "Britaniya o\u2018lchov tizimi" },
            { "type.ms.ussystem", "AQSH o\u2018lchov tizimi" },
            { "type.nu.fullwide", "to\u2018liq enli raqamlar" },
            { "type.nu.romanlow", "kichik rim raqamlari" },
            { "type.ca.gregorian", "grigorian taqvimi" },
            { "type.ca.islamic-tbla", "jadvalli islomiy taqvim (astronomik davr)" },
            { "type.ca.islamic-civil", "jadvalli islomiy taqvim" },
            { "type.ca.islamic-umalqura", "islomiy taqvim (Ummul Quro)" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem habash taqvimi" },
        };
        return data;
    }
}
