/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabImageDescriptor;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchDelegateContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchConfigurationManager
implements ILaunchListener,
ISaveParticipant {
    protected Map<String, LaunchGroupExtension> fLaunchGroups;
    protected Map<String, LaunchHistory> fLaunchHistories;
    protected List<ILaunchHistoryChangedListener> fLaunchHistoryChangedListeners = new ArrayList<ILaunchHistoryChangedListener>(3);
    private List<LaunchShortcutExtension> fLaunchShortcuts = null;
    private Map<String, List<LaunchShortcutExtension>> fLaunchShortcutsByPerspective = null;
    protected ImageRegistry fErrorImages = null;
    protected boolean fRestoring = false;
    private static final String LAUNCH_CONFIGURATION_HISTORY_FILENAME = "launchConfigurationHistory.xml";

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        DebugUIPlugin.getDefault().addSaveParticipant(this);
        ILaunch[] iLaunchArray = launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchAdded(launch);
            ++n2;
        }
    }

    public boolean launchModeAvailable(String mode) {
        return ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).launchModeAvailable(mode);
    }

    public static boolean isVisible(ILaunchConfiguration launchConfiguration) {
        try {
            return !launchConfiguration.getAttribute("org.eclipse.debug.ui.private", false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static ILaunchConfiguration[] filterConfigs(ILaunchConfiguration[] configurations) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport == null) {
            return configurations;
        }
        ArrayList<ILaunchConfiguration> filteredConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            try {
                ILaunchConfigurationType type = configuration.getType();
                LaunchConfigurationTypeContribution contribution = new LaunchConfigurationTypeContribution(type);
                if (DebugUIPlugin.doLaunchConfigurationFiltering(configuration) & !WorkbenchActivityHelper.filterItem((Object)contribution)) {
                    filteredConfigs.add(configuration);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
            ++n2;
        }
        return filteredConfigs.toArray(new ILaunchConfiguration[filteredConfigs.size()]);
    }

    public static ILaunchDelegate[] filterLaunchDelegates(ILaunchConfigurationType type, Set<String> modes) throws CoreException {
        IWorkbenchActivitySupport as = PlatformUI.getWorkbench().getActivitySupport();
        ILaunchDelegate[] delegates = type.getDelegates(modes);
        if (as == null) {
            return delegates;
        }
        HashSet<ILaunchDelegate> set = new HashSet<ILaunchDelegate>();
        ILaunchDelegate[] iLaunchDelegateArray = delegates;
        int n = delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchDelegate delegate = iLaunchDelegateArray[n2];
            if (!WorkbenchActivityHelper.filterItem((Object)new LaunchDelegateContribution(delegate))) {
                set.add(delegate);
            }
            ++n2;
        }
        return set.toArray(new ILaunchDelegate[set.size()]);
    }

    public void shutdown() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this);
        if (this.fLaunchHistories != null) {
            for (LaunchHistory history : this.fLaunchHistories.values()) {
                history.dispose();
            }
        }
        DebugUIPlugin.getDefault().removeSaveParticipant(this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        this.removeTerminatedLaunches(launch);
    }

    protected void removeTerminatedLaunches(ILaunch newLaunch) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches")) {
            ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] iLaunchArray = lManager.getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch != newLaunch && launch.isTerminated()) {
                    lManager.removeLaunch(launch);
                }
                ++n2;
            }
        }
    }

    public ILaunchConfiguration getLastLaunch(String groupId) {
        LaunchHistory history = this.getLaunchHistory(groupId);
        if (history != null) {
            return history.getRecentLaunch();
        }
        return null;
    }

    public ILaunchConfiguration getFilteredLastLaunch(String groupId) {
        ILaunchConfiguration[] filterConfigs;
        LaunchHistory history = this.getLaunchHistory(groupId);
        if (history != null && (filterConfigs = history.getCompleteLaunchHistory()).length > 0) {
            return filterConfigs[0];
        }
        return null;
    }

    public void addLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        if (!this.fLaunchHistoryChangedListeners.contains(listener)) {
            this.fLaunchHistoryChangedListeners.add(listener);
        }
    }

    public void removeLaunchHistoryListener(ILaunchHistoryChangedListener listener) {
        this.fLaunchHistoryChangedListeners.remove(listener);
    }

    protected void fireLaunchHistoryChanged() {
        for (ILaunchHistoryChangedListener listener : this.fLaunchHistoryChangedListeners) {
            listener.launchHistoryChanged();
        }
    }

    protected String getHistoryAsXML() throws CoreException, ParserConfigurationException {
        Document doc = DebugUIPlugin.getDocument();
        Element historyRootElement = doc.createElement("launchHistory");
        doc.appendChild(historyRootElement);
        for (LaunchHistory history : this.fLaunchHistories.values()) {
            Element groupElement = doc.createElement("launchGroup");
            groupElement.setAttribute("id", history.getLaunchGroup().getIdentifier());
            historyRootElement.appendChild(groupElement);
            Element historyElement = doc.createElement("mruHistory");
            groupElement.appendChild(historyElement);
            this.createEntry(doc, historyElement, history.getCompleteLaunchHistory());
            Element favs = doc.createElement("favorites");
            groupElement.appendChild(favs);
            this.createEntry(doc, favs, history.getFavorites());
            history.setSaved(true);
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    protected void createEntry(Document doc, Element historyRootElement, ILaunchConfiguration[] configurations) throws CoreException {
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            if (configuration.exists()) {
                Element launch = doc.createElement("launch");
                launch.setAttribute("memento", configuration.getMemento());
                historyRootElement.appendChild(launch);
            }
            ++n2;
        }
    }

    protected IPath getHistoryFilePath() {
        return DebugUIPlugin.getDefault().getStateLocation().append(LAUNCH_CONFIGURATION_HISTORY_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistLaunchHistory() throws IOException, CoreException, ParserConfigurationException {
        LaunchConfigurationManager launchConfigurationManager = this;
        synchronized (launchConfigurationManager) {
            if (this.fLaunchHistories == null || this.fRestoring) {
                return;
            }
        }
        boolean shouldsave = false;
        for (LaunchHistory history : this.fLaunchHistories.values()) {
            shouldsave |= history.needsSaving();
        }
        if (shouldsave) {
            IPath historyPath = this.getHistoryFilePath();
            String osHistoryPath = historyPath.toOSString();
            String xml = this.getHistoryAsXML();
            File file = new File(osHistoryPath);
            file.createNewFile();
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(xml.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void restoreLaunchHistory() {
        IPath historyPath = this.getHistoryFilePath();
        String osHistoryPath = historyPath.toOSString();
        File file = new File(osHistoryPath);
        if (!file.exists()) {
            return;
        }
        Element rootHistoryElement = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    rootHistoryElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException e) {
                    DebugUIPlugin.log(e);
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                    return;
                }
                catch (ParserConfigurationException e) {
                    block26: {
                        DebugUIPlugin.log(e);
                        if (stream == null) break block26;
                        ((InputStream)stream).close();
                    }
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            DebugUIPlugin.log(exception);
            return;
        }
        if (!rootHistoryElement.getNodeName().equalsIgnoreCase("launchHistory")) {
            return;
        }
        LaunchHistory[] histories = this.fLaunchHistories.values().toArray(new LaunchHistory[this.fLaunchHistories.size()]);
        NodeList list = rootHistoryElement.getChildNodes();
        int length = list.getLength();
        Node node = null;
        Element entry = null;
        int i = 0;
        while (i < length) {
            node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                LaunchHistory history;
                String id;
                entry = (Element)node;
                if (entry.getNodeName().equalsIgnoreCase("launch")) {
                    this.createHistoryElement(entry, histories, false);
                } else if (entry.getNodeName().equalsIgnoreCase("lastLaunch")) {
                    this.createHistoryElement(entry, histories, true);
                } else if (entry.getNodeName().equals("launchGroup") && (id = entry.getAttribute("id")) != null && (history = this.getLaunchHistory(id)) != null) {
                    this.restoreHistory(entry, history);
                }
            }
            ++i;
        }
    }

    private void restoreHistory(Element groupElement, LaunchHistory history) {
        NodeList nodes = groupElement.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equals("mruHistory")) {
                    ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchConfigurations(element);
                    var10_11 = iLaunchConfigurationArray.length;
                    int n = 0;
                    while (n < var10_11) {
                        ILaunchConfiguration config = iLaunchConfigurationArray[n];
                        history.addHistory(config, false);
                        ++n;
                    }
                } else if (element.getNodeName().equals("favorites")) {
                    ILaunchConfiguration[] favs = this.getLaunchConfigurations(element);
                    history.setFavorites(favs);
                    ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchManager().getLaunchConfigurations();
                    int n = iLaunchConfigurationArray.length;
                    var10_11 = 0;
                    while (var10_11 < n) {
                        ILaunchConfiguration configuration = iLaunchConfigurationArray[var10_11];
                        history.checkFavorites(configuration);
                        ++var10_11;
                    }
                }
            }
            ++i;
        }
    }

    private ILaunchConfiguration[] getLaunchConfigurations(Element root) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        NodeList nodes = root.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            String memento;
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals("launch") && (memento = element.getAttribute("memento")) != null) {
                try {
                    ILaunchConfiguration configuration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
                    configuration.getType();
                    if (configuration.exists()) {
                        configs.add(configuration);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    private void createHistoryElement(Element entry, LaunchHistory[] histories, boolean prepend) {
        String memento = entry.getAttribute("memento");
        String mode = entry.getAttribute("mode");
        try {
            ILaunchConfiguration launchConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
            launchConfig.getType();
            if (launchConfig.exists()) {
                LaunchHistory[] launchHistoryArray = histories;
                int n = histories.length;
                int n2 = 0;
                while (n2 < n) {
                    LaunchHistory history = launchHistoryArray[n2];
                    if (history.accepts(launchConfig) && history.getLaunchGroup().getMode().equals(mode)) {
                        history.addHistory(launchConfig, prepend);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private synchronized void loadLaunchShortcuts() {
        if (this.fLaunchShortcuts == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchShortcuts");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchShortcuts = new ArrayList<LaunchShortcutExtension>(infos.length);
            IConfigurationElement[] iConfigurationElementArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement info = iConfigurationElementArray[n2];
                this.fLaunchShortcuts.add(new LaunchShortcutExtension(info));
                ++n2;
            }
            Collections.sort(this.fLaunchShortcuts, new ShortcutComparator());
        }
    }

    private synchronized void loadLaunchGroups() {
        if (this.fLaunchGroups == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchGroups");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fLaunchGroups = new HashMap<String, LaunchGroupExtension>(infos.length);
            LaunchGroupExtension ext = null;
            IConfigurationElement[] iConfigurationElementArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement info = iConfigurationElementArray[n2];
                ext = new LaunchGroupExtension(info);
                this.fLaunchGroups.put(ext.getIdentifier(), ext);
                ++n2;
            }
        }
    }

    public List<LaunchShortcutExtension> getLaunchShortcuts() {
        if (this.fLaunchShortcuts == null) {
            this.loadLaunchShortcuts();
        }
        return this.fLaunchShortcuts;
    }

    public List<LaunchShortcutExtension> getLaunchShortcuts(IResource resource) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List<LaunchShortcutExtension> sc = this.getLaunchShortcuts();
        ArrayList<IResource> ctxt = new ArrayList<IResource>();
        if (resource != null) {
            ctxt.add(resource);
        }
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(ctxt);
        context.addVariable("selection", ctxt);
        for (LaunchShortcutExtension ext : sc) {
            try {
                if (!ext.evalEnablementExpression(context, ext.getContextualLaunchEnablementExpression()) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    public String[] getApplicableConfigurationTypes(IResource resource) {
        List<LaunchShortcutExtension> exts = this.getLaunchShortcuts();
        ArrayList<IResource> list = new ArrayList<IResource>();
        list.add(resource);
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(list);
        context.setAllowPluginActivation(true);
        context.addVariable("selection", list);
        HashSet<String> contributedTypeIds = new HashSet<String>();
        ListIterator<LaunchShortcutExtension> iter = exts.listIterator();
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression(context, ext.getContextualLaunchEnablementExpression())) continue;
                contributedTypeIds.addAll(ext.getAssociatedConfigurationTypes());
            }
            catch (CoreException ce) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Launch shortcut '" + ext.getId() + "' enablement expression caused exception. Shortcut was removed.", (Throwable)ce);
                DebugUIPlugin.log((IStatus)status);
                iter.remove();
            }
        }
        ArrayList<String> typeIds = new ArrayList<String>();
        LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
        for (String id : contributedTypeIds) {
            String identifier;
            ILaunchConfigurationType type = lm.getLaunchConfigurationType(id);
            if (type == null || typeIds.contains(identifier = type.getIdentifier()) || !type.isPublic() || "org.eclipse.ui.externaltools.builder".equals(type.getCategory())) continue;
            typeIds.add(identifier);
        }
        return typeIds.toArray(new String[typeIds.size()]);
    }

    public ILaunchConfiguration[] getApplicableLaunchConfigurations(String[] types, IResource resource) {
        ArrayList<ILaunchConfiguration> list;
        block9: {
            list = new ArrayList<ILaunchConfiguration>();
            try {
                if (resource == null) break block9;
                String[] ctypes = types;
                if (ctypes == null) {
                    ctypes = this.getApplicableConfigurationTypes(resource);
                }
                HashSet typeset = new HashSet(ctypes.length);
                Collections.addAll(typeset, ctypes);
                ILaunchConfiguration[] iLaunchConfigurationArray = LaunchConfigurationManager.filterConfigs(this.getLaunchManager().getLaunchConfigurations());
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    if (typeset.contains(configuration.getType().getIdentifier()) && this.acceptConfiguration(configuration)) {
                        IResource[] resrcs = configuration.getMappedResources();
                        if (resrcs != null) {
                            IResource[] iResourceArray = resrcs;
                            int n3 = resrcs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource res = iResourceArray[n4];
                                if (resource.equals((Object)res) || resource.getFullPath().isPrefixOf(res.getFullPath())) {
                                    list.add(configuration);
                                    break;
                                }
                                ++n4;
                            }
                        } else {
                            list.add(configuration);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                list.clear();
                DebugPlugin.log((Throwable)e);
            }
        }
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    private boolean acceptConfiguration(ILaunchConfiguration config) throws CoreException {
        if (config != null && !DebugUITools.isPrivate(config)) {
            if (!"org.eclipse.ui.externaltools".equals(config.getType().getCategory())) {
                return true;
            }
            IResource[] res = config.getMappedResources();
            if (res != null) {
                return true;
            }
        }
        return false;
    }

    public List<LaunchShortcutExtension> getLaunchShortcuts(String category) {
        return this.filterShortcuts(this.getLaunchShortcuts(), category);
    }

    protected List<LaunchShortcutExtension> filterShortcuts(List<LaunchShortcutExtension> unfiltered, String category) {
        ArrayList<LaunchShortcutExtension> filtered = new ArrayList<LaunchShortcutExtension>(unfiltered.size());
        for (LaunchShortcutExtension extension : unfiltered) {
            if (category == null) {
                if (extension.getCategory() != null) continue;
                filtered.add(extension);
                continue;
            }
            if (!category.equals(extension.getCategory())) continue;
            filtered.add(extension);
        }
        return filtered;
    }

    @Deprecated
    public List<LaunchShortcutExtension> getLaunchShortcuts(String perpsective, String category) {
        if (this.fLaunchShortcutsByPerspective == null) {
            this.fLaunchShortcutsByPerspective = new HashMap<String, List<LaunchShortcutExtension>>(10);
        }
        for (LaunchShortcutExtension ext : this.getLaunchShortcuts()) {
            for (String id : ext.getPerspectives()) {
                List<LaunchShortcutExtension> list = this.fLaunchShortcutsByPerspective.get(id);
                if (list == null) {
                    list = new ArrayList<LaunchShortcutExtension>(4);
                    this.fLaunchShortcutsByPerspective.put(id, list);
                }
                list.add(ext);
            }
        }
        List<LaunchShortcutExtension> list = this.fLaunchShortcutsByPerspective.get(perpsective);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterShortcuts(list, category);
    }

    public ILaunchConfiguration getMRUConfiguration(List<ILaunchConfiguration> configurations, ILaunchGroup group, IResource resource) {
        if (group != null) {
            ArrayList<ILaunchConfiguration> candidates = new ArrayList<ILaunchConfiguration>();
            LaunchHistory history = this.getLaunchHistory(group.getIdentifier());
            if (history != null) {
                ILaunchConfiguration config;
                ILaunchConfiguration[] configs;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = history.getCompleteLaunchHistory();
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    config = iLaunchConfigurationArray[n2];
                    if (configurations.contains(config)) {
                        if (resource instanceof IContainer) {
                            return config;
                        }
                        candidates.add(config);
                    }
                    ++n2;
                }
                if (resource != null) {
                    IResource[] res = null;
                    for (ILaunchConfiguration config2 : candidates) {
                        try {
                            res = config2.getMappedResources();
                            if (res == null) continue;
                            IResource[] iResourceArray = res;
                            int n3 = res.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource re = iResourceArray[n4];
                                if (re.equals((Object)resource)) {
                                    return config2;
                                }
                                ++n4;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                iLaunchConfigurationArray = configs;
                n = configs.length;
                n2 = 0;
                while (n2 < n) {
                    config = iLaunchConfigurationArray[n2];
                    if (candidates.contains(config)) {
                        return config;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public ILaunchConfiguration isSharedConfig(Object receiver) {
        if (receiver instanceof IFile) {
            ILaunchConfiguration config;
            IFile file = (IFile)receiver;
            String ext = file.getFileExtension();
            if (ext == null) {
                return null;
            }
            if (ext.equals("launch") && (config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(file)) != null && config.exists()) {
                return config;
            }
        } else {
            IFile file;
            if (receiver instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)receiver;
                return this.isSharedConfig(input.getFile());
            }
            if (receiver instanceof IEditorPart) {
                return this.isSharedConfig(((IEditorPart)receiver).getEditorInput());
            }
            if (receiver instanceof IAdaptable && (file = (IFile)((IAdaptable)receiver).getAdapter(IFile.class)) != null) {
                return this.isSharedConfig(file);
            }
        }
        return null;
    }

    public Image getErrorTabImage(ILaunchConfigurationTab tab) {
        String key;
        Image image;
        if (this.fErrorImages == null) {
            this.fErrorImages = new ImageRegistry();
        }
        if ((image = this.fErrorImages.get(key = tab.getClass().getName())) == null) {
            Image base = tab.getImage();
            if (base == null) {
                base = DebugPluginImages.getImage("IMG_OVR_TRANSPARENT");
            }
            base = new Image((Device)Display.getCurrent(), base, 0);
            this.fErrorImages.put(String.valueOf(key) + "-baseImage", base);
            LaunchConfigurationTabImageDescriptor desc = new LaunchConfigurationTabImageDescriptor(base, 1);
            image = desc.createImage();
            this.fErrorImages.put(key, image);
        }
        return image;
    }

    public LaunchGroupExtension getLaunchGroup(String id) {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        return this.fLaunchGroups.get(id);
    }

    public ILaunchGroup[] getLaunchGroups() {
        if (this.fLaunchGroups == null) {
            this.loadLaunchGroups();
        }
        return this.fLaunchGroups.values().toArray(new ILaunchGroup[this.fLaunchGroups.size()]);
    }

    public LaunchHistory getLaunchHistory(String id) {
        this.loadLaunchHistories();
        return this.fLaunchHistories.get(id);
    }

    private LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    private synchronized void loadLaunchHistories() {
        if (this.fLaunchHistories == null) {
            this.fRestoring = true;
            ILaunchGroup[] groups = this.getLaunchGroups();
            this.fLaunchHistories = new HashMap<String, LaunchHistory>(groups.length);
            ILaunchGroup extension = null;
            ILaunchGroup[] iLaunchGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchGroup group = iLaunchGroupArray[n2];
                extension = group;
                if (extension.isPublic()) {
                    this.fLaunchHistories.put(extension.getIdentifier(), new LaunchHistory(extension));
                }
                ++n2;
            }
            this.restoreLaunchHistory();
            this.fRestoring = false;
        }
    }

    public LaunchGroupExtension getDefaultLaunchGroup(String mode) {
        if (mode.equals("debug")) {
            return this.getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug");
        }
        return this.getLaunchGroup("org.eclipse.debug.ui.launchGroup.run");
    }

    public ILaunchGroup getLaunchGroup(ILaunchConfigurationType type, String mode) {
        if (!type.supportsMode(mode)) {
            return null;
        }
        String category = type.getCategory();
        ILaunchGroup extension = null;
        ILaunchGroup[] iLaunchGroupArray = this.getLaunchGroups();
        int n = iLaunchGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchGroup group;
            extension = group = iLaunchGroupArray[n2];
            if (category == null ? extension.getCategory() == null && extension.getMode().equals(mode) : category.equals(extension.getCategory()) && extension.getMode().equals(mode)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    public ILaunchGroup getLaunchGroup(ILaunchConfigurationType type, Set<String> modeset) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> iter = modeset.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return this.getLaunchGroup(type, buff.toString());
    }

    public static ILaunchConfiguration getSharedTypeConfig(ILaunchConfigurationType type) throws CoreException {
        String id = type.getIdentifier();
        String name = String.valueOf(id) + ".SHARED_INFO";
        ILaunchConfiguration shared = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            if (configuration.getName().equals(name)) {
                shared = configuration;
                break;
            }
            ++n2;
        }
        if (shared == null) {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            shared = workingCopy.doSave();
        }
        return shared;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        try {
            this.persistLaunchHistory();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Internal error saving launch history", (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Internal error saving launch history", (Throwable)e));
        }
    }

    public void setRecentLaunch(ILaunch launch) {
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        int size = groups.length;
        int i = 0;
        while (i < size) {
            String id = groups[i].getIdentifier();
            LaunchHistory history = this.getLaunchHistory(id);
            if (history != null) {
                history.launchAdded(launch);
            }
            ++i;
        }
    }

    static class ShortcutComparator
    implements Comparator<LaunchShortcutExtension> {
        ShortcutComparator() {
        }

        @Override
        public int compare(LaunchShortcutExtension a, LaunchShortcutExtension b) {
            LaunchShortcutExtension shorcutA = a;
            String labelA = shorcutA.getLabel();
            String pathA = shorcutA.getMenuPath();
            LaunchShortcutExtension shortcutB = b;
            String labelB = shortcutB.getLabel();
            String pathB = shortcutB.getMenuPath();
            if (this.nullOrEqual(pathA, pathB)) {
                if (labelA == labelB) {
                    return 0;
                }
                if (labelA == null) {
                    return 1;
                }
                if (labelB == null) {
                    return -1;
                }
                return labelA.compareToIgnoreCase(labelB);
            }
            if (pathA == null) {
                return 1;
            }
            if (pathB == null) {
                return -1;
            }
            return pathA.compareToIgnoreCase(pathB);
        }

        private boolean nullOrEqual(String a, String b) {
            if (a == null) {
                return b == null;
            }
            return a.equals(b);
        }
    }
}

