/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;

public class SystemStartHere {
    public static ISystemRegistry getSystemRegistry() {
        return RSECorePlugin.getTheSystemRegistry();
    }

    public static IHost[] getConnections() {
        return SystemStartHere.getSystemRegistry().getHosts();
    }

    public static IHost[] getConnectionsBySystemType(String systemTypeId) {
        IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(systemTypeId);
        return SystemStartHere.getSystemRegistry().getHostsBySystemType(systemType);
    }

    public static IHost[] getConnectionsBySubSystemConfiguration(ISubSystemConfiguration subsystemConfiguration) {
        return SystemStartHere.getSystemRegistry().getHostsBySubSystemConfiguration(subsystemConfiguration);
    }

    public static IHost[] getConnectionsBySubSystemConfiguration(String subsystemConfigurationId) {
        return SystemStartHere.getSystemRegistry().getHostsBySubSystemConfiguration(SystemStartHere.getSubSystemConfiguration(subsystemConfigurationId));
    }

    public static ISubSystem[] getSubSystems(String subsystemConfigurationId) {
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        ISubSystemConfiguration config = sr.getSubSystemConfiguration(subsystemConfigurationId);
        if (config == null) {
            return new ISubSystem[0];
        }
        return config.getSubSystems(true);
    }

    public static ISubSystem[] getSubSystems(String subsystemConfigurationId, IHost connection) {
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        ISubSystemConfiguration config = sr.getSubSystemConfiguration(subsystemConfigurationId);
        if (config == null) {
            return new ISubSystem[0];
        }
        return config.getSubSystems(connection, true);
    }

    public static ISubSystem getSubSystem(String subsystemConfigurationId, IHost connection) {
        ISubSystem[] subsystems = SystemStartHere.getSubSystems(subsystemConfigurationId, connection);
        if (subsystems == null || subsystems.length == 0) {
            return null;
        }
        return subsystems[0];
    }

    public static ISubSystemConfiguration getSubSystemConfiguration(String subsystemConfigurationId) {
        return SystemStartHere.getSystemRegistry().getSubSystemConfiguration(subsystemConfigurationId);
    }

    public static ISystemProfileManager getSystemProfileManager() {
        return RSECorePlugin.getTheSystemProfileManager();
    }

    public static ISystemProfile[] getActiveSystemProfiles() {
        return SystemStartHere.getSystemRegistry().getActiveSystemProfiles();
    }
}

