/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.internal.browser.ImageResourceManager;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;

public class WebBrowserEditorInput
implements IEditorInput,
IPersistableElement,
IElementFactory {
    private static final String ELEMENT_FACTORY_ID = "org.eclipse.ui.browser.elementFactory";
    private static final String MEMENTO_URL = "url";
    private static final String MEMENTO_STYLE = "style";
    private static final String MEMENTO_ID = "id";
    private static final String MEMENTO_NAME = "name";
    private static final String MEMENTO_TOOLTIP = "tooltip";
    private URL url;
    private int style;
    private String id = null;
    private String name;
    private String tooltip;

    public WebBrowserEditorInput() {
        this(null);
    }

    public WebBrowserEditorInput(URL url) {
        this(url, 0);
    }

    public WebBrowserEditorInput(URL url, int style) {
        this.url = url;
        this.style = style;
    }

    public WebBrowserEditorInput(URL url, int style, String browserId) {
        this.url = url;
        this.style = style;
        this.id = browserId;
    }

    public WebBrowserEditorInput(URL url, boolean b) {
        this(url);
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setToolTipText(String t) {
        this.tooltip = t;
    }

    public boolean canReplaceInput(WebBrowserEditorInput input) {
        Trace.trace(Trace.FINEST, "canReplaceInput " + this + " " + input);
        if (input.isStatusbarVisible() != this.isStatusbarVisible()) {
            return false;
        }
        if (this.id != null) {
            String bid = input.getBrowserId();
            return this.id.equals(bid);
        }
        return false;
    }

    public IAdaptable createElement(IMemento memento) {
        int style = 0;
        Integer integer = memento.getInteger(MEMENTO_STYLE);
        if (integer != null) {
            style = integer;
        }
        URL url = null;
        String str = memento.getString(MEMENTO_URL);
        if (str != null) {
            try {
                url = new URL(str);
            }
            catch (MalformedURLException e) {
                String msg = "Malformed URL while initializing browser editor";
                WebBrowserUIPlugin.logError(msg, e);
            }
        }
        String id = memento.getString(MEMENTO_ID);
        String name = memento.getString(MEMENTO_NAME);
        String tooltip = memento.getString(MEMENTO_TOOLTIP);
        WebBrowserEditorInput input = new WebBrowserEditorInput(url, style, id);
        input.setName(name);
        input.setToolTipText(tooltip);
        return input;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WebBrowserEditorInput)) {
            return false;
        }
        WebBrowserEditorInput other = (WebBrowserEditorInput)obj;
        if (this.url != null ? other.url == null || !this.url.toExternalForm().equals(other.url.toExternalForm()) : other.url != null) {
            return false;
        }
        return this.canReplaceInput(other);
    }

    public boolean exists() {
        return (this.style & 0x10) == 0;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public String getFactoryId() {
        return ELEMENT_FACTORY_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageResourceManager.getImageDescriptor("$nl$/icons/obj16/internal_browser.png");
    }

    protected boolean isNameLocked() {
        return this.name != null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return Messages.viewWebBrowserTitle;
    }

    public IPersistableElement getPersistable() {
        if ((this.style & 0x10) == 0) {
            return null;
        }
        return this;
    }

    public String getToolTipText() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return Messages.viewWebBrowserTitle;
    }

    public URL getURL() {
        return this.url;
    }

    public String getBrowserId() {
        return this.id;
    }

    public boolean isStatusbarVisible() {
        return (this.style & 8) != 0;
    }

    public boolean isLocationBarLocal() {
        return (this.style & 2) != 0;
    }

    public boolean isToolbarLocal() {
        return (this.style & 4) != 0;
    }

    public void saveState(IMemento memento) {
        memento.putInteger(MEMENTO_STYLE, this.style);
        if ((this.style & 0x10) != 0 && this.url != null) {
            memento.putString(MEMENTO_URL, this.url.toExternalForm());
        }
        if (this.id != null) {
            memento.putString(MEMENTO_ID, this.id);
        }
        if (this.name != null) {
            memento.putString(MEMENTO_NAME, this.name);
        }
        if (this.tooltip != null) {
            memento.putString(MEMENTO_TOOLTIP, this.tooltip);
        }
    }

    public String toString() {
        return "WebBrowserEditorInput[" + this.url + " " + this.style + " " + this.id + "]";
    }

    public int hashCode() {
        int result = 0;
        if (this.url != null) {
            result += this.url.toExternalForm().hashCode();
        }
        if (this.id != null) {
            result += this.id.hashCode();
        }
        return result;
    }
}

