"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeActionKind = void 0;
const lsp = __importStar(require("vscode-languageserver/node"));
class CodeActionKind {
    constructor(value) {
        this.value = value;
    }
    equals(other) {
        return this.value === other.value;
    }
    /**
     * Checks if `other` is a sub-kind of this `CodeActionKind`.
     *
     * The kind `"refactor.extract"` for example contains `"refactor.extract"` and ``"refactor.extract.function"`,
     * but not `"unicorn.refactor.extract"`, or `"refactor.extractAll"` or `refactor`.
     *
     * @param other Kind to check.
     */
    contains(other) {
        return this.equals(other) || this.value === '' || other.value.startsWith(this.value + CodeActionKind.sep);
    }
    /**
     * Checks if this code action kind intersects `other`.
     *
     * The kind `"refactor.extract"` for example intersects `refactor`, `"refactor.extract"` and ``"refactor.extract.function"`,
     * but not `"unicorn.refactor.extract"`, or `"refactor.extractAll"`.
     *
     * @param other Kind to check.
     */
    intersects(other) {
        return this.contains(other) || other.contains(this);
    }
    /**
     * Create a new kind by appending a more specific selector to the current kind.
     *
     * Does not modify the current kind.
     */
    append(part) {
        return new CodeActionKind(this.value + CodeActionKind.sep + part);
    }
}
exports.CodeActionKind = CodeActionKind;
CodeActionKind.sep = '.';
CodeActionKind.Empty = new CodeActionKind(lsp.CodeActionKind.Empty);
CodeActionKind.QuickFix = new CodeActionKind(lsp.CodeActionKind.QuickFix);
CodeActionKind.Refactor = new CodeActionKind(lsp.CodeActionKind.Refactor);
CodeActionKind.Source = new CodeActionKind(lsp.CodeActionKind.Source);
CodeActionKind.SourceAddMissingImportsTs = CodeActionKind.Source.append('addMissingImports').append('ts');
CodeActionKind.SourceRemoveUnusedTs = CodeActionKind.Source.append('removeUnused').append('ts');
CodeActionKind.SourceOrganizeImports = new CodeActionKind(lsp.CodeActionKind.SourceOrganizeImports);
CodeActionKind.SourceOrganizeImportsTs = CodeActionKind.SourceOrganizeImports.append('ts');
CodeActionKind.SourceFixAll = new CodeActionKind(lsp.CodeActionKind.SourceFixAll);
CodeActionKind.SourceFixAllTs = CodeActionKind.SourceFixAll.append('ts');
//# sourceMappingURL=types.js.map