/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.NamedRef;

public class ClassRef
extends NamedRef {
    private int implementCount;
    private int subclassCount;
    private int instantiateCount;
    private Map methodRefs;
    private Map fieldRefs;

    public int getImplementCount() {
        return this.implementCount;
    }

    public void setImplementCount(int implementCount) {
        this.implementCount = implementCount;
    }

    public void incImplementCount() {
        ++this.implementCount;
    }

    public int getInstantiateCount() {
        return this.instantiateCount;
    }

    public void setInstantiateCount(int instantiateCount) {
        this.instantiateCount = instantiateCount;
    }

    public void incInstantiateCount() {
        ++this.instantiateCount;
    }

    public int getSubclassCount() {
        return this.subclassCount;
    }

    public void setSubclassCount(int subclassCount) {
        this.subclassCount = subclassCount;
    }

    public void incSubclassCount() {
        ++this.subclassCount;
    }

    public Collection getMethodRefs() {
        if (this.methodRefs != null) {
            return new ArrayList(this.methodRefs.values());
        }
        return Collections.EMPTY_LIST;
    }

    public MethodRef getMethodRef(String name, String descriptor) {
        if (this.methodRefs != null) {
            return (MethodRef)this.methodRefs.get(this.encode(name, descriptor));
        }
        return null;
    }

    public void addMethodRef(MethodRef methodRef) {
        if (this.methodRefs == null) {
            this.methodRefs = new HashMap();
        }
        this.methodRefs.put(this.encode(methodRef.getName(), methodRef.getDescriptor()), methodRef);
    }

    public void removeMethodRef(String name, String descriptor) {
        if (this.methodRefs != null) {
            this.methodRefs.remove(this.encode(name, descriptor));
        }
    }

    public Collection getFieldRefs() {
        if (this.fieldRefs != null) {
            return new ArrayList(this.fieldRefs.values());
        }
        return Collections.EMPTY_LIST;
    }

    public FieldRef getFieldRef(String name, String descriptor) {
        if (this.fieldRefs != null) {
            return (FieldRef)this.fieldRefs.get(this.encode(name, descriptor));
        }
        return null;
    }

    public void addFieldRef(FieldRef fieldRef) {
        if (this.fieldRefs == null) {
            this.fieldRefs = new HashMap();
        }
        this.fieldRefs.put(this.encode(fieldRef.getName(), fieldRef.getDescriptor()), fieldRef);
    }

    public void removeFieldRef(String name, String descriptor) {
        if (this.fieldRefs != null) {
            this.fieldRefs.remove(this.encode(name, descriptor));
        }
    }

    private String encode(String name, String descriptor) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('#');
        sb.append(descriptor);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<class name=\"");
        sb.append(this.getName());
        sb.append("\" ref=\"");
        sb.append(this.getRefCount());
        sb.append("\" impl=\"");
        sb.append(this.getImplementCount());
        sb.append("\" subclass=\"");
        sb.append(this.getSubclassCount());
        sb.append("\" instantiate=\"");
        sb.append(this.getInstantiateCount());
        sb.append("\">");
        Iterator it = this.getMethodRefs().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        it = this.getFieldRefs().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        sb.append("</class>");
        return sb.toString();
    }
}

