/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.PluginRef;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class References {
    private Map pluginRefs;
    private String name;
    private String contactInfo;
    private String refBuildId;
    private String includes;
    private String excludes;
    private String includePlugins;
    private String excludePlugins;

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getRefBuildId() {
        return this.refBuildId;
    }

    public void setRefBuildId(String refBuildId) {
        this.refBuildId = refBuildId;
    }

    public List getPluginRefs() {
        if (this.pluginRefs != null) {
            return new ArrayList(this.pluginRefs.values());
        }
        return new ArrayList(0);
    }

    public PluginRef getPluginRef(String id) {
        if (this.pluginRefs != null) {
            return (PluginRef)this.pluginRefs.get(id);
        }
        return null;
    }

    public void addPluginRef(PluginRef pluginRef) {
        if (this.pluginRefs == null) {
            this.pluginRefs = new HashMap();
        }
        this.pluginRefs.put(pluginRef.getId(), pluginRef);
    }

    public void removePluginRef(String id) {
        if (this.pluginRefs != null) {
            this.pluginRefs.remove(id);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludePlugins() {
        return this.excludePlugins;
    }

    public void setExcludePlugins(String excludePlugins) {
        this.excludePlugins = excludePlugins;
    }

    public String getIncludePlugins() {
        return this.includePlugins;
    }

    public void setIncludePlugins(String includePlugins) {
        this.includePlugins = includePlugins;
    }

    public void load(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(is), (DefaultHandler)new ReferencesHandler());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<references name=\"");
        sb.append(this.getName());
        sb.append("\" contactInfo=\"");
        sb.append(this.getContactInfo());
        sb.append("\" refBuildId=\"");
        sb.append(this.getRefBuildId());
        sb.append("\" includes=\"");
        sb.append(this.getIncludes());
        sb.append("\" excludes=\"");
        sb.append(this.getExcludes());
        sb.append("\" includePlugins=\"");
        sb.append(this.getIncludePlugins());
        sb.append("\" excludePlugins=\"");
        sb.append(this.getExcludePlugins());
        sb.append("\">");
        Iterator it = this.getPluginRefs().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        sb.append("</references>");
        return sb.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutputStream os) throws IOException {
        try {
            os.write("<references name=\"".getBytes());
            String s = this.getName();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" contactInfo=\"".getBytes());
            s = this.getContactInfo();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" refBuildId=\"".getBytes());
            s = this.getRefBuildId();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" includes=\"".getBytes());
            s = this.getIncludes();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" excludes=\"".getBytes());
            s = this.getExcludes();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" includePlugins=\"".getBytes());
            s = this.getIncludePlugins();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\" excludePlugins=\"".getBytes());
            s = this.getExcludePlugins();
            if (s != null) {
                os.write(s.getBytes());
            }
            os.write("\">".getBytes());
            Iterator it = this.getPluginRefs().iterator();
            while (true) {
                block11: {
                    if (it.hasNext()) break block11;
                    os.write("</references>".getBytes());
                    break;
                }
                os.write(it.next().toString().getBytes());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            os.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        os.close();
    }

    private class ReferencesHandler
    extends DefaultHandler {
        private PluginRef pluginRef;
        private ClassRef classRef;

        private ReferencesHandler() {
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (elementName.equals("references") || qName.equals("references")) {
                References.this.setName(attributes.getValue("name"));
                References.this.setContactInfo(attributes.getValue("contactInfo"));
                References.this.setRefBuildId(attributes.getValue("refBuildId"));
                References.this.setIncludes(attributes.getValue("includes"));
                References.this.setExcludes(attributes.getValue("excludes"));
                References.this.setIncludePlugins(attributes.getValue("includePlugins"));
                References.this.setExcludePlugins(attributes.getValue("excludePlugins"));
            } else if (elementName.equals("plugin") || qName.equals("plugin")) {
                this.pluginRef = new PluginRef();
                this.pluginRef.setId(attributes.getValue("id"));
                References.this.addPluginRef(this.pluginRef);
            } else if (elementName.equals("class") || qName.equals("class")) {
                this.classRef = new ClassRef();
                this.classRef.setName(attributes.getValue("name"));
                this.classRef.setRefCount(Integer.parseInt(attributes.getValue("ref")));
                this.classRef.setSubclassCount(Integer.parseInt(attributes.getValue("subclass")));
                this.classRef.setImplementCount(Integer.parseInt(attributes.getValue("impl")));
                this.classRef.setInstantiateCount(Integer.parseInt(attributes.getValue("instantiate")));
                this.pluginRef.addClassRef(this.classRef);
            } else if (elementName.equals("method") || qName.equals("method")) {
                MethodRef methodRef = new MethodRef();
                methodRef.setName(attributes.getValue("name"));
                methodRef.setDescriptor(attributes.getValue("desc"));
                methodRef.setRefCount(Integer.parseInt(attributes.getValue("ref")));
                this.classRef.addMethodRef(methodRef);
            } else if (elementName.equals("field") || qName.equals("field")) {
                FieldRef fieldRef = new FieldRef();
                fieldRef.setName(attributes.getValue("name"));
                fieldRef.setDescriptor(attributes.getValue("desc"));
                fieldRef.setRefCount(Integer.parseInt(attributes.getValue("ref")));
                this.classRef.addFieldRef(fieldRef);
            }
        }

        public void endElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (elementName.equals("plugin") || qName.equals("plugin")) {
                this.pluginRef = null;
            } else if (elementName.equals("class") || qName.equals("class")) {
                this.classRef = null;
            }
        }
    }
}

