/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.IZipLocation;
import org.eclipse.wtp.releng.tools.component.internal.AbstractZipLocation;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.ZipEntryLocation;

public class ZipLocation
extends AbstractZipLocation
implements IZipLocation {
    private ZipFile zipFile;

    public ZipLocation(File file) {
        this(null, file.getAbsolutePath());
    }

    public ZipLocation(ILocation parent, String name) {
        super(parent, name);
        File file = this.getFile();
        if (file.exists()) {
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (ZipException zipException) {
                System.err.println("Could not open " + file);
            }
            catch (IOException iOException) {
                System.err.println("Could not open " + file);
            }
        } else {
            System.err.println(file + " does not exist, skipping");
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public File getFile() {
        if (this.parent == null) {
            return new File(this.name);
        }
        return new File(((FileLocation)this.parent).getFile(), this.name);
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public ILocationChildrenIterator childIterator() {
        return new ZipFileIterator(this.zipFile);
    }

    public boolean hasChildren() {
        return true;
    }

    protected InputStream getChildInputStream(String name) {
        if (this.zipFile == null) {
            return null;
        }
        ZipEntry entry = this.zipFile.getEntry(name);
        if (entry != null) {
            try {
                return this.zipFile.getInputStream(entry);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.parent == null) {
            return this.getName();
        }
        return String.valueOf(this.parent.getAbsolutePath()) + "/" + this.getName();
    }

    protected class ZipFileIterator
    implements ILocationChildrenIterator {
        private ZipFile zipFile;
        private Enumeration entries;

        public ZipFileIterator(ZipFile zip) {
            this.zipFile = zip;
            if (this.zipFile != null) {
                this.entries = this.zipFile.entries();
            }
        }

        public ILocation next() {
            if (this.zipFile == null) {
                return null;
            }
            if (this.entries == null) {
                return null;
            }
            if (this.entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)this.entries.nextElement();
                String name = entry.getName();
                return new ZipEntryLocation(ZipLocation.this, name);
            }
            return null;
        }
    }
}

