/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;

public class XSGYearMonth
extends CalendarType
implements CmpEq {
    private Calendar _calendar;
    private boolean _timezoned;

    public XSGYearMonth(Calendar cal, boolean tz) {
        this._calendar = cal;
        this._timezoned = tz;
    }

    public XSGYearMonth() {
        this(new GregorianCalendar(), false);
    }

    public String type_name() {
        return "gYearMonth";
    }

    public static XSGYearMonth parse_gYearMonth(String str) {
        String lame = "";
        String lame2 = "-01T00:00:00.0";
        boolean tz = false;
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
            if (index == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            lame = str.substring(0, index);
            lame = String.valueOf(lame) + lame2;
            lame = String.valueOf(lame) + str.substring(index, str.length());
            tz = true;
        } else {
            lame = String.valueOf(str) + lame2;
        }
        XSDateTime dt = XSDateTime.parseDateTime(lame);
        if (dt == null) {
            return null;
        }
        return new XSGYearMonth(dt.calendar(), tz);
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSGYearMonth val = XSGYearMonth.parse_gYearMonth(aat.string_value());
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(val);
        return rs;
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.year(), 4);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        if (this.timezoned()) {
            ret = String.valueOf(ret) + "Z";
        }
        return ret;
    }

    public String string_type() {
        return "xs:gYearMonth";
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSGYearMonth val = (XSGYearMonth)NumericType.get_single_type(arg, XSGYearMonth.class);
        return this.calendar().equals(val.calendar());
    }
}

