/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathTimes;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;

public class XDTDayTimeDuration
extends XSDuration
implements CmpEq,
CmpLt,
CmpGt,
MathPlus,
MathMinus,
MathTimes,
MathDiv,
Cloneable {
    private int _days;
    private int _hours;
    private int _minutes;
    private double _seconds;
    private boolean _negative;

    public XDTDayTimeDuration(int days, int hours, int minutes, double seconds, boolean negative) {
        this._days = days;
        this._hours = hours;
        this._minutes = minutes;
        this._seconds = seconds;
        this._negative = negative;
        if (this._seconds >= 60.0) {
            int isec = (int)this._seconds;
            double rem = this._seconds - (double)isec;
            this._minutes += isec / 60;
            this._seconds = isec % 60;
            this._seconds += rem;
        }
        if (this._minutes >= 60) {
            this._hours += this._minutes / 60;
            this._minutes %= 60;
        }
        if (this._hours >= 24) {
            this._days += this._hours / 24;
            this._hours %= 24;
        }
    }

    public XDTDayTimeDuration(double secs) {
        this(0, 0, 0, Math.abs(secs), secs < 0.0);
    }

    public XDTDayTimeDuration() {
        this(0, 0, 0, 0.0, false);
    }

    public Object clone() throws CloneNotSupportedException {
        return new XDTDayTimeDuration(this.days(), this.hours(), this.minutes(), this.seconds(), this.negative());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XDTDayTimeDuration parseDTDuration(String str) {
        boolean negative = false;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        String pstr = null;
        String tstr = null;
        if (str.startsWith("-P")) {
            negative = true;
            pstr = str.substring(2, str.length());
        } else {
            if (!str.startsWith("P")) return null;
            negative = false;
            pstr = str.substring(1, str.length());
        }
        try {
            String digit;
            int index = pstr.indexOf(68);
            boolean did_something = false;
            if (index == -1) {
                if (!pstr.startsWith("T")) return null;
                tstr = pstr.substring(1, pstr.length());
            } else {
                digit = pstr.substring(0, index);
                days = Integer.parseInt(digit);
                tstr = pstr.substring(index + 1, pstr.length());
                if (tstr.startsWith("T")) {
                    tstr = tstr.substring(1, tstr.length());
                } else {
                    if (tstr.length() > 0) {
                        return null;
                    }
                    tstr = "";
                    did_something = true;
                }
            }
            index = tstr.indexOf(72);
            if (index != -1) {
                digit = tstr.substring(0, index);
                hours = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(77)) != -1) {
                digit = tstr.substring(0, index);
                minutes = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(83)) != -1) {
                digit = tstr.substring(0, index);
                seconds = Double.parseDouble(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if (!did_something) return null;
            if (tstr.length() == 0) return new XDTDayTimeDuration(days, hours, minutes, seconds, negative);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String type_name() {
        return "dayTimeDuration";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XDTDayTimeDuration dtd = XDTDayTimeDuration.parseDTDuration(aat.string_value());
        if (dtd == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(dtd);
        return rs;
    }

    public boolean negative() {
        return this._negative;
    }

    public int days() {
        return this._days;
    }

    public int minutes() {
        return this._minutes;
    }

    public int hours() {
        return this._hours;
    }

    public double seconds() {
        return this._seconds;
    }

    public String string_value() {
        String ret = "";
        boolean did_something = false;
        String tret = "";
        if (this.negative()) {
            ret = String.valueOf(ret) + "-";
        }
        ret = String.valueOf(ret) + "P";
        if (this.days() != 0) {
            ret = String.valueOf(ret) + this.days() + "D";
            did_something = true;
        }
        if (this.hours() != 0) {
            tret = String.valueOf(tret) + this.hours() + "H";
            did_something = true;
        }
        if (this.minutes() != 0) {
            tret = String.valueOf(tret) + this.minutes() + "M";
            did_something = true;
        }
        if (this.seconds() != 0.0) {
            tret = String.valueOf(tret) + this.seconds() + "S";
            did_something = true;
        } else if (!did_something) {
            tret = String.valueOf(tret) + "0S";
        }
        if (tret.length() > 0) {
            ret = String.valueOf(ret) + "T" + tret;
        }
        return ret;
    }

    public String string_type() {
        return "xdt:dayTimeDuration";
    }

    public double value() {
        double ret = this.days() * 24 * 60 * 60;
        ret += (double)(this.hours() * 60 * 60);
        ret += (double)(this.minutes() * 60);
        ret += this.seconds();
        if (this.negative()) {
            ret *= -1.0;
        }
        return ret;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        return this.value() == val.value();
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        return this.value() < val.value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        return this.value() > val.value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        double res = this.value() + val.value();
        return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        double res = this.value() - val.value();
        return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val = (XSDouble)NumericType.get_single_type(arg, XSDouble.class);
        double res = this.value() * val.double_value();
        return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        AnyType at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSDouble) {
            XSDouble dt = (XSDouble)at;
            double ret = 0.0;
            if (!dt.zero()) {
                ret = this.value() / dt.double_value();
            }
            return ResultSequenceFactory.create_new(new XDTDayTimeDuration(ret));
        }
        if (at instanceof XDTDayTimeDuration) {
            XDTDayTimeDuration md = (XDTDayTimeDuration)at;
            double res = this.value() / md.value();
            return ResultSequenceFactory.create_new(new XSDecimal(res));
        }
        DynamicError.throw_type_error();
        return null;
    }
}

