/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.w3c.dom.Node;

public class FnDeepEqual
extends Function {
    public FnDeepEqual() {
        super(new QName("deep-equal"), 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnDeepEqual.deep_equal(args);
    }

    public static ResultSequence deep_equal(Collection args) throws DynamicError {
        assert (args.size() == 2);
        Iterator citer = args.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = (ResultSequence)citer.next();
        boolean result = FnDeepEqual.deep_equal(arg1, arg2);
        return ResultSequenceFactory.create_new(new XSBoolean(result));
    }

    public static boolean deep_equal(ResultSequence one, ResultSequence two) {
        if (one.empty() && two.empty()) {
            return true;
        }
        if (one.size() != two.size()) {
            return false;
        }
        ListIterator onei = one.iterator();
        ListIterator twoi = two.iterator();
        while (onei.hasNext()) {
            AnyType b;
            AnyType a = (AnyType)onei.next();
            if (FnDeepEqual.deep_equal(a, b = (AnyType)twoi.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean deep_equal(AnyType one, AnyType two) {
        if (one instanceof AnyAtomicType && two instanceof AnyAtomicType) {
            return FnDeepEqual.deep_equal((AnyAtomicType)one, (AnyAtomicType)two);
        }
        if (one instanceof AnyAtomicType && two instanceof NodeType || one instanceof NodeType && two instanceof AnyAtomicType) {
            return false;
        }
        if (one instanceof NodeType && two instanceof NodeType) {
            return FnDeepEqual.deep_equal((NodeType)one, (NodeType)two);
        }
        assert (false);
        return false;
    }

    public static boolean deep_equal(AnyAtomicType one, AnyAtomicType two) {
        if (!(one instanceof CmpEq)) {
            return false;
        }
        if (!(two instanceof CmpEq)) {
            return false;
        }
        CmpEq a = (CmpEq)((Object)one);
        try {
            return a.eq(two);
        }
        catch (DynamicError dynamicError) {
            return false;
        }
    }

    public static boolean deep_equal(NodeType one, NodeType two) {
        Node a = one.node_value();
        Node b = two.node_value();
        if (a.getNodeType() != b.getNodeType()) {
            return false;
        }
        assert (false);
        return false;
    }
}

