/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultStaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTDayTimeDuration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultDynamicContext
extends DefaultStaticContext
implements DynamicContext {
    private Focus _focus = null;
    private XDTDayTimeDuration _tz = new XDTDayTimeDuration();
    private Hashtable _node_order;

    public DefaultDynamicContext(XSModel schema, Document doc) {
        super(schema);
        this.init_node_order(doc);
    }

    private void init_node_order(Document doc) {
        this._node_order = new Hashtable();
        this.add_node_order(doc, 1);
    }

    private int add_node_order(Node node, int pos) {
        this._node_order.put(node, new Integer(pos));
        ++pos;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attr a = (Attr)attributes.item(i);
                this._node_order.put(a, new Integer(pos));
                ++pos;
                ++i;
            }
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            pos = this.add_node_order(n, pos);
            ++i;
        }
        return pos;
    }

    public XDTDayTimeDuration tz() {
        return this._tz;
    }

    public void set_focus(Focus f) {
        this._focus = f;
    }

    public Focus focus() {
        return this._focus;
    }

    public AnyType context_item() {
        return this._focus.context_item();
    }

    public int context_position() {
        return this._focus.position();
    }

    public int last() {
        return this._focus.last();
    }

    public AnyType get_variable(QName name) {
        if ("fs".equals(name.prefix())) {
            if (name.local().equals("dot")) {
                return this.context_item();
            }
            return null;
        }
        return this.get_var(name);
    }

    public ResultSequence evaluate_function(QName name, Collection args) throws DynamicError {
        Function funct = this.function(name, args.size());
        assert (funct != null);
        return funct.evaluate(args);
    }

    public void add_function_library(FunctionLibrary fl) {
        super.add_function_library(fl);
        fl.set_dynamic_context(this);
    }

    public ResultSequence get_doc(String uri) {
        Document doc = this.retrieve_doc(uri);
        if (doc == null) {
            return null;
        }
        this.init_node_order(doc);
        return ResultSequenceFactory.create_new(new DocType(doc, 0));
    }

    private Document retrieve_doc(String uri) {
        try {
            XercesLoader loader = new XercesLoader();
            loader.set_validating(true);
            Document doc = loader.load(new FileInputStream(uri));
            return doc;
        }
        catch (DOMLoaderException dOMLoaderException) {
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public void set_variable(QName var, AnyType val) {
        super.set_variable(var, val);
    }

    public int node_position(Node node) {
        Integer pos = (Integer)this._node_order.get(node);
        assert (pos != null);
        return pos;
    }
}

