/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingInsertTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingInsertTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingInsertTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingInsertTest.allTests();
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List imports = astRoot.imports();
        SimpleName name = a.newSimpleName("aaa");
        ImportDeclaration importDeclaration = a.newImportDeclaration();
        importDeclaration.setName((Name)name);
        importDeclaration.setOnDemand(true);
        imports.add(importDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("import aaa.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0002() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0002", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        typeDeclaration.setName(name);
        types.add(0, typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("\n");
        buf.append("class AAA {\n");
        buf.append("}\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        typeDeclaration.setName(name);
        types.add(1, typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class AAA {\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        typeDeclaration.setName(name);
        types.add(3, typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class AAA {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0006() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0006", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        List body = typeDeclaration.bodyDeclarations();
        TypeDeclaration typeDeclaration2 = a.newTypeDeclaration();
        typeDeclaration2.setName(a.newSimpleName("Z"));
        body.add(typeDeclaration2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("    class Z {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0007() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0007", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0007;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    public class Y {\n");
        buf.append("    \n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        List body = typeDeclaration.bodyDeclarations();
        TypeDeclaration typeDeclaration2 = a.newTypeDeclaration();
        typeDeclaration2.setName(a.newSimpleName("Z"));
        body.add(typeDeclaration2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0007;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    public class Y {\n");
        buf.append("    \n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    class Z {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0010() throws Exception {
        String source = "\n";
        JavaScriptUnit astRoot = this.createCU(source.toCharArray());
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        PackageDeclaration packageDeclaration = a.newPackageDeclaration();
        packageDeclaration.setName((Name)a.newSimpleName("test0010"));
        astRoot.setPackage(packageDeclaration);
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        typeDeclaration.setName(a.newSimpleName("X"));
        typeDeclaration.setModifiers(1);
        astRoot.types().add(typeDeclaration);
        String preview = this.evaluateRewrite(source, astRoot);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0010;\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0011() throws Exception {
        String source = "\n";
        JavaScriptUnit astRoot = this.createCU(source.toCharArray());
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        PackageDeclaration packageDeclaration = a.newPackageDeclaration();
        packageDeclaration.setName((Name)a.newSimpleName("test0011"));
        astRoot.setPackage(packageDeclaration);
        String preview = this.evaluateRewrite(source, astRoot);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0011;\n");
        buf.append("\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0012() throws Exception {
        String source = "\n";
        JavaScriptUnit astRoot = this.createCU(source.toCharArray());
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        typeDeclaration.setName(a.newSimpleName("X"));
        typeDeclaration.setModifiers(1);
        astRoot.types().add(typeDeclaration);
        String preview = this.evaluateRewrite(source, astRoot);
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }
}

