/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.StringAsserts;
import org.osgi.service.prefs.BackingStoreException;

public class ImportRewriteTest
extends AbstractJavaModelTests {
    private static final Class THIS;
    protected IPackageFragmentRoot sourceFolder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ImportRewriteTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ImportRewriteTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ImportRewriteTest.allTests();
    }

    protected void setUp() throws Exception {
        super.setUp();
        IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"}, new String[]{"JCL_LIB"}, "bin");
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", String.valueOf(99));
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", String.valueOf(1));
        this.sourceFolder = this.getPackageFragmentRoot("P", "src");
        ImportRewriteTest.waitUntilIndexesReady();
    }

    protected void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    public void testAddImports1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.util.Map;\n");
        buf.append("\n");
        buf.append("import pack.List;\n");
        buf.append("import pack.List2;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java", "com", "pack"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.addImport("java.net.Socket");
        imports.addImport("p.A");
        imports.addImport("com.something.Foo");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.net.Socket;\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.util.Map;\n");
        buf.append("\n");
        buf.append("import com.something.Foo;\n");
        buf.append("\n");
        buf.append("import p.A;\n");
        buf.append("\n");
        buf.append("import pack.List;\n");
        buf.append("import pack.List2;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImportsNoEmptyLines() throws Exception {
        this.sourceFolder.getJavaScriptProject().setOption("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", String.valueOf(0));
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java.util", "java.new", "p"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.addImport("java.net.Socket");
        imports.addImport("p.A");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.net.Socket;\n");
        buf.append("import p.A;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImportsMoreEmptyLines() throws Exception {
        this.sourceFolder.getJavaScriptProject().setOption("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", String.valueOf(2));
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java.util", "java.new", "p"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.addImport("java.net.Socket");
        imports.addImport("p.A");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("import java.net.Socket;\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("import p.A;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java", "java.util", "com", "pack"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.addImport("java.x.Socket");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.x.Socket;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set; // comment\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java", "java.util", "com", "pack"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addImport("java.util.Vector");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set; // comment\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testRemoveImports1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.util.Map;\n");
        buf.append("\n");
        buf.append("import pack.List;\n");
        buf.append("import pack.List2;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java", "com", "pack"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.removeImport("java.util.Set");
        imports.removeImport("pack.List");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.util.Map;\n");
        buf.append("\n");
        buf.append("import pack.List2;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testRemoveImports2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("import java.util.Vector; // comment\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java", "com", "pack"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.removeImport("java.util.Vector");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Set;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports_bug23078() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import p.A.*;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 2, 2, true);
        imports.addImport("p.Inner");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import p.Inner;\n");
        buf.append("import p.A.*;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports_bug25113() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.awt.Panel;\n");
        buf.append("\n");
        buf.append("import java.math.BigInteger;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java.awt", "java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addImport("java.applet.Applet");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.awt.Panel;\n");
        buf.append("\n");
        buf.append("import java.applet.Applet;\n");
        buf.append("import java.math.BigInteger;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports_bug42637() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addImport("java.io.Exception");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.io.Exception;\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddImports_bug121428() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("/** comment */\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, false);
        imports.addImport("java.io.Exception");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("/** comment */\n");
        buf.append("import java.io.Exception;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddStaticImports1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"#", "java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addStaticImport("java.lang.Math", "min", true);
        imports.addImport("java.lang.Math");
        imports.addStaticImport("java.lang.Math", "max", true);
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static java.lang.Math.max;\n");
        buf.append("import static java.lang.Math.min;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddStaticImports2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"#", "java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addStaticImport("xx.MyConstants", "SIZE", true);
        imports.addStaticImport("xy.MyConstants", "*", true);
        imports.addImport("xy.MyConstants");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static xx.MyConstants.SIZE;\n");
        buf.append("import static xy.MyConstants.*;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("import xy.MyConstants;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    public void testAddStaticImports3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"#", "java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 3, true);
        imports.addStaticImport("java.lang.Math", "min", true);
        imports.addStaticImport("java.lang.Math", "max", true);
        imports.addStaticImport("java.lang.Math", "abs", true);
        imports.addStaticImport("java.io.File", "pathSeparator", true);
        imports.addStaticImport("java.io.File", "separator", true);
        imports.addImport("java.util.List");
        imports.addImport("java.util.Vector");
        imports.addImport("java.util.ArrayList");
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static java.io.File.pathSeparator;\n");
        buf.append("import static java.io.File.separator;\n");
        buf.append("import static java.lang.Math.*;\n");
        buf.append("\n");
        buf.append("import java.lang.System;\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("import java.util.List;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    private void createClassStub(String pack, String typeName, String typeKind) throws JavaScriptModelException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment(pack, false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package ").append(pack).append(";\n");
        buf.append("public ").append(typeKind).append(" ").append(typeName).append(" {\n");
        buf.append("}\n");
        String content = buf.toString();
        String name = typeName;
        int idx = typeName.indexOf(60);
        if (idx != -1) {
            name = typeName.substring(0, idx);
        }
        pack1.createCompilationUnit(String.valueOf(name) + ".js", content, false, null);
    }

    public void testImportStructureWithSignatures() throws Exception {
        this.createClassStub("java.io", "IOException", "class");
        this.createClassStub("java.net", "URL", "class");
        this.createClassStub("java.util", "List<E>", "interface");
        this.createClassStub("java.net", "SocketAddress", "class");
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.net.*;\n");
        buf.append("import java.io.*;\n");
        buf.append("public class A {\n");
        buf.append("    public void foo() {\n");
        buf.append("        IOException s;\n");
        buf.append("        URL[][] t;\n");
        buf.append("        List<SocketAddress> x;\n");
        buf.append("    }\n");
        buf.append("}\n");
        String content = buf.toString();
        IJavaScriptUnit cu1 = pack1.createCompilationUnit("A.js", content, false, null);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class B {\n");
        buf.append("}\n");
        String content2 = buf.toString();
        IJavaScriptUnit cu2 = pack1.createCompilationUnit("B.js", content2, false, null);
        String[] order = new String[]{"java.util", "java.io", "java.net"};
        int threshold = 99;
        AST ast = AST.newAST((int)3);
        ImportRewrite importsRewrite = this.newImportsRewrite(cu2, order, threshold, threshold, true);
        IJavaScriptElement[] elements = cu1.codeSelect(content.indexOf("IOException"), "IOException".length());
        ImportRewriteTest.assertEquals((int)1, (int)elements.length);
        String key = ((IType)elements[0]).getKey();
        String signature = new BindingKey(key).toSignature();
        importsRewrite.addImportFromSignature(signature, ast);
        elements = cu1.codeSelect(content.indexOf("URL"), "URL".length());
        ImportRewriteTest.assertEquals((int)1, (int)elements.length);
        key = ((IType)elements[0]).getKey();
        signature = new BindingKey(key).toSignature();
        importsRewrite.addImportFromSignature(signature, ast);
        elements = cu1.codeSelect(content.indexOf("List"), "List".length());
        ImportRewriteTest.assertEquals((int)1, (int)elements.length);
        key = ((IType)elements[0]).getKey();
        signature = new BindingKey(key).toSignature();
        importsRewrite.addImportFromSignature(signature, ast);
        this.apply(importsRewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.List;\n");
        buf.append("\n");
        buf.append("import java.io.IOException;\n");
        buf.append("\n");
        buf.append("import java.net.SocketAddress;\n");
        buf.append("import java.net.URL;\n");
        buf.append("\n");
        buf.append("public class B {\n");
        buf.append("}\n");
        this.assertEqualStringIgnoreDelim(cu2.getSource(), buf.toString());
    }

    public void testImportStructureWithSignatures2() throws Exception {
        this.createClassStub("java.util", "Map<S, T>", "interface");
        this.createClassStub("java.util", "Set<S>", "interface");
        this.createClassStub("java.net", "SocketAddress", "class");
        this.createClassStub("java.net", "ServerSocket", "class");
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.net.*;\n");
        buf.append("import java.io.*;\n");
        buf.append("public class A {\n");
        buf.append("    public void foo() {\n");
        buf.append("        Map<?, ? extends Set<? super ServerSocket>> z;\n");
        buf.append("    }\n");
        buf.append("}\n");
        String content = buf.toString();
        IJavaScriptUnit cu1 = pack1.createCompilationUnit("A.js", content, false, null);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class B {\n");
        buf.append("}\n");
        String content2 = buf.toString();
        IJavaScriptUnit cu2 = pack1.createCompilationUnit("B.js", content2, false, null);
        String[] order = new String[]{"java.util", "java.io", "java.net"};
        int threshold = 99;
        AST ast = AST.newAST((int)3);
        ImportRewrite importsRewrite = this.newImportsRewrite(cu2, order, threshold, threshold, true);
        IJavaScriptElement[] elements = cu1.codeSelect(content.indexOf("Map"), "Map".length());
        ImportRewriteTest.assertEquals((int)1, (int)elements.length);
        String key = ((IType)elements[0]).getKey();
        String signature = new BindingKey(key).toSignature();
        importsRewrite.addImportFromSignature(signature, ast);
        this.apply(importsRewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.Map;\n");
        buf.append("import java.util.Set;\n");
        buf.append("\n");
        buf.append("import java.net.ServerSocket;\n");
        buf.append("\n");
        buf.append("public class B {\n");
        buf.append("}\n");
        this.assertEqualStringIgnoreDelim(cu2.getSource(), buf.toString());
    }

    public void testAddedRemovedImportsAPI() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("pack1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("    public final static int CONST= 9;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        String[] order = new String[]{"#", "java"};
        ImportRewrite imports = this.newImportsRewrite(cu, order, 99, 99, true);
        imports.addStaticImport("java.lang.Math", "min", true);
        imports.addImport("java.lang.Math");
        this.assertAddedAndRemoved(imports, new String[]{"java.lang.Math"}, new String[0], new String[]{"java.lang.Math.min"}, new String[0]);
        imports.addImport("java.lang.Math");
        imports.addStaticImport("java.lang.Math", "max", true);
        this.assertAddedAndRemoved(imports, new String[]{"java.lang.Math"}, new String[0], new String[]{"java.lang.Math.min", "java.lang.Math.max"}, new String[0]);
        imports.removeImport("java.lang.Math");
        imports.removeImport("java.util.Vector");
        imports.removeStaticImport("java.lang.Math.dup");
        this.assertAddedAndRemoved(imports, new String[0], new String[]{"java.util.Vector"}, new String[]{"java.lang.Math.min", "java.lang.Math.max"}, new String[0]);
        imports.addImport("java.util.Vector");
        imports.addStaticImport("pack1.C", "CONST", true);
        this.assertAddedAndRemoved(imports, new String[0], new String[0], new String[]{"java.lang.Math.min", "java.lang.Math.max", "pack1.C.CONST"}, new String[0]);
        this.apply(imports);
        buf = new StringBuffer();
        buf.append("package pack1;\n");
        buf.append("\n");
        buf.append("import static java.lang.Math.max;\n");
        buf.append("import static java.lang.Math.min;\n");
        buf.append("import static pack1.C.CONST;\n");
        buf.append("\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class C {\n");
        buf.append("    public final static int CONST= 9;\n");
        buf.append("}\n");
        this.assertEqualString(cu.getSource(), buf.toString());
    }

    private void assertAddedAndRemoved(ImportRewrite imports, String[] expectedAdded, String[] expectedRemoved, String[] expectedAddedStatic, String[] expectedRemovedStatic) {
        this.assertEqualStringsIgnoreOrder(imports.getAddedImports(), expectedAdded);
        this.assertEqualStringsIgnoreOrder(imports.getAddedStaticImports(), expectedAddedStatic);
        this.assertEqualStringsIgnoreOrder(imports.getRemovedImports(), expectedRemoved);
        this.assertEqualStringsIgnoreOrder(imports.getRemovedStaticImports(), expectedRemovedStatic);
    }

    private void assertEqualString(String actual, String expected) {
        StringAsserts.assertEqualString(actual, expected);
    }

    private void assertEqualStringsIgnoreOrder(String[] actual, String[] expecteds) {
        StringAsserts.assertEqualStringsIgnoreOrder(actual, expecteds);
    }

    private void assertEqualStringIgnoreDelim(String actual, String expected) throws IOException {
        StringAsserts.assertEqualStringIgnoreDelim(actual, expected);
    }

    private ImportRewrite newImportsRewrite(IJavaScriptUnit cu, String[] order, int normalThreshold, int staticThreshold, boolean restoreExistingImports) throws CoreException, BackingStoreException {
        ImportRewrite rewrite = ImportRewrite.create((IJavaScriptUnit)cu, (boolean)restoreExistingImports);
        rewrite.setImportOrder(order);
        rewrite.setOnDemandImportThreshold(normalThreshold);
        rewrite.setStaticOnDemandImportThreshold(staticThreshold);
        return rewrite;
    }

    private void apply(ImportRewrite rewrite) throws CoreException, MalformedTreeException, BadLocationException {
        TextEdit edit = rewrite.rewriteImports(null);
        IJavaScriptUnit compilationUnit = rewrite.getCompilationUnit();
        Document document = new Document(compilationUnit.getSource());
        edit.apply((IDocument)document);
        compilationUnit.getBuffer().setContents(document.get());
    }
}

