/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.JavaSearchTests;

public class AbstractJavaSearchGenericTests
extends JavaSearchTests {
    static char[] RESULT_POTENTIAL_MATCH = "*] POTENTIAL_*".toCharArray();
    static char[] RESULT_EXACT_MATCH = "*] EXACT_*".toCharArray();
    static char[] RESULT_ERASURE_MATCH = "*] ERASURE_*".toCharArray();
    int matchRule;

    public AbstractJavaSearchGenericTests(String name, int matchRule) {
        super(name);
        this.matchRule = matchRule;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultCollector.showAccuracy = true;
        this.resultCollector.showRule = true;
    }

    void addResultLine(StringBuffer buffer, char[] line) {
        if (buffer.length() > 0) {
            buffer.append('\n');
        }
        buffer.append(line);
    }

    final String cleanResults(String expected) {
        char[][] lines = CharOperation.splitOn((char)'\n', (char[])expected.toCharArray());
        StringBuffer buffer = new StringBuffer(expected.length());
        int i = 0;
        int n = lines.length;
        while (i < n) {
            this.addResultLine(buffer, lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    protected void assertSearchResults(String message, String expected, AbstractJavaSearchTests.JavaSearchResultCollector collector) {
        String actual = collector.toString();
        String trimmed = this.cleanResults(expected);
        if (!trimmed.equals(actual)) {
            System.out.println(String.valueOf(this.getName()) + " expected result is:");
            System.out.print(this.displayString(actual, this.tabs));
            System.out.println("");
        }
        AbstractJavaSearchGenericTests.assertEquals((String)message, (String)trimmed, (String)actual);
    }

    protected void search(IJavaScriptElement element, int limitTo) throws CoreException {
        this.search(element, limitTo, this.matchRule, this.getJavaSearchScope15(), (SearchRequestor)this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo) throws CoreException {
        this.search(patternString, searchFor, limitTo, this.matchRule, this.getJavaSearchScope15(), this.resultCollector);
    }

    protected void search(IJavaScriptElement element, int limitTo, IJavaScriptSearchScope scope) throws CoreException {
        this.search(element, limitTo, this.matchRule, scope, (SearchRequestor)this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, IJavaScriptSearchScope scope) throws CoreException {
        this.search(patternString, searchFor, limitTo, this.matchRule, scope, this.resultCollector);
    }

    protected void search(IJavaScriptElement element, int limitTo, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        this.search(element, limitTo, this.matchRule, scope, requestor);
    }

    protected void search(String patternString, int searchFor, int limitTo, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        this.search(patternString, searchFor, limitTo, this.matchRule, scope, requestor);
    }
}

