/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTConverterTest
extends ConverterTestSetup {
    static /* synthetic */ Class class$0;

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)2);
    }

    public ASTConverterTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTConverterTest.buildModelTestSuite(clazz);
    }

    public void test00() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0005", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ExpressionStatement statement = (ExpressionStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        Expression expression = statement.getExpression();
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        ArrayAccess arrayAccess = this.ast.newArrayAccess();
        arrayAccess.setArray((Expression)this.ast.newSimpleName("arr"));
        arrayAccess.setIndex((Expression)this.ast.newNumberLiteral("5"));
        methodInvocation.setExpression((Expression)arrayAccess);
        NumberLiteral literal = this.ast.newNumberLiteral("1");
        methodInvocation.arguments().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)methodInvocation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange((ASTNode)expression, "arr[5](1)", source);
    }

    public void test0001() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0001", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        JavaScriptUnit unit = this.ast.newJavaScriptUnit();
        FunctionDeclaration methodDeclaration = this.ast.newFunctionDeclaration();
        methodDeclaration.setConstructor(false);
        methodDeclaration.setName(this.ast.newSimpleName("main"));
        SingleVariableDeclaration variableDeclaration = this.ast.newSingleVariableDeclaration();
        variableDeclaration.setName(this.ast.newSimpleName("args"));
        methodDeclaration.parameters().add(variableDeclaration);
        Block block = this.ast.newBlock();
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newSimpleName("System"), this.ast.newSimpleName("out"));
        methodInvocation.setExpression((Expression)name);
        methodInvocation.setName(this.ast.newSimpleName("println"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" world");
        infixExpression.setRightOperand((Expression)literal);
        methodInvocation.arguments().add(infixExpression);
        ExpressionStatement expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        block.statements().add(expressionStatement);
        methodDeclaration.setBody(block);
        unit.statements().add(methodDeclaration);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)result.subtreeMatch(new ASTMatcher(), (Object)unit));
        String expected = "\tfunction main(args) {\n\t\tSystem.out.println(\"Hello\" + \" world\");\n\t}\n";
        this.checkSourceRange(result, expected, source);
    }

    public void test0002() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0002", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setMember((Expression)this.ast.newSimpleName("Object"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new Object()", source);
    }

    public void test0003() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0003", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        FieldAccess expr = this.ast.newFieldAccess();
        expr.setName(this.ast.newSimpleName("Object"));
        FieldAccess expr2 = this.ast.newFieldAccess();
        expr2.setName(this.ast.newSimpleName("lang"));
        expr2.setExpression((Expression)this.ast.newSimpleName("java"));
        expr.setExpression((Expression)expr2);
        classInstanceCreation.setMember((Expression)expr);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Object()", source);
    }

    public void test0004() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0004", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        FieldAccess expr = this.ast.newFieldAccess();
        expr.setName(this.ast.newSimpleName("Exception"));
        FieldAccess expr2 = this.ast.newFieldAccess();
        expr2.setName(this.ast.newSimpleName("lang"));
        expr2.setExpression((Expression)this.ast.newSimpleName("java"));
        expr.setExpression((Expression)expr2);
        classInstanceCreation.setMember((Expression)expr);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("ERROR");
        classInstanceCreation.arguments().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Exception(\"ERROR\")", source);
    }

    public void test0005() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0005", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ExpressionStatement statement = (ExpressionStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        Expression expression = statement.getExpression();
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        ArrayAccess arrayAccess = this.ast.newArrayAccess();
        arrayAccess.setArray((Expression)this.ast.newSimpleName("arr"));
        arrayAccess.setIndex((Expression)this.ast.newNumberLiteral("5"));
        methodInvocation.setExpression((Expression)arrayAccess);
        NumberLiteral literal = this.ast.newNumberLiteral("1");
        methodInvocation.arguments().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)methodInvocation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange((ASTNode)expression, "arr[5](1)", source);
    }

    public void test0008() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0008", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("1"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("2"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("3"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("4"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)arrayInitializer.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "[1, 2, 3, 4]", source);
    }

    public void test0009() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0009", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        ArrayInitializer innerArrayInitializer = this.ast.newArrayInitializer();
        innerArrayInitializer.expressions().add(this.ast.newNumberLiteral("1"));
        arrayInitializer.expressions().add(innerArrayInitializer);
        innerArrayInitializer = this.ast.newArrayInitializer();
        innerArrayInitializer.expressions().add(this.ast.newNumberLiteral("2"));
        arrayInitializer.expressions().add(innerArrayInitializer);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)arrayInitializer.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "[[1], [2]]", source);
    }

    public void test0013() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0013", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0014() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0014", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i = 0;", source);
    }

    public void test0015() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0015", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("1"));
        assignment.setOperator(Assignment.Operator.ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i = 1;", source);
    }

    public void test0016() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0016", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i += 2;", source);
    }

    public void test0017() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0017", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i -= 2;", source);
    }

    public void test0018() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0018", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i *= 2;", source);
    }

    public void test0019() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0019", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i /= 2;", source);
    }

    public void test0020() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0020", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i &= 2;", source);
    }

    public void test0021() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0021", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i |= 2;", source);
    }

    public void test0022() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0022", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i ^= 2;", source);
    }

    public void test0023() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0023", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i %= 2;", source);
    }

    public void test0024() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0024", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i <<= 2;", source);
    }

    public void test0025() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0025", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i >>= 2;", source);
    }

    public void test0026() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0026", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i >>>= 2;", source);
    }

    public void test0027() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0027", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)prefixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "--i;", source);
    }

    public void test0028() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0028", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)prefixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "++i;", source);
    }

    public void test0029() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0029", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)postfixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i--;", source);
    }

    public void test0030() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0030", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)postfixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i++;", source);
    }

    public void test0042() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0042", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        BooleanLiteral literal = this.ast.newBooleanLiteral(false);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "false", source);
    }

    public void test0043() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0043", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        BooleanLiteral literal = this.ast.newBooleanLiteral(true);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "true", source);
    }

    public void test0044() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0044", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NullLiteral literal = this.ast.newNullLiteral();
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "null", source);
    }

    public void test0045() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0045", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        CharacterLiteral literal = this.ast.newCharacterLiteral();
        literal.setEscapedValue("'c'");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "'c'", source);
    }

    public void test0046() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0046", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("1.00001");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "1.00001", source);
    }

    public void test0047() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0047", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("1.00001f");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "1.00001f", source);
    }

    public void test0048() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0048", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("30000");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "30000", source);
    }

    public void test0049() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0049", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("-2147483648");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-2147483648", source);
    }

    public void test0050() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0050", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("2147483648L");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "2147483648L", source);
    }

    public void test0051() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0051", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("2147483648L");
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)literal);
        prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)prefixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-2147483648L", source);
    }

    public void test0052() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0052", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("-9223372036854775808L");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-9223372036854775808L", source);
    }

    public void test0053() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0053", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\"", source);
    }

    public void test0054() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0054", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b3 = b && b2;", source);
    }

    public void test0055() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0055", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b3 = b || b2;", source);
    }

    public void test0056() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0056", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b3 = b == b2;", source);
    }

    public void test0057() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0057", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i + j;", source);
    }

    public void test0058() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0058", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i - j;", source);
    }

    public void test0059() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0059", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.TIMES);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i * j;", source);
    }

    public void test0060() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0060", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i / j;", source);
    }

    public void test0061() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0061", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i % j;", source);
    }

    public void test0062() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0062", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.XOR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i ^ j;", source);
    }

    public void test0063() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0063", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.AND);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i & j;", source);
    }

    public void test0064() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0064", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.OR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = i | j;", source);
    }

    public void test0065() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0065", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b2 = b < b1;", source);
    }

    public void test0066() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0066", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b2 = b <= b1;", source);
    }

    public void test0067() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0067", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.GREATER);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b2 = b > b1;", source);
    }

    public void test0068() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0068", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b2 = b >= b1;", source);
    }

    public void test0069() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0069", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b2 = b != b1;", source);
    }

    public void test0070() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0070", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b"));
        InfixExpression instanceOfExpression = this.ast.newInfixExpression();
        instanceOfExpression.setLeftOperand((Expression)this.ast.newSimpleName("o"));
        instanceOfExpression.setOperator(InfixExpression.Operator.INSTANCEOF);
        instanceOfExpression.setRightOperand((Expression)this.ast.newSimpleName("Number"));
        variableDeclarationFragment.setInitializer((Expression)instanceOfExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b = o instanceof Number;", source);
    }

    public void test0072() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0072", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b1"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("b"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b1 = !b;", source);
    }

    public void test0073() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0073", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var n = ~i;", source);
    }

    public void test0074() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0074", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
        prefixExpression.setOperand((Expression)this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i = +2;", source);
    }

    public void test0075() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0075", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
        prefixExpression.setOperand((Expression)this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i = -2;", source);
    }

    public void test0076() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0076", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b"));
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        InfixExpression condition = this.ast.newInfixExpression();
        condition.setLeftOperand((Expression)this.ast.newSimpleName("args"));
        condition.setRightOperand((Expression)this.ast.newNullLiteral());
        condition.setOperator(InfixExpression.Operator.NOT_EQUALS);
        conditionalExpression.setExpression((Expression)condition);
        conditionalExpression.setThenExpression((Expression)this.ast.newBooleanLiteral(true));
        conditionalExpression.setElseExpression((Expression)this.ast.newBooleanLiteral(false));
        variableDeclarationFragment.setInitializer((Expression)conditionalExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var b = args != null ? true : false;", source);
    }

    public void test0077() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0077", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        conditionalExpression.setExpression((Expression)this.ast.newBooleanLiteral(true));
        FieldAccess fieldAccess = this.ast.newFieldAccess();
        fieldAccess.setExpression((Expression)this.ast.newSimpleName("args"));
        fieldAccess.setName(this.ast.newSimpleName("length"));
        conditionalExpression.setThenExpression((Expression)fieldAccess);
        conditionalExpression.setElseExpression((Expression)this.ast.newNumberLiteral("0"));
        variableDeclarationFragment.setInitializer((Expression)conditionalExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i = true ? args.length: 0;", source);
    }

    public void test0080() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0080", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        methodInvocation.setName(this.ast.newSimpleName("bar"));
        methodInvocation.arguments().add(this.ast.newNumberLiteral("4"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)methodInvocation);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "bar(4);", source);
    }

    public void test0081() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0081", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        methodInvocation.setName(this.ast.newSimpleName("bar"));
        methodInvocation.setExpression((Expression)this.ast.newThisExpression());
        methodInvocation.arguments().add(this.ast.newNumberLiteral("4"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)methodInvocation);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "this.bar(4);", source);
    }

    public void test0082() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0082", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (;;);", source);
    }

    public void test0083() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0083", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setModifiers(0);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (var i = 0; i < 10; i++) {}", source);
    }

    public void test0084() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0084", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setModifiers(0);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (var i = 0; i < 10; i++);", source);
    }

    public void test0085() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0085", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setModifiers(0);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (var i = 0;; i++);", source);
    }

    public void test0086() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0086", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (; i < 10; i++);", source);
    }

    public void test0087() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0087", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (;;i++);", source);
    }

    public void test0088() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0088", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0090() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0090", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        ArrayInitializer initializer = this.ast.newArrayInitializer();
        initializer.expressions().add(this.ast.newNumberLiteral("1"));
        initializer.expressions().add(this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)initializer);
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setModifiers(0);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var tab = [1, 2];", source);
    }

    public void test0091() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0091", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        FunctionDeclaration method = (FunctionDeclaration)((JavaScriptUnit)result).statements().get(0);
        SingleVariableDeclaration node = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        SingleVariableDeclaration variableDeclaration = this.ast.newSingleVariableDeclaration();
        variableDeclaration.setModifiers(0);
        variableDeclaration.setName(this.ast.newSimpleName("s"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)variableDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)node, "s", source);
    }

    public void test0093() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0093", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)node;
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break;", source);
    }

    public void test0094() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0094", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)node;
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue;", source);
    }

    public void test0095() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0095", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue label;", source);
    }

    public void test0096() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0096", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break label;", source);
    }

    public void test0097() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0097", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        SwitchStatement switchStatement = this.ast.newSwitchStatement();
        switchStatement.setExpression((Expression)this.ast.newSimpleName("i"));
        SwitchCase _case = this.ast.newSwitchCase();
        _case.setExpression((Expression)this.ast.newNumberLiteral("1"));
        switchStatement.statements().add(_case);
        switchStatement.statements().add(this.ast.newBreakStatement());
        _case = this.ast.newSwitchCase();
        _case.setExpression((Expression)this.ast.newNumberLiteral("2"));
        switchStatement.statements().add(_case);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        FieldAccess fieldAccess = this.ast.newFieldAccess();
        fieldAccess.setExpression((Expression)this.ast.newSimpleName("System"));
        fieldAccess.setName(this.ast.newSimpleName("out"));
        methodInvocation.setExpression((Expression)fieldAccess);
        methodInvocation.setName(this.ast.newSimpleName("println"));
        methodInvocation.arguments().add(this.ast.newNumberLiteral("2"));
        ExpressionStatement expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        switchStatement.statements().add(expressionStatement);
        switchStatement.statements().add(this.ast.newBreakStatement());
        _case = this.ast.newSwitchCase();
        _case.setExpression(null);
        switchStatement.statements().add(_case);
        methodInvocation = this.ast.newFunctionInvocation();
        fieldAccess = this.ast.newFieldAccess();
        fieldAccess.setExpression((Expression)this.ast.newSimpleName("System"));
        fieldAccess.setName(this.ast.newSimpleName("out"));
        methodInvocation.setExpression((Expression)fieldAccess);
        methodInvocation.setName(this.ast.newSimpleName("println"));
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("default");
        methodInvocation.arguments().add(literal);
        expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        switchStatement.statements().add(expressionStatement);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)switchStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "switch(i) {\n\t\t\tcase 1: \n              break;\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n              break;\n          default:\n\t\t\t\tSystem.out.println(\"default\");\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
        SwitchStatement switchStatement2 = (SwitchStatement)node;
        List statements = switchStatement2.statements();
        ASTConverterTest.assertEquals((String)"wrong size", (int)7, (int)statements.size());
        Statement stmt = (Statement)statements.get(5);
        ASTConverterTest.assertTrue((String)"Not a case statement", (boolean)(stmt instanceof SwitchCase));
        SwitchCase switchCase = (SwitchCase)stmt;
        ASTConverterTest.assertTrue((String)"Not the default case", (boolean)switchCase.isDefault());
    }

    public void test0098() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0098", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)emptyStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, ";", source);
    }

    public void test0099() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0099", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        DoStatement doStatement = this.ast.newDoStatement();
        Block block = this.ast.newBlock();
        block.statements().add(this.ast.newEmptyStatement());
        doStatement.setBody((Statement)block);
        doStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)doStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "do {;\n\t\t} while(true);";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0100() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0100", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)whileStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "while(true);", source);
    }

    public void test0101() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0101", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)whileStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "while(true) {}", source);
    }

    public void test0102() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0102", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\"", source);
    }

    public void test0103() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0103", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\" + \"!\"", source);
    }

    public void test0104() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0104", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        NumberLiteral numberLiteral = this.ast.newNumberLiteral();
        numberLiteral.setToken("4");
        infixExpression.extendedOperands().add(numberLiteral);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\" + 4", source);
    }

    public void test0105() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0105", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 + 5 + 6 + 4", source);
    }

    public void test0106() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0106", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        InfixExpression infixExpression2 = this.ast.newInfixExpression();
        infixExpression2.setOperator(InfixExpression.Operator.PLUS);
        infixExpression2.setLeftOperand((Expression)infixExpression);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression2.setRightOperand((Expression)literal);
        InfixExpression infixExpression3 = this.ast.newInfixExpression();
        infixExpression3.setOperator(InfixExpression.Operator.PLUS);
        infixExpression3.setLeftOperand((Expression)infixExpression2);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression3.setRightOperand((Expression)literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression3.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 - 5 + 6 + 4", source);
    }

    public void test0107() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0107", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 - 5 - 6 - 4", source);
    }

    public void test0108() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0108", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral stringLiteral = this.ast.newStringLiteral();
        stringLiteral.setLiteralValue("4");
        infixExpression.setLeftOperand((Expression)stringLiteral);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"4\" + 5 + 6 + 4", source);
    }

    public void test0109() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0109", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        StringLiteral stringLiteral = this.ast.newStringLiteral();
        stringLiteral.setLiteralValue("4");
        infixExpression.setLeftOperand((Expression)stringLiteral);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        InfixExpression infixExpression2 = this.ast.newInfixExpression();
        infixExpression2.setOperator(InfixExpression.Operator.PLUS);
        infixExpression2.setLeftOperand((Expression)infixExpression);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression2.setRightOperand((Expression)literal);
        InfixExpression infixExpression3 = this.ast.newInfixExpression();
        infixExpression3.setOperator(InfixExpression.Operator.PLUS);
        infixExpression3.setLeftOperand((Expression)infixExpression2);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression3.setRightOperand((Expression)literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression3.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"4\" - 5 + 6 + 4", source);
    }

    public void test0110() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0110", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)returnStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "return 2;", source);
    }

    public void test0111() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0111", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)returnStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "return 2\\u003B", source);
    }

    public void test0113() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0113", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setBody(this.ast.newBlock());
        tryStatement.setFinally(this.ast.newBlock());
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setModifiers(0);
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t} catch( e) {\n\t\t} finally {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0114() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0114", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setBody(this.ast.newBlock());
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setModifiers(0);
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t} catch(e) {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0115() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0115", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        Block block = this.ast.newBlock();
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        block.statements().add(returnStatement);
        tryStatement.setBody(block);
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setModifiers(0);
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t\treturn 2;\n\t\t} catch(e) {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0116() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0116", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e   \\u003B", source);
    }

    public void test0117() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0117", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e /* comment in the middle of a throw */  \\u003B", source);
    }

    public void test0118() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0118", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e /* comment in the middle of a throw */  \\u003B", source);
    }

    public void test0119() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0119", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "if (true)\\u003B", source);
    }

    public void test0120() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0120", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newEmptyStatement());
        ifStatement.setElseStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true)\\u003B\n\t\telse ;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0121() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0121", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newBlock());
        ifStatement.setElseStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true) {}\n\t\telse ;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0122() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0122", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setThenStatement((Statement)returnStatement);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "if (true) return 2\\u003B", source);
    }

    public void test0123() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0123", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setThenStatement((Statement)returnStatement);
        returnStatement = this.ast.newReturnStatement();
        literal = this.ast.newNumberLiteral();
        literal.setToken("3");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setElseStatement((Statement)returnStatement);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true) return 2;\n\t\telse return 3;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0128() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0128", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNullLiteral());
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setModifiers(0);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (var tab = null;; i++/**/) {}", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).updaters().get(0), "i++", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).initializers().get(0), "var tab = null", source);
    }

    public void test0129() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0129", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationFragment frag = (VariableDeclarationFragment)((VariableDeclarationStatement)node).fragments().get(0);
        ASTConverterTest.assertTrue((String)"Not a declaration", (boolean)frag.getName().isDeclaration());
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        VariableDeclarationStatement var = this.ast.newVariableDeclarationStatement(fragment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)var.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0130() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0130", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("x"));
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("10");
        fragment.setInitializer((Expression)literal);
        VariableDeclarationStatement variableDeclaration = this.ast.newVariableDeclarationStatement(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("y"));
        fragment.setInitializer((Expression)this.ast.newNullLiteral());
        variableDeclaration.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        variableDeclaration.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("j"));
        variableDeclaration.fragments().add(fragment);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)variableDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "var x= 10, y = null, i, j;", source);
        VariableDeclarationFragment[] fragments = ((VariableDeclarationStatement)node).fragments().toArray(new VariableDeclarationFragment[4]);
        ASTConverterTest.assertTrue((String)"fragments.length != 4", (fragments.length == 4 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)fragments[0], "x= 10", source);
        this.checkSourceRange((ASTNode)fragments[1], "y = null", source);
        this.checkSourceRange((ASTNode)fragments[2], "i", source);
        this.checkSourceRange((ASTNode)fragments[3], "j", source);
    }

    public void test0132() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0132", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        JSdoc javadoc = this.ast.newJSdoc();
        javadoc.setComment("/** JavaDoc Comment*/");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)javadoc.subtreeMatch(new ASTMatcher(), (Object)actualJavadoc));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  function foo(i) {}", source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0133() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0133", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "function foo(i) {}", source);
    }

    public void test0134() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0134", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "function foo( i) {}", source);
    }

    public void test0135() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0135", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        JSdoc javadoc = this.ast.newJSdoc();
        javadoc.setComment("/** JavaDoc Comment*/");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)javadoc.subtreeMatch(new ASTMatcher(), (Object)actualJavadoc));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n var i;", source);
    }

    public void test0136() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0136", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0137() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0137", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0150() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0150", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterTest.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed((ASTNode)unit) ? 1 : 0) != 0);
    }

    public void test0152() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0152", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The method is not malformed", (boolean)this.isMalformed(node));
    }

    public void test0153() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0153", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The method is not original", (boolean)this.isOriginal(node));
        ASTConverterTest.assertTrue((String)"The method is not malformed", (boolean)this.isMalformed(node));
    }

    public void test0155() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0155", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"The result is not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)node;
        List parameters = methodDecl.parameters();
        ASTConverterTest.assertTrue((String)"The parameters size is different from 2", (parameters.size() == 2 ? 1 : 0) != 0);
        Object parameter = parameters.get(0);
        ASTConverterTest.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "i", source);
        parameter = parameters.get(1);
        ASTConverterTest.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "b", source);
    }

    public void test0156() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0156", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"The result is not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)node;
        List parameters = methodDecl.parameters();
        ASTConverterTest.assertTrue((String)"The parameters size is different from 1", (parameters.size() == 1 ? 1 : 0) != 0);
        Object parameter = parameters.get(0);
        ASTConverterTest.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "i", source);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterTest.assertTrue((String)"The statements size is different from 2", (statements.size() == 2 ? 1 : 0) != 0);
        ASTNode statement = (ASTNode)statements.get(0);
        ASTConverterTest.assertTrue((String)"The statements[0] is a postfixExpression statement", (boolean)(statement instanceof ExpressionStatement));
    }

    public void test0157() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Test0157.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List statements = compilationUnit.statements();
        ASTConverterTest.assertTrue((String)"The types list is empty", (statements.size() != 0 ? 1 : 0) != 0);
        Statement bodyDeclaration = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterTest.assertTrue((String)"The fragment list is empty", (variableFragments.size() != 0 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"the field binding is null", (Object)variableBinding);
        ASTConverterTest.assertTrue((String)"The field binding is not canonical", (variableBinding == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding typeBinding = variableBinding.getType();
        ASTConverterTest.assertTrue((String)"The type binding for the field is not canonical", (typeBinding == variableBinding.getType() ? 1 : 0) != 0);
        SimpleName name = fragment.getName();
        ASTConverterTest.assertTrue((String)"is a declaration", (boolean)name.isDeclaration());
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"wrong type", (int)3, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"is a field", (!((IVariableBinding)binding).isField() ? 1 : 0) != 0);
    }

    public void test0158() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Test0158.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List statements = compilationUnit.statements();
        ASTConverterTest.assertTrue((String)"The types list is empty", (statements.size() != 0 ? 1 : 0) != 0);
        Statement bodyDeclaration = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterTest.assertTrue((String)"The fragment list is empty", (variableFragments.size() != 0 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"the field binding is null", (Object)variableBinding);
        ASTConverterTest.assertTrue((String)"The field binding is not canonical", (variableBinding == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterTest.assertTrue((String)"The type binding for the field is not canonical", (typeBinding2 == variableBinding.getType() ? 1 : 0) != 0);
    }

    public void test0160() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0160", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List statements = compilationUnit.statements();
        ASTConverterTest.assertTrue((String)"The statements list is empty", (statements.size() != 0 ? 1 : 0) != 0);
        Statement bodyDeclaration = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterTest.assertTrue((String)"The fragment list size is not 2", (variableFragments.size() == 2 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding1 = fragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"the field binding is null", (Object)variableBinding1);
        ASTConverterTest.assertTrue((String)"The field binding is not canonical", (variableBinding1 == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding type1 = variableBinding1.getType();
        ASTConverterTest.assertNotNull((String)"The type is null", (Object)type1);
        ASTConverterTest.assertTrue((String)"The field type is canonical", (type1 == variableBinding1.getType() ? 1 : 0) != 0);
        fragment = (VariableDeclarationFragment)variableFragments.get(1);
        IVariableBinding variableBinding2 = fragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"the field binding is null", (Object)variableBinding2);
        ASTConverterTest.assertTrue((String)"The field binding is not canonical", (variableBinding2 == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding type2 = variableBinding2.getType();
        type2 = variableBinding2.getType();
        ASTConverterTest.assertNotNull((String)"The type is null", (Object)type2);
        ASTConverterTest.assertTrue((String)"The field type is canonical", (type2 == variableBinding2.getType() ? 1 : 0) != 0);
        ASTConverterTest.assertTrue((String)"type1.id < type2.id", (variableBinding1.getVariableId() < variableBinding2.getVariableId() ? 1 : 0) != 0);
    }

    public void test0166() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0166", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"Fragment list is not 4 ", (fragments.size() == 4 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment1 = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding binding1 = fragment1.resolveBinding();
        ASTConverterTest.assertNotNull((String)"Binding is null", (Object)binding1);
        ASTConverterTest.assertEquals((String)"wrong name for binding1", (String)"x", (String)binding1.getName());
        ASTConverterTest.assertEquals((String)"wrong modifier for binding1", (int)0, (int)binding1.getModifiers());
        ASTConverterTest.assertTrue((String)"a field", (!binding1.isField() ? 1 : 0) != 0);
        ITypeBinding typeBinding1 = binding1.getType();
        ASTConverterTest.assertNotNull((String)"typeBinding1 is null", (Object)typeBinding1);
        VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fragments.get(1);
        IVariableBinding binding2 = fragment2.resolveBinding();
        ASTConverterTest.assertNotNull((String)"Binding is null", (Object)binding2);
        ASTConverterTest.assertEquals((String)"wrong name for binding2", (String)"z", (String)binding2.getName());
        ASTConverterTest.assertEquals((String)"wrong modifier for binding2", (int)0, (int)binding2.getModifiers());
        ASTConverterTest.assertTrue((String)"a field", (!binding2.isField() ? 1 : 0) != 0);
        ITypeBinding typeBinding2 = binding2.getType();
        ASTConverterTest.assertNotNull((String)"typeBinding2 is null", (Object)typeBinding2);
        VariableDeclarationFragment fragment3 = (VariableDeclarationFragment)fragments.get(2);
        IVariableBinding binding3 = fragment3.resolveBinding();
        ASTConverterTest.assertNotNull((String)"Binding is null", (Object)binding3);
        ASTConverterTest.assertEquals((String)"wrong name for binding3", (String)"i", (String)binding3.getName());
        ASTConverterTest.assertEquals((String)"wrong modifier for binding3", (int)0, (int)binding3.getModifiers());
        ASTConverterTest.assertTrue((String)"a field", (!binding3.isField() ? 1 : 0) != 0);
        ITypeBinding typeBinding3 = binding3.getType();
        ASTConverterTest.assertNotNull((String)"typeBinding3 is null", (Object)typeBinding3);
        ASTConverterTest.assertEquals((String)"dimension is 0", (int)0, (int)typeBinding3.getDimensions());
        ASTConverterTest.assertEquals((String)"it is not the primitive type any", (String)"any", (String)typeBinding3.getName());
        VariableDeclarationFragment fragment4 = (VariableDeclarationFragment)fragments.get(3);
        IVariableBinding binding4 = fragment4.resolveBinding();
        ASTConverterTest.assertNotNull((String)"Binding is null", (Object)binding4);
        ASTConverterTest.assertEquals((String)"wrong name for binding4", (String)"j", (String)binding4.getName());
        ASTConverterTest.assertEquals((String)"wrong modifier for binding4", (int)0, (int)binding4.getModifiers());
        ASTConverterTest.assertTrue((String)"a field", (!binding4.isField() ? 1 : 0) != 0);
        ASTConverterTest.assertNull((String)"declaring class is not null", (Object)binding4.getDeclaringClass());
        ITypeBinding typeBinding4 = binding4.getType();
        ASTConverterTest.assertNotNull((String)"typeBinding4 is null", (Object)typeBinding4);
        ASTConverterTest.assertTrue((String)"ids in the wrong order", (binding1.getVariableId() < binding2.getVariableId() ? 1 : 0) != 0);
        ASTConverterTest.assertTrue((String)"ids in the wrong order", (binding2.getVariableId() < binding3.getVariableId() ? 1 : 0) != 0);
        ASTConverterTest.assertTrue((String)"ids in the wrong order", (binding3.getVariableId() < binding4.getVariableId() ? 1 : 0) != 0);
    }

    public void test0172() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0172", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterTest.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List statements = compilationUnit.statements();
        ASTConverterTest.assertTrue((String)"The statements list is empty", (statements.size() != 0 ? 1 : 0) != 0);
        ASTConverterTest.assertEquals((String)"statements size != 3", (int)3, (int)statements.size());
        FunctionDeclaration method1 = (FunctionDeclaration)statements.get(0);
        IFunctionBinding methodBinding1 = method1.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No method binding for foo", (Object)methodBinding1);
        SimpleName simpleName = method1.getName();
        ASTConverterTest.assertTrue((String)"not a declaration", (boolean)simpleName.isDeclaration());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)binding.getName(), (String)simpleName.getIdentifier());
        ASTConverterTest.assertEquals((String)"wrong modifier", (int)1, (int)methodBinding1.getModifiers());
        ASTConverterTest.assertEquals((String)"wrong name for method", (String)"foo", (String)methodBinding1.getName());
        ITypeBinding[] parameters = methodBinding1.getParameterTypes();
        ASTConverterTest.assertNotNull((String)"No parameters", (Object)parameters);
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)parameters.length);
        ASTConverterTest.assertEquals((String)"wrong return type", (String)"void", (String)methodBinding1.getReturnType().getName());
        FunctionDeclaration method2 = (FunctionDeclaration)statements.get(1);
        IFunctionBinding methodBinding2 = method2.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No method binding for main", (Object)methodBinding2);
        ASTConverterTest.assertEquals((String)"wrong name for method", (String)"main", (String)methodBinding2.getName());
        ITypeBinding[] parameters2 = methodBinding2.getParameterTypes();
        ASTConverterTest.assertNotNull((String)"No parameters", (Object)parameters2);
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)parameters2.length);
        ASTConverterTest.assertEquals((String)"wrong return type", (String)"void", (String)methodBinding2.getReturnType().getName());
        FunctionDeclaration method3 = (FunctionDeclaration)statements.get(2);
        IFunctionBinding methodBinding3 = method3.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No method binding for main", (Object)methodBinding3);
        ASTConverterTest.assertEquals((String)"wrong name for method", (String)"bar", (String)methodBinding3.getName());
        ITypeBinding[] parameters3 = methodBinding3.getParameterTypes();
        ASTConverterTest.assertNotNull((String)"No parameters", (Object)parameters3);
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)parameters3.length);
        ASTConverterTest.assertEquals((String)"wrong type", (String)"any", (String)parameters3[0].getName());
        ASTConverterTest.assertEquals((String)"wrong return type", (String)"any", (String)methodBinding3.getReturnType().getName());
        ASTConverterTest.assertTrue((String)"The binding is not canonical", (parameters3[0] == methodBinding3.getReturnType() ? 1 : 0) != 0);
    }

    public void test0173() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0173", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        ASTConverterTest.assertTrue((String)"a declaration", (!name.isDeclaration() ? 1 : 0) != 0);
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0174() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0174", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node2;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0175() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0175", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node2;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        fragment.resolveBinding();
        ITypeBinding typeBinding = fragment.getInitializer().resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not Number", (String)"Number", (String)typeBinding.getName());
    }

    public void test0177() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0177", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 1, 1);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertEquals((String)"return type is not Number", (String)"Number", (String)variableBinding.getType().getName());
        ASTConverterTest.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0179() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0179", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
    }

    public void test0182() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0182", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10", source);
    }

    public void test0183() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0183", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10 && i < 20", source);
    }

    public void test0184() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0184", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10 || i < 20", source);
    }

    public void test0185() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0185", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i == 10", source);
    }

    public void test0186() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0186", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "o == o", source);
    }

    public void test0187() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0187", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"IfStatement", (boolean)(node2 instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node2;
        Expression expr = whileStatement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i <= 10", source);
    }

    public void test0188() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0188", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterTest.assertTrue((String)"DoStatement", (boolean)(node2 instanceof DoStatement));
        DoStatement statement = (DoStatement)node2;
        Expression expr = statement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i <= 10", source);
    }

    public void test0189() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0189", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"ForStatement", (boolean)(node2 instanceof ForStatement));
        ForStatement statement = (ForStatement)node2;
        Expression expr = statement.getExpression();
        ASTConverterTest.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10", source);
    }

    public void test0191() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0191", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression ex = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Assignment", (boolean)(ex instanceof Assignment));
        Assignment statement = (Assignment)ex;
        Expression rightExpr = statement.getRightHandSide();
        ASTConverterTest.assertTrue((String)"Not an infix expression", (boolean)(rightExpr instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)rightExpr;
        Expression expr = infixExpression.getRightOperand();
        ASTConverterTest.assertNotNull((String)"No right hand side expression", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "2 < 20", source);
    }

    public void test0192() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0192", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)initialization, "0", source);
    }

    public void test0198() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0198", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"ReturnStatement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an infixExpression", (boolean)(expr instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)expr;
        Expression left = infixExpression.getLeftOperand();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression", (boolean)(left instanceof InfixExpression));
        InfixExpression infixExpression2 = (InfixExpression)left;
        Expression right = infixExpression2.getRightOperand();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression", (boolean)(right instanceof InfixExpression));
        InfixExpression infixExpression3 = (InfixExpression)right;
        ASTConverterTest.assertEquals((String)"A multiplication", (Object)InfixExpression.Operator.TIMES, (Object)infixExpression3.getOperator());
        ITypeBinding typeBinding = infixExpression3.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not Number", (String)"Number", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)infixExpression3, "20 * 30", source);
    }

    public void test0199() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0199", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not an infixExpression", (boolean)(initialization instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)initialization;
        Expression left = infixExpression.getLeftOperand();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression", (boolean)(left instanceof InfixExpression));
        InfixExpression infixExpression2 = (InfixExpression)left;
        Expression right = infixExpression2.getRightOperand();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression", (boolean)(right instanceof InfixExpression));
        InfixExpression infixExpression3 = (InfixExpression)right;
        ASTConverterTest.assertEquals((String)"A multiplication", (Object)InfixExpression.Operator.TIMES, (Object)infixExpression3.getOperator());
        ITypeBinding typeBinding = infixExpression3.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Not Number", (String)"Number", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)infixExpression3, "10 * 30", source);
    }

    public void test0201() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0201", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"ForStatement", (boolean)(node2 instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node2;
        List initializers = forStatement.initializers();
        ASTConverterTest.assertTrue((String)"wrong size", (initializers.size() == 1 ? 1 : 0) != 0);
        Expression init = (Expression)initializers.get(0);
        this.checkSourceRange((ASTNode)init, "var i= 0", source);
    }

    public void test0202() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0202", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var f= (2);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        this.checkSourceRange((ASTNode)initialization, "(2)", source);
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"not Number", (String)"Number", (String)typeBinding.getName());
    }

    public void test0203() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0203", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var f= (2);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)initialization;
        this.checkSourceRange((ASTNode)parenthesizedExpression, "(2)", source);
        Expression expr = parenthesizedExpression.getExpression();
        this.checkSourceRange((ASTNode)expr, "2", source);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"not Number", (String)"Number", (String)typeBinding.getName());
    }

    public void test0204() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0204", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var f= ((2));", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)initialization;
        this.checkSourceRange((ASTNode)parenthesizedExpression, "((2))", source);
        Expression expr = parenthesizedExpression.getExpression();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (boolean)(expr instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression2 = (ParenthesizedExpression)expr;
        this.checkSourceRange((ASTNode)parenthesizedExpression2, "(2)", source);
        expr = parenthesizedExpression2.getExpression();
        this.checkSourceRange((ASTNode)expr, "2", source);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"not Number", (String)"Number", (String)typeBinding.getName());
        typeBinding = parenthesizedExpression.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"not Number", (String)"Number", (String)typeBinding.getName());
    }

    public void test0207() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0207", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        JSdoc javadoc = this.ast.newJSdoc();
        javadoc.setComment("/** JavaDoc Comment*/");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)javadoc.subtreeMatch(new ASTMatcher(), (Object)actualJavadoc));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n function foo( i) {}", source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0208() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0208", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "function foo( i) {}", source);
    }

    public void test0209() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0209", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "function foo( i) {}", source);
    }

    public void test0210() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0210", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        JSdoc javadoc = this.ast.newJSdoc();
        javadoc.setComment("/** JavaDoc Comment*/");
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)javadoc.subtreeMatch(new ASTMatcher(), (Object)actualJavadoc));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  var i;", source);
    }

    public void test0211() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0211", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0212() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0212", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "var i;", source);
    }

    public void test0213() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0213", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterTest.assertTrue((String)"The node is not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        JSdoc actualJavadoc = ((VariableDeclarationStatement)node).getJavadoc();
        ASTConverterTest.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        String expectedContents = "var i;";
        this.checkSourceRange(node, expectedContents, source);
    }

    public void test0225() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0225", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        this.checkSourceRange((ASTNode)labeledStatement.getLabel(), "label", source);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue label;", source);
        this.checkSourceRange((ASTNode)statement.getLabel(), "label", source);
    }

    public void test0226() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0226", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        this.checkSourceRange((ASTNode)labeledStatement.getLabel(), "label", source);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break label;", source);
        this.checkSourceRange((ASTNode)statement.getLabel(), "label", source);
    }

    public void test0235() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0235", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"The fiels is not malformed", (!this.isMalformed(node) ? 1 : 0) != 0);
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"problems found", (int)0, (int)unit.getMessages().length);
        ASTConverterTest.assertEquals((String)"problems found", (int)0, (int)unit.getProblems().length);
        ASTConverterTest.assertTrue((String)"VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)variableBinding);
    }

    public void test0236() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0236", "Test.js");
        IField field = sourceUnit.getField("i");
        ASTConverterTest.assertNotNull((String)"No field", (Object)field);
        field.delete(true, null);
    }

    public void test0237() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "junit.framework", "TestCase.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0241() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0241", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        node = this.getASTNode((JavaScriptUnit)result, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 2);
        ASTConverterTest.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 3);
        ASTConverterTest.assertTrue((String)"Not a field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        node = this.getASTNode((JavaScriptUnit)result, 0, 4);
        ASTConverterTest.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 5);
        ASTConverterTest.assertTrue((String)"Not a field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        node = this.getASTNode((JavaScriptUnit)result, 0, 6);
        ASTConverterTest.assertTrue((String)"Not a field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        node = this.getASTNode((JavaScriptUnit)result, 0, 7);
        ASTConverterTest.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
    }

    public void test0243() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0243", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a try statement", (boolean)(node instanceof TryStatement));
        TryStatement tryStatement = (TryStatement)node;
        List catchClauses = tryStatement.catchClauses();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)catchClauses.size());
        CatchClause catchClause = (CatchClause)catchClauses.get(0);
        this.checkSourceRange((ASTNode)catchClause, "catch (e){m();}", source);
    }

    public void test0244() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0244", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a try statement", (boolean)(node instanceof TryStatement));
        TryStatement tryStatement = (TryStatement)node;
        List catchClauses = tryStatement.catchClauses();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)catchClauses.size());
        CatchClause catchClause = (CatchClause)catchClauses.get(0);
        this.checkSourceRange((ASTNode)catchClause, "catch (e){m();}", source);
    }

    public void test0245() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0245", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expr = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"not a name", (boolean)(expr instanceof Name));
        Name name = (Name)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterTest.assertEquals((String)"Not i", (String)"i", (String)variableBinding.getName());
        ASTConverterTest.assertEquals((String)"Not Number", (String)"Number", (String)variableBinding.getType().getName());
        ASTNode declaringNode = unit.findDeclaringNode((IBinding)variableBinding);
        ASTConverterTest.assertNotNull((String)"No declaring node", (Object)declaringNode);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationFragment", (boolean)(declaringNode instanceof VariableDeclarationFragment));
    }

    public void test0248() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0248", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        SimpleName name = singleVariableDeclaration.getName();
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"i", (String)variableBinding.getName());
        ASTConverterTest.assertEquals((String)"Wrong type", (String)"any", (String)variableBinding.getType().getName());
    }

    public void test0253() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0253", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a classinstancecreation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        IFunctionBinding methodBinding = classInstanceCreation.resolveConstructorBinding();
        ASTConverterTest.assertNotNull((String)"No methodBinding", (Object)methodBinding);
        ASTConverterTest.assertTrue((String)"Not a constructor", (boolean)methodBinding.isConstructor());
    }

    public void test0259() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0259", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0261() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0261", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"Wrong msg size", (int)1, (int)compilationUnit.getMessages().length);
        ASTConverterTest.assertEquals((String)"Wrong pb size", (int)1, (int)compilationUnit.getProblems().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ITypeBinding binding = expression.resolveTypeBinding();
        ASTConverterTest.assertNull((String)"got a binding", (Object)binding);
    }

    public void test0262() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0262", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expr = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        List arguments = methodInvocation.arguments();
        ASTConverterTest.assertEquals((String)"Wrong argument list size", (int)1, (int)arguments.size());
        Expression expr2 = (Expression)arguments.get(0);
        ASTConverterTest.assertTrue((String)"Not a class instance creation", (boolean)(expr2 instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expr2;
        arguments = classInstanceCreation.arguments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)arguments.size());
        Expression expression2 = (Expression)arguments.get(0);
        ASTConverterTest.assertTrue((String)"Not a string literal", (boolean)(expression2 instanceof StringLiteral));
        StringLiteral stringLiteral = (StringLiteral)expression2;
        ITypeBinding typeBinding = stringLiteral.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"String", (String)typeBinding.getName());
    }

    public void test0263() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0263", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expr = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        List arguments = methodInvocation.arguments();
        ASTConverterTest.assertEquals((String)"Wrong argument list size", (int)1, (int)arguments.size());
        Expression expr2 = (Expression)arguments.get(0);
        ASTConverterTest.assertTrue((String)"Not a simple name", (boolean)(expr2 instanceof SimpleName));
        SimpleName simpleName = (SimpleName)expr2;
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0265() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0265", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0272() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0272", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a For statement", (boolean)(node instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (var i= 0; i < 10; i++) foo();", source);
        Statement action = forStatement.getBody();
        this.checkSourceRange((ASTNode)action, "foo();", source);
    }

    public void test0273() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0273", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a For statement", (boolean)(node instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (var i= 0; i < 10; i++) { foo(); }", source);
        Statement action = forStatement.getBody();
        this.checkSourceRange((ASTNode)action, "{ foo(); }", source);
        ASTConverterTest.assertTrue((String)"Not a block", (boolean)(action instanceof Block));
        Block block = (Block)action;
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        this.checkSourceRange((ASTNode)stmt, "foo();", source);
    }

    public void test0274() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0274", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a While statement", (boolean)(node instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while (i < 10) { foo(i++); }", source);
        Statement action = whileStatement.getBody();
        this.checkSourceRange((ASTNode)action, "{ foo(i++); }", source);
        ASTConverterTest.assertTrue((String)"Not a block", (boolean)(action instanceof Block));
        Block block = (Block)action;
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        this.checkSourceRange((ASTNode)stmt, "foo(i++);", source);
    }

    public void test0275() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0275", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a While statement", (boolean)(node instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while (i < 10) foo(i++);", source);
        Statement action = whileStatement.getBody();
        this.checkSourceRange((ASTNode)action, "foo(i++);", source);
    }

    public void test0276() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0276", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "function foo() {\n\t\tfoo();\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        expectedSource = "{\n\t\tfoo();\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration.getBody(), expectedSource, source);
    }

    public void test0277() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0277", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "function foo() {\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        expectedSource = "{\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration.getBody(), expectedSource, source);
    }

    public void test0280() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0280", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        AST newAst = result.getAST();
        ITypeBinding typeBinding = newAst.resolveWellKnownType("Boolean");
        ASTConverterTest.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Boolean", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("String");
        ASTConverterTest.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"String", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("Number");
        ASTConverterTest.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Number", (String)typeBinding.getName());
    }

    public void test0281() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0281", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var o= /*]*/new Object()/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "new Object()", source);
    }

    public void test0282() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0282", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var b = /*]*/true/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "true", source);
    }

    public void test0283() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0283", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var c = /*]*/'c'/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "'c'", source);
    }

    public void test0284() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0284", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var o = /*]*/null/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "null", source);
    }

    public void test0286() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0286", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var i = /**/(2)/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "(2)", source);
    }

    public void test0287() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0287", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var tab = /**/new String/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "new String", source);
    }

    public void test0288() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0288", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var tab = /**/[]/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "[]", source);
    }

    public void test0289() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0289", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var s = /**/tab1[0]/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "tab1[0]", source);
    }

    public void test0292() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0292", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a FieldAccess", (boolean)(expression instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)expression;
        SimpleName simpleName = fieldAccess.getName();
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"x", (String)simpleName.getIdentifier());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"NO binding", (Object)binding);
        ASTConverterTest.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        ASTConverterTest.assertEquals((String)"wrong name", (String)"x", (String)binding.getName());
        Expression expr = fieldAccess.getExpression();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName simpleName2 = (SimpleName)expr;
        IBinding binding2 = simpleName2.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterTest.assertTrue((String)"Not a type binding", (boolean)(binding2 instanceof ITypeBinding));
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Test", (String)binding2.getName());
    }

    public void test0294() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0294", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "function fails() {\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        Block block = methodDeclaration.getBody();
        expectedSource = "{\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)block, expectedSource, source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        methodDeclaration = (FunctionDeclaration)node;
        block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0295() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0295", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"not a method invocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        ITypeBinding typeBinding = methodInvocation.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"type binding is null", (Object)typeBinding);
    }

    public void test0296() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0296", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "function fails() {\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        Block block = methodDeclaration.getBody();
        expectedSource = "{\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)block, expectedSource, source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        methodDeclaration = (FunctionDeclaration)node;
        block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0297() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0297", "Test.js");
        this.runConversion(sourceUnit, false);
    }

    public void test0299() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0299", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var i = (/**/2/**/);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (boolean)(expression instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
        Expression expression2 = parenthesizedExpression.getExpression();
        this.checkSourceRange((ASTNode)expression2, "2", source);
    }

    public void test0300() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0300", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var b = /**/true/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "true", source);
    }

    public void test0301() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0301", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "var o = /**/null/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "null", source);
    }

    public void test0302() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0302", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a DoStatement", (boolean)(node instanceof DoStatement));
        DoStatement doStatement = (DoStatement)node;
        String expectedSource = "do\n\t\t\tfoo();\n\t\twhile(1 < 10);";
        this.checkSourceRange((ASTNode)doStatement, expectedSource, source);
    }

    public void test0303() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0303", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
        Assignment assignment = (Assignment)expression2;
        Expression expression = assignment.getRightHandSide();
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Number", (String)typeBinding.getName());
    }

    public void test0304() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0304", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        this.checkSourceRange(node, "function foo(arg);", source);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        ASTConverterTest.assertNull((String)"Has a body", (Object)block);
    }

    public void test0309() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0309", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a conditional expression", (boolean)(expression instanceof ConditionalExpression));
        ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
        ITypeBinding typeBinding = conditionalExpression.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"Number", (String)typeBinding.getName());
    }

    public void test0310() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0310", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a fieldAccess", (boolean)(expression instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)expression;
        SimpleName qualifier = (SimpleName)fieldAccess.getExpression();
        IBinding binding = qualifier.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"I", (String)binding.getName());
    }

    public void test0313() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0313", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression", (boolean)(expression instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)expression;
        this.checkSourceRange((ASTNode)infixExpression, "i+j", source);
        Expression expression2 = infixExpression.getLeftOperand();
        this.checkSourceRange((ASTNode)expression2, "i", source);
        ASTConverterTest.assertTrue((String)"Not a name", (boolean)(expression2 instanceof Name));
        Name name = (Name)expression2;
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTNode astNode = compilationUnit.findDeclaringNode(binding);
        ASTConverterTest.assertNotNull((String)"No declaring node", (Object)astNode);
        this.checkSourceRange(astNode, "i", source);
    }

    public void test0314() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0314", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTConverterTest.assertNotNull((String)"No result", (Object)result);
        ASTConverterTest.assertTrue((String)"Not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"Wrong line number", (int)1, (int)compilationUnit.getLineNumber(0));
        ASTConverterTest.assertEquals((String)"Wrong line number", (int)1, (int)compilationUnit.getLineNumber(source.length - 1));
        ASTConverterTest.assertEquals((String)"Wrong line number", (int)-1, (int)compilationUnit.getLineNumber(source.length));
    }

    public void test0315() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0315", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a Return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an InfixExpression expression", (boolean)(expression instanceof InfixExpression));
        InfixExpression instanceOfExpression = (InfixExpression)expression;
        Expression rightOperand = instanceOfExpression.getRightOperand();
        ASTConverterTest.assertTrue((String)"Not a SimpleName", (boolean)(rightOperand instanceof SimpleName));
        SimpleName simpleType = (SimpleName)rightOperand;
        ASTConverterTest.assertTrue((String)"wrong operator", (boolean)instanceOfExpression.getOperator().equals(InfixExpression.Operator.INSTANCEOF));
        this.checkSourceRange((ASTNode)simpleType, "String", source);
        ITypeBinding typeBinding = simpleType.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"String", (String)typeBinding.getName());
    }

    public void test0317() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0317", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"not an InfixExpression expression", (boolean)(expression instanceof InfixExpression));
        InfixExpression instanceOfExpression = (InfixExpression)expression;
        ASTConverterTest.assertTrue((String)"wrong operator", (boolean)instanceOfExpression.getOperator().equals(InfixExpression.Operator.INSTANCEOF));
        Expression left = instanceOfExpression.getLeftOperand();
        ASTConverterTest.assertTrue((String)"Not a Name", (boolean)(left instanceof Name));
        Name name = (Name)left;
        IBinding binding = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"x", (String)binding.getName());
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No typebinding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong type", (String)"any", (String)typeBinding.getName());
        Expression right = instanceOfExpression.getRightOperand();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(right instanceof SimpleName));
        SimpleName simpleType = (SimpleName)right;
        name = simpleType;
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)(name instanceof SimpleName));
        SimpleName simpleName = (SimpleName)name;
        IBinding binding2 = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Boolean", (String)binding2.getName());
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No typeBinding2", (Object)typeBinding2);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Boolean", (String)typeBinding2.getName());
    }

    public void test0318() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0318", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"No error", (int)1, (int)unit.getMessages().length);
        ASTConverterTest.assertEquals((String)"No error", (int)1, (int)unit.getProblems().length);
    }

    public void test0319() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0319", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not an array creation", (boolean)(expression instanceof ArrayInitializer));
        ArrayInitializer arrayCreation = (ArrayInitializer)expression;
        ITypeBinding typeBinding = arrayCreation.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"any[]", (String)typeBinding.getName());
    }

    public void test0320() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0320", "Test.js");
        sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding binding = variableDeclarationFragment.resolveBinding();
        ITypeBinding typeBinding = binding.getType();
        ASTConverterTest.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"Number[]", (String)typeBinding.getName());
    }

    public void test0322() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0322", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a null literal", (boolean)(expression instanceof NullLiteral));
        NullLiteral nullLiteral = (NullLiteral)expression;
        ITypeBinding typeBinding = nullLiteral.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterTest.assertTrue((String)"Not the null type", (boolean)typeBinding.isNullType());
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)typeBinding.getQualifiedName(), (String)"null");
    }

    public void test0323() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0323", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
        Assignment assignment = (Assignment)expression2;
        assignment.getRightHandSide();
    }

    public void test0326() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0326", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterTest.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        this.checkSourceRange((ASTNode)expressionStatement.getExpression(), "a().f= a()", source);
        this.checkSourceRange((ASTNode)expressionStatement, "a().f= a();", source);
    }

    public void test0331() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0331", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertTrue((String)"Not an VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a QualifiedName", (boolean)(expression instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expression;
        IBinding binding = qualifiedName.getName().resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)3, (int)binding.getKind());
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterTest.assertTrue((String)"Not a field", (boolean)variableBinding.isField());
        ASTConverterTest.assertNull((String)"Got a declaring class", (Object)variableBinding.getDeclaringClass());
        ASTConverterTest.assertEquals((String)"wrong name", (String)"length", (String)variableBinding.getName());
    }

    public void test0339() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0339", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"No errors found", (int)3, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"not a Type declaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)bodyDeclarations.size());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclarations.get(0);
        this.checkSourceRange((ASTNode)methodDeclaration, "function doQuery(boolean x);", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        String expectedSource = "function setX( x) {\n \t\t{\n\t\tz\n\t}\n}";
        this.checkSourceRange(node, expectedSource, source);
        int methodEndPosition = node.getStartPosition() + node.getLength();
        node = this.getASTNode(compilationUnit, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        int typeEndPosition = node.getStartPosition() + node.getLength();
        ASTConverterTest.assertEquals((String)"different positions", (int)methodEndPosition, (int)typeEndPosition);
    }

    public void test0340() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "p3", "B.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an expression statement", (node.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        Expression expression2 = methodInvocation.getExpression();
        ASTConverterTest.assertNotNull((String)"No receiver", (Object)expression2);
        ITypeBinding binding = expression2.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"A", (String)binding.getName());
        ASTConverterTest.assertEquals((String)"wrong name", (String)"p2", (String)binding.getPackage().getName());
        ASTConverterTest.assertTrue((String)"Not a qualified name", (expression2.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName qualifiedName = (QualifiedName)expression2;
        SimpleName simpleName = qualifiedName.getName();
        ASTConverterTest.assertEquals((String)"wrong name", (String)"A", (String)simpleName.getIdentifier());
        ITypeBinding typeBinding = simpleName.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"A", (String)typeBinding.getName());
        ASTConverterTest.assertEquals((String)"wrong name", (String)"p2", (String)typeBinding.getPackage().getName());
        Name name = qualifiedName.getQualifier();
        ASTConverterTest.assertTrue((String)"Not a simple name", (name.getNodeType() == 42 ? 1 : 0) != 0);
        SimpleName simpleName2 = (SimpleName)name;
        ASTConverterTest.assertEquals((String)"wrong name", (String)"p2", (String)simpleName2.getIdentifier());
        IBinding binding2 = simpleName2.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverterTest.assertEquals((String)"wrong type", (int)1, (int)binding2.getKind());
        ASTConverterTest.assertEquals((String)"wrong name", (String)"p2", (String)binding2.getName());
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an expression statement", (node.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement2 = (ExpressionStatement)node;
        Expression expression3 = expressionStatement2.getExpression();
        ASTConverterTest.assertTrue((String)"Not an method invocation", (expression3.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)expression3;
        Expression expression4 = methodInvocation2.getExpression();
        ASTConverterTest.assertNotNull((String)"No receiver", (Object)expression4);
        ITypeBinding binding3 = expression4.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)binding3);
        ASTConverterTest.assertEquals((String)"wrong name", (String)"A", (String)binding3.getName());
        ASTConverterTest.assertEquals((String)"wrong name", (String)"p1", (String)binding3.getPackage().getName());
    }

    public void test0341() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0341", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        String expectedSource = "if (field != null) {\n\t\t\tthrow new IOException();\n\t\t} else if (field == null) {\n\t\t\tthrow new MalformedURLException();\n\t\t} else if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
        IfStatement ifStatement = (IfStatement)node;
        Statement thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new IOException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        Statement elseStatement = ifStatement.getElseStatement();
        expectedSource = "if (field == null) {\n\t\t\tthrow new MalformedURLException();\n\t\t} else if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
        ASTConverterTest.assertTrue((String)"Not a if statement", (elseStatement.getNodeType() == 25 ? 1 : 0) != 0);
        ifStatement = (IfStatement)elseStatement;
        thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new MalformedURLException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        elseStatement = ifStatement.getElseStatement();
        expectedSource = "if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
        ASTConverterTest.assertTrue((String)"Not a if statement", (elseStatement.getNodeType() == 25 ? 1 : 0) != 0);
        ifStatement = (IfStatement)elseStatement;
        thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new InterruptedIOException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        elseStatement = ifStatement.getElseStatement();
        expectedSource = "{\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
    }

    public void test0343() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0343", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 1);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        String expectedSource = "if (flag)\n\t\t\ti= 10;";
        this.checkSourceRange(node, expectedSource, source);
    }

    /*
     * Exception decompiling
     */
    public void test0344() throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 178->182)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void test0345() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0345", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not an ArrayCreation", (expression.getNodeType() == 3 ? 1 : 0) != 0);
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ArrayType arrayType = arrayCreation.getType();
        ITypeBinding binding2 = arrayType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding2", (Object)binding2);
        ASTConverterTest.assertEquals((String)"not a type", (int)binding2.getKind(), (int)2);
        ITypeBinding typeBinding2 = binding2;
        ASTConverterTest.assertTrue((String)"Not an array type binding2", (boolean)typeBinding2.isArray());
        Type type = arrayType.getElementType();
        ASTConverterTest.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverterTest.assertTrue((String)"QualifiedName", (name.getNodeType() == 40 ? 1 : 0) != 0);
        SimpleName simpleName = ((QualifiedName)name).getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"not a type", (int)binding.getKind(), (int)2);
        ITypeBinding typeBinding = (ITypeBinding)binding;
        ASTConverterTest.assertTrue((String)"An array type binding", (!typeBinding.isArray() ? 1 : 0) != 0);
        Type type2 = fieldDeclaration.getType();
        ASTConverterTest.assertTrue((String)"Not a array type", (boolean)type2.isArrayType());
        ArrayType arrayType2 = (ArrayType)type2;
        Type type3 = arrayType2.getElementType();
        ASTConverterTest.assertTrue((String)"Not a simple type", (boolean)type3.isSimpleType());
        SimpleType simpleType2 = (SimpleType)type3;
        Name name2 = simpleType2.getName();
        ASTConverterTest.assertTrue((String)"Not a qualified name", (name2.getNodeType() == 40 ? 1 : 0) != 0);
        SimpleName simpleName2 = ((QualifiedName)name2).getName();
        IBinding binding3 = simpleName2.resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)binding3);
        ASTConverterTest.assertEquals((String)"not a type", (int)binding3.getKind(), (int)2);
        ITypeBinding typeBinding3 = (ITypeBinding)binding3;
        ASTConverterTest.assertTrue((String)"An array type binding", (!typeBinding3.isArray() ? 1 : 0) != 0);
    }

    public void test0346() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0346", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector", source);
        ASTConverterTest.assertTrue((String)"not an array type", (!type.isArrayType() ? 1 : 0) != 0);
        ASTConverterTest.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverterTest.assertTrue((String)"Not a simpleName", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = (ITypeBinding)binding;
        ASTConverterTest.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector", (String)binding.getName());
        ITypeBinding typeBinding2 = simpleType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)typeBinding2);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)typeBinding2.getKind());
        ASTConverterTest.assertTrue((String)"An array", (!typeBinding2.isArray() ? 1 : 0) != 0);
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector", (String)typeBinding2.getName());
    }

    public void test0347() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0347", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector[]", source);
        ASTConverterTest.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector[]", (String)binding.getName());
    }

    public void test0348() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0348", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector[][]", source);
        ASTConverterTest.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector[][]", (String)binding.getName());
    }

    public void test0349() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0349", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "Vector[][]", source);
        ASTConverterTest.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector[][]", (String)binding.getName());
    }

    public void test0350() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0350", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        VariableDeclarationStatement fieldDeclaration = (VariableDeclarationStatement)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "Vector", source);
        ASTConverterTest.assertTrue((String)"not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        ITypeBinding binding = simpleType.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"An array type", (boolean)binding.isClass());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"Vector", (String)binding.getName());
    }

    public void test0351() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0351", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterTest.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var b", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        methodDeclaration = (FunctionDeclaration)node;
        parameters = methodDeclaration.parameters();
        ASTConverterTest.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var b", source);
    }

    public void test0352() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0352", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterTest.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var b", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        methodDeclaration = (FunctionDeclaration)node;
        parameters = methodDeclaration.parameters();
        ASTConverterTest.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "vara", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "var b", source);
    }

    public void test0353() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0353", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"not null", (Object)node);
        ASTConverterTest.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "InputStream", source);
        ASTConverterTest.assertTrue((String)"not a simple type", (boolean)type.isSimpleType());
        ITypeBinding binding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterTest.assertTrue((String)"Not a class", (boolean)binding.isClass());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"InputStream", (String)binding.getName());
        ASTConverterTest.assertEquals((String)"Wrong package", (String)"java.io", (String)binding.getPackage().getName());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        IBinding binding2 = name.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)2, (int)binding2.getKind());
        ITypeBinding typeBinding = (ITypeBinding)binding2;
        ASTConverterTest.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterTest.assertEquals((String)"Wrong name", (String)"InputStream", (String)typeBinding.getName());
        ASTConverterTest.assertEquals((String)"Wrong package", (String)"java.io", (String)typeBinding.getPackage().getName());
    }

    public void test0354() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0354", "Test.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)2, (int)compilationUnit.getMessages().length);
    }

    public void test0355() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0355", "Foo.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        Expression condition = ifStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not an infixExpression", (condition.getNodeType() == 27 ? 1 : 0) != 0);
        InfixExpression infixExpression = (InfixExpression)condition;
        Expression expression = infixExpression.getLeftOperand();
        ASTConverterTest.assertTrue((String)"Not a method invocation expression", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        Expression expression2 = methodInvocation.getExpression();
        ASTConverterTest.assertTrue((String)"Not a parenthesis expression", (expression2.getNodeType() == 36 ? 1 : 0) != 0);
    }

    public void test0356() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0356", "X.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)1, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        ITypeBinding binding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)("Binding should NOT be null for type: " + type), (Object)binding);
    }

    public void test0357() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0357", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration statement", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "A", source);
    }

    public void test0358() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0358", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration statement", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        SimpleName name = methodDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "mdd", source);
    }

    public void test0359() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0359", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration statement", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        SimpleName name = methodDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "mdd", source);
    }

    public void test0360() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0360", "X.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
    }

    public void test0361() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0361", "X.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
    }

    public void test0362() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0362", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment iFragment = this.ast.newVariableDeclarationFragment();
        iFragment.setName(this.ast.newSimpleName("i"));
        iFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationFragment jFragment = this.ast.newVariableDeclarationFragment();
        jFragment.setName(this.ast.newSimpleName("j"));
        jFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationFragment kFragment = this.ast.newVariableDeclarationFragment();
        kFragment.setName(this.ast.newSimpleName("k"));
        kFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(iFragment);
        variableDeclarationExpression.setModifiers(0);
        variableDeclarationExpression.fragments().add(jFragment);
        variableDeclarationExpression.fragments().add(kFragment);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression iPostfixExpression = this.ast.newPostfixExpression();
        iPostfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        iPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(iPostfixExpression);
        PostfixExpression jPostfixExpression = this.ast.newPostfixExpression();
        jPostfixExpression.setOperand((Expression)this.ast.newSimpleName("j"));
        jPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(jPostfixExpression);
        PostfixExpression kPostfixExpression = this.ast.newPostfixExpression();
        kPostfixExpression.setOperand((Expression)this.ast.newSimpleName("k"));
        kPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(kPostfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (var i=0, j=0, k=0; i<10 ; i++, j++, k++) {}", source);
    }

    public void test0363() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0363", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a parenthesized expression", (expression.getNodeType() == 36 ? 1 : 0) != 0);
        Expression expression2 = ((ParenthesizedExpression)expression).getExpression();
        this.checkSourceRange((ASTNode)expression2, "xxxx", source);
    }

    public void test0364() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0364", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "var local;", source);
        SimpleName simpleName = variableDeclarationFragment.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0365() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0365", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
        VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)initializers.get(0);
        List fragments = variableDeclarationExpression.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        SimpleName simpleName = variableDeclarationFragment.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0366() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0366", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (var i = 0; i < 5; ++i);", source);
        Statement statement = forStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0367() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0367", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a while statement", (node.getNodeType() == 61 ? 1 : 0) != 0);
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while(i == 2);", source);
        Statement statement = whileStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0368() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0368", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "The label test is never explicitly referenced");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 30 ? 1 : 0) != 0);
        LabeledStatement labeledStatement = (LabeledStatement)node;
        this.checkSourceRange((ASTNode)labeledStatement, "test:;", source);
        Statement statement = labeledStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0369() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0369", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "The label test is never explicitly referenced");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 30 ? 1 : 0) != 0);
        LabeledStatement labeledStatement = (LabeledStatement)node;
        this.checkSourceRange((ASTNode)labeledStatement, "test:\\u003B", source);
        Statement statement = labeledStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "\\u003B", source);
    }

    public void test0370() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0370", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)node);
        DoStatement doStatement = this.ast.newDoStatement();
        doStatement.setBody((Statement)this.ast.newEmptyStatement());
        doStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ASTConverterTest.assertTrue((String)"Both AST trees should be identical", (boolean)doStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "do ; while(true);";
        this.checkSourceRange(node, expectedSource, source);
        DoStatement doStatement2 = (DoStatement)node;
        Statement statement = doStatement2.getBody();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0371() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0371", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        this.checkSourceRange((ASTNode)ifStatement, "if (i == 6);", source);
        Statement statement = ifStatement.getThenStatement();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0372() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0372", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        this.checkSourceRange((ASTNode)ifStatement, "if (i == 6) {} else ;", source);
        Statement statement = ifStatement.getElseStatement();
        ASTConverterTest.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0373() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0373", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        Statement statement = forStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not a block statement", (statement.getNodeType() == 8 ? 1 : 0) != 0);
        Block block = (Block)statement;
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement2 = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"Not a break statement", (statement2.getNodeType() == 10 ? 1 : 0) != 0);
        BreakStatement breakStatement = (BreakStatement)statement2;
        this.checkSourceRange((ASTNode)breakStatement, "break;", source);
    }

    public void test0374() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0374", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        Statement statement = forStatement.getBody();
        ASTConverterTest.assertTrue((String)"Not a block statement", (statement.getNodeType() == 8 ? 1 : 0) != 0);
        Block block = (Block)statement;
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement2 = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"Not a break statement", (statement2.getNodeType() == 18 ? 1 : 0) != 0);
        ContinueStatement continueStatement = (ContinueStatement)statement2;
        this.checkSourceRange((ASTNode)continueStatement, "continue;", source);
    }

    public void test0375() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0375", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"problems found", (int)1, (int)compilationUnit.getMessages().length);
        List imports = compilationUnit.imports();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        IBinding binding = importDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Not a type binding", (int)2, (int)binding.getKind());
    }

    public void test0376() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0376", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a cast expression", (expression.getNodeType() == 11 ? 1 : 0) != 0);
        Type type = ((CastExpression)expression).getType();
        this.checkSourceRange((ASTNode)type, "A", source);
    }

    public void test0377() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0377", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = variableDeclarationFragment.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ASTConverterTest.assertEquals((String)"Wrong modifier", (int)16, (int)variableBinding.getModifiers());
    }

    public void test0378() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0378", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "B", source);
    }

    public void test0379() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0379", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)expression);
        ASTConverterTest.assertTrue((String)"Not a class instance creation", (expression.getNodeType() == 14 ? 1 : 0) != 0);
        ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)expression;
        Name name2 = classInstanceCreation2.getName();
        this.checkSourceRange((ASTNode)name2, "Object", source);
    }

    public void test0380() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0380", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a return statement", (node.getNodeType() == 41 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterTest.assertTrue((String)"Not a super method invocation", (expression.getNodeType() == 48 ? 1 : 0) != 0);
        SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
        ITypeBinding typeBinding = superMethodInvocation.resolveTypeBinding();
        ASTConverterTest.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"wrong declaring class", (String)typeBinding.getSuperclass().getName(), (String)"Object");
        SimpleName simpleName = superMethodInvocation.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterTest.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterTest.assertEquals((String)"Wrong type", (int)4, (int)binding.getKind());
        IFunctionBinding methodBinding = (IFunctionBinding)binding;
        ASTConverterTest.assertEquals((String)"Wrong declaring class", (String)methodBinding.getDeclaringClass().getName(), (String)"Object");
    }

    public void test0381() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0381", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        JSdoc javadoc = typeDeclaration.getJavadoc();
        ASTConverterTest.assertNull((String)"Javadoc not null", (Object)javadoc);
    }

    public void test0382() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0382", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterTest.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0382.A");
    }

    public void test0383() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0383", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterTest.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0383.A.B");
    }

    public void test0384() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0384", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterTest.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0384.A.B.D");
    }

    public void test0385() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0385", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)1, (int)compilationUnit.getMessages().length);
    }

    public void test0386() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0386", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a switch statement", (node.getNodeType() == 50 ? 1 : 0) != 0);
        SwitchStatement switchStatement = (SwitchStatement)node;
        List statements = switchStatement.statements();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)5, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"Not a case statement", (statement.getNodeType() == 49 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "case 1:", source);
        statement = (Statement)statements.get(3);
        ASTConverterTest.assertTrue((String)"Not a default case statement", (statement.getNodeType() == 49 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "default :", source);
    }

    public void test0387() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0387", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not a cast expression", (expression.getNodeType() == 11 ? 1 : 0) != 0);
        Type type = ((CastExpression)expression).getType();
        this.checkSourceRange((ASTNode)type, "A", source);
    }

    public void test0388() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0388", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"test0388.A", (String)typeBinding.getQualifiedName());
    }

    public void test0389() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0389", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"test0389.A.B", (String)typeBinding.getQualifiedName());
    }

    public void test0390() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0390", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"int", (String)typeBinding.getQualifiedName());
    }

    public void test0391() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0391", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"int[]", (String)typeBinding.getQualifiedName());
    }

    public void test0392() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0392", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
    }

    public void test0393() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0393", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)methodDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No method binding", (Object)methodBinding);
        ITypeBinding typeBinding2 = methodBinding.getReturnType();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding2.getQualifiedName());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding2.getDimensions());
    }

    public void test0394() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0394", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)0, (int)methodDeclaration.getExtraDimensions());
    }

    public void test0395() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0395", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTConverterTest.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterTest.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterTest.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding.getDimensions());
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)methodDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No method binding", (Object)methodBinding);
        ITypeBinding typeBinding2 = methodBinding.getReturnType();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterTest.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[][]", (String)typeBinding2.getQualifiedName());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)2, (int)typeBinding2.getDimensions());
    }

    public void test0396() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0396", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration method = (FunctionDeclaration)node;
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)singleVariableDeclaration);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final String s[]", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertTrue((String)"An array binding", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterTest.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        IVariableBinding variableBinding = singleVariableDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterTest.assertTrue((String)"Not an array binding", (boolean)typeBinding2.isArray());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding2.getDimensions());
        ASTConverterTest.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[]", (String)typeBinding2.getQualifiedName());
    }

    public void test0397() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0397", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration method = (FunctionDeclaration)node;
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterTest.assertNotNull((String)"Expression should not be null", (Object)singleVariableDeclaration);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final String[] \\u0073\\u005B][]", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)2, (int)singleVariableDeclaration.getExtraDimensions());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterTest.assertTrue((String)"Not an array binding", (boolean)typeBinding.isArray());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding.getDimensions());
        ASTConverterTest.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
        IVariableBinding variableBinding = singleVariableDeclaration.resolveBinding();
        ASTConverterTest.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterTest.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterTest.assertTrue((String)"Not an array binding", (boolean)typeBinding2.isArray());
        ASTConverterTest.assertEquals((String)"Wrong dimension", (int)3, (int)typeBinding2.getDimensions());
        ASTConverterTest.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[][][]", (String)typeBinding2.getQualifiedName());
    }

    public void test0398() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0398", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterTest.assertTrue((String)"Not an infix expression", (expression.getNodeType() == 27 ? 1 : 0) != 0);
        InfixExpression infixExpression = (InfixExpression)expression;
        this.checkSourceRange((ASTNode)infixExpression, "(1 + 2) * 3", source);
        Expression expression2 = infixExpression.getLeftOperand();
        ASTConverterTest.assertTrue((String)"Not an parenthesis expression", (expression2.getNodeType() == 36 ? 1 : 0) != 0);
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression2;
        Expression expression3 = parenthesizedExpression.getExpression();
        ASTConverterTest.assertTrue((String)"Not an infix expression", (expression3.getNodeType() == 27 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)expression3, "1 + 2", source);
    }

    public void test0399() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0399", "A.js");
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterTest.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"wrong size", (int)2, (int)statements.size());
    }

    public void test0400() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0400", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterTest.assertNotNull((Object)node);
        ASTConverterTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterTest.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterTest.assertEquals((String)"wrong size", (int)3, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterTest.assertTrue((String)"Not an superconstructorinvocation", (statement.getNodeType() == 46 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "super();", source);
    }
}

