/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultValueType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.SuggestedValueType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditPropertyDialog;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PropertySection
extends AbstractFacesConfigSection {
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button editButton;

    public PropertySection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.PropertySection_Name);
        this.getSection().setDescription(EditorMessages.PropertySection_Description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        container.setLayout((Layout)gl);
        GridData td = new GridData(1808);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        Composite propertySection = toolkit.createComposite(container);
        GridLayout gl2 = new GridLayout();
        gl2.horizontalSpacing = 0;
        gl2.verticalSpacing = 0;
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        gl2.numColumns = 2;
        propertySection.setLayout((Layout)gl2);
        GridData gd = new GridData(1810);
        propertySection.setLayoutData((Object)gd);
        this.createTableSection(propertySection, toolkit);
        this.createButtonsSection(propertySection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite tableContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        tableContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(tableContainer);
        GridLayout gl = new GridLayout();
        tableContainer.setLayout((Layout)gl);
        Table table = new Table(tableContainer, 68352);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn nameCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        nameCol.setText(EditorMessages.PropertySection_Table_NameColumn);
        TableColumn classCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        classCol.setText(EditorMessages.PropertySection_Table_ClassColumn);
        TableColumn valueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(EditorMessages.PropertySection_Table_DefaultValueColumn);
        TableColumn suggestedValueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        suggestedValueCol.setText(EditorMessages.PropertySection_Table_SuggestedValueColumn);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.updateButtons();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)PropertySection.this.tableViewer.getSelection()).size() > 0) {
                    PropertySection.this.editButtonSelected();
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getPropertyType().isInstance(element);
            }
        });
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updateButtons() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Add_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Edit_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Remove, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.addButtonSelected();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.editButtonSelected();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.removeButtonSelected();
            }
        });
    }

    public void refresh() {
        super.refresh();
        this.tableViewer.refresh();
        this.updateButtons();
    }

    public void refreshAll() {
        this.tableViewer.setInput(this.getInput());
        this.updateButtons();
    }

    private void addButtonSelected() {
        Shell shell = EditorPlugin.getActiveShell();
        AddEditPropertyDialog dialog = new AddEditPropertyDialog(shell, true);
        dialog.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        if (dialog.open() == 0) {
            Command addCommand;
            PropertyType newProperty = FacesConfigFactory.eINSTANCE.createPropertyType();
            if (dialog.getPropertyName().length() > 0) {
                PropertyNameType propertyNameType = FacesConfigFactory.eINSTANCE.createPropertyNameType();
                propertyNameType.setTextContent(dialog.getPropertyName());
                newProperty.setPropertyName(propertyNameType);
            }
            if (dialog.getPropertyClass().length() > 0) {
                PropertyClassType propertyClassType = FacesConfigFactory.eINSTANCE.createPropertyClassType();
                propertyClassType.setTextContent(dialog.getPropertyClass());
                newProperty.setPropertyClass(propertyClassType);
            }
            if (dialog.getDefaultValue().length() > 0) {
                DefaultValueType defaultValueType = FacesConfigFactory.eINSTANCE.createDefaultValueType();
                defaultValueType.setTextContent(dialog.getDefaultValue());
                newProperty.setDefaultValue(defaultValueType);
            }
            if (dialog.getSuggestedValue().length() > 0) {
                SuggestedValueType suggestedValueType = FacesConfigFactory.eINSTANCE.createSuggestedValueType();
                suggestedValueType.setTextContent(dialog.getSuggestedValue());
                newProperty.setSuggestedValue(suggestedValueType);
            }
            if ((addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), null, (Object)newProperty)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute(addCommand);
            }
        }
    }

    private void editButtonSelected() {
        PropertyType property = (PropertyType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)property);
        Shell shell = EditorPlugin.getActiveShell();
        AddEditPropertyDialog dialog = new AddEditPropertyDialog(shell, false);
        dialog.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        if (property.getPropertyName() != null) {
            dialog.setPropertyName(property.getPropertyName().getTextContent());
        }
        if (property.getPropertyClass() != null) {
            dialog.setPropertyClass(property.getPropertyClass().getTextContent());
        }
        if (property.getDefaultValue() != null) {
            dialog.setDefaultValue(property.getDefaultValue().getTextContent());
        }
        if (property.getSuggestedValue() != null) {
            dialog.setSuggestedValue(property.getSuggestedValue().getTextContent());
        }
        if (dialog.open() == 0) {
            ArrayList<Command> commands = new ArrayList<Command>(4);
            if (property.getPropertyName() != null) {
                Command cmd1 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)property.getPropertyName(), (Object)FacesConfigPackage.eINSTANCE.getPropertyNameType_TextContent(), (Object)dialog.getPropertyName());
                commands.add(cmd1);
            } else if (dialog.getPropertyName().length() > 0) {
                PropertyNameType propertyNameType = FacesConfigFactory.eINSTANCE.createPropertyNameType();
                propertyNameType.setTextContent(dialog.getPropertyName());
                Command cmd2 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)property, (Object)FacesConfigPackage.eINSTANCE.getPropertyType_PropertyName(), (Object)propertyNameType);
                commands.add(cmd2);
            }
            if (property.getPropertyClass() != null) {
                Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)property.getPropertyClass(), (Object)FacesConfigPackage.eINSTANCE.getPropertyClassType_TextContent(), (Object)dialog.getPropertyClass());
                commands.add(cmd3);
            } else if (dialog.getPropertyClass().length() > 0) {
                PropertyClassType propertyClassType = FacesConfigFactory.eINSTANCE.createPropertyClassType();
                propertyClassType.setTextContent(dialog.getPropertyClass());
                Command cmd4 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)property, (Object)FacesConfigPackage.eINSTANCE.getPropertyType_PropertyClass(), (Object)propertyClassType);
                commands.add(cmd4);
            }
            if (property.getDefaultValue() != null) {
                Command cmd5 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)property.getDefaultValue(), (Object)FacesConfigPackage.eINSTANCE.getDefaultValueType_TextContent(), (Object)dialog.getDefaultValue());
                commands.add(cmd5);
            } else if (dialog.getDefaultValue().length() > 0) {
                DefaultValueType defaultValueType = FacesConfigFactory.eINSTANCE.createDefaultValueType();
                defaultValueType.setTextContent(dialog.getDefaultValue());
                Command cmd6 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)property, (Object)FacesConfigPackage.eINSTANCE.getPropertyType_DefaultValue(), (Object)defaultValueType);
                commands.add(cmd6);
            }
            if (property.getSuggestedValue() != null) {
                Command cmd7 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)property.getSuggestedValue(), (Object)FacesConfigPackage.eINSTANCE.getSuggestedValueType_TextContent(), (Object)dialog.getSuggestedValue());
                commands.add(cmd7);
            } else if (dialog.getSuggestedValue().length() > 0) {
                SuggestedValueType suggestedValueType = FacesConfigFactory.eINSTANCE.createSuggestedValueType();
                suggestedValueType.setTextContent(dialog.getSuggestedValue());
                Command cmd8 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)property, (Object)FacesConfigPackage.eINSTANCE.getPropertyType_SuggestedValue(), (Object)suggestedValueType);
                commands.add(cmd8);
            }
            CompoundCommand command = new CompoundCommand(commands);
            if (command.canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)command);
                this.tableViewer.refresh((Object)property);
            }
        }
    }

    private void removeButtonSelected() {
        PropertyType property = (PropertyType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)property);
        Command removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), null, (Object)property);
        if (removeCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(removeCommand);
            this.refreshAll();
        }
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }
}

