/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFigureListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

class TabbedTitleBarBorder
extends SchemeBorder {
    private IFigure parent;
    private ListenerList listenerList;
    private List tabList;
    private int currentTab;
    private Font font;
    private boolean visible = true;
    private Color textColor = ColorConstants.black;
    private Color bgColor = ColorConstants.menuBackground;
    private Insets insets;
    private Insets padding = new Insets(2, 2, 2, 2);

    public TabbedTitleBarBorder(final IFigure parent) {
        super(SchemeBorder.SCHEMES.LOWERED);
        this.parent = parent;
        parent.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                Insets padding_ = TabbedTitleBarBorder.this.getPadding();
                Point mp = me.getLocation();
                mp.x -= padding_.left;
                mp.y -= padding_.top + 3;
                Point pp = parent.getBounds().getLocation();
                Rectangle tr = new Rectangle(pp.x, pp.y, 0, 0);
                int i = 0;
                while (i < TabbedTitleBarBorder.this.getTabList().size()) {
                    Tab t = (Tab)TabbedTitleBarBorder.this.tabList.get(i);
                    Dimension d = t.getTextExtents();
                    d.height += padding_.top + padding_.bottom;
                    d.width += padding_.left;
                    tr.setSize(d);
                    if (tr.contains(mp)) {
                        TabbedTitleBarBorder.this.setCurrentTab(i);
                        return;
                    }
                    tr.x += d.width;
                    ++i;
                }
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
    }

    protected List getTabList() {
        if (this.tabList == null) {
            this.tabList = new ArrayList();
        }
        return this.tabList;
    }

    public int addTab(String text) {
        this.getTabList().add(new Tab(text));
        return this.getTabList().size() - 1;
    }

    public void removeTab(int index) {
        if (index >= 0 && index < this.getTabList().size()) {
            this.tabList.remove(index);
            if (index >= this.tabList.size()) {
                index = this.tabList.size() - 1;
            }
            this.setCurrentTab(index);
        }
    }

    public void setCurrentTab(int newIndex) {
        if (newIndex >= 0 && newIndex < this.getTabList().size()) {
            Tab newTab = (Tab)this.tabList.get(newIndex);
            int oldIndex = -1;
            int i = 0;
            while (i < this.tabList.size()) {
                Tab t = (Tab)this.tabList.get(i);
                if (t.isActive()) {
                    oldIndex = i;
                    t.setActive(false);
                    break;
                }
                ++i;
            }
            newTab.setActive(true);
            if (this.parent != null) {
                this.parent.invalidate();
                this.parent.repaint();
            }
            this.currentTab = newIndex;
            this.fireTabChanged(oldIndex, newIndex);
        }
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public Object getContents(int index) {
        if (index >= 0 && index < this.getTabList().size()) {
            return ((Tab)this.tabList.get(index)).getContents();
        }
        return null;
    }

    public void setContents(int index, Object contents) {
        if (index >= 0 && index < this.getTabList().size()) {
            ((Tab)this.tabList.get(index)).setContents(contents);
        }
    }

    public void addTabbedWindowListener(WindowFigureListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void removeTabbedWindowListener(WindowFigureListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
        }
    }

    public Object[] getListeners() {
        return this.listenerList.getListeners();
    }

    protected void fireTabChanged(int oldIndex, int newIndex) {
        Object[] l = this.listenerList.getListeners();
        int i = 0;
        while (i < l.length) {
            if (l[i] instanceof WindowFigureListener) {
                ((WindowFigureListener)l[i]).tabChanged(oldIndex, newIndex);
            }
            ++i;
        }
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.parent.getFont();
            if (this.font == null) {
                this.font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            }
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setBackgroundColor(Color c) {
        this.bgColor = c;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setPadding(Insets p) {
        this.padding = p;
        this.invalidate();
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setLabel(String text) {
        this.setLabel(this.currentTab, text);
    }

    public void setLabel(int index, String text) {
        if (index >= 0 && index < this.getTabList().size()) {
            ((Tab)this.tabList.get(index)).setLabel(text);
        }
    }

    public String getLabel() {
        return this.getLabel(this.currentTab);
    }

    public String getLabel(int index) {
        if (index >= 0 && index < this.getTabList().size()) {
            return ((Tab)this.tabList.get(index)).getLabel();
        }
        return "";
    }

    public IFigure getParent() {
        return this.parent;
    }

    public void invalidate() {
        this.insets = null;
        int i = 0;
        while (i < this.getTabList().size()) {
            Tab t = (Tab)this.tabList.get(i);
            t.invalidate();
            ++i;
        }
    }

    public Dimension getTextExtents(IFigure f) {
        Dimension d = new Dimension(0, 0);
        int i = 0;
        while (i < this.getTabList().size()) {
            Tab t = (Tab)this.tabList.get(i);
            if (d.height == 0) {
                d = t.getTextExtents();
            } else {
                d.width += t.getTextExtents().width;
            }
            ++i;
        }
        return d;
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    protected Insets calculateInsets(IFigure figure) {
        this.insets = new Insets(super.getInsets(figure));
        this.insets.top = this.getTextExtents((IFigure)figure).height;
        return this.insets;
    }

    public Insets getInsets(IFigure figure) {
        if (this.insets == null) {
            this.calculateInsets(figure);
        }
        return this.insets;
    }

    public void paint(IFigure figure, Graphics g, Insets in) {
        if (!this.visible) {
            return;
        }
        Insets is = new Insets(in);
        this.getInsets(figure);
        is.top += this.insets.top;
        super.paint(figure, g, is);
        tempRect.setBounds(TabbedTitleBarBorder.getPaintRectangle((IFigure)figure, (Insets)in));
        Rectangle r = tempRect;
        r.height = Math.min(r.height, this.getTextExtents((IFigure)figure).height);
        g.clipRect(r);
        g.setBackgroundColor(this.getBackgroundColor());
        g.fillRectangle(r);
        int x = r.x;
        int y = r.y;
        for (Tab t : this.getTabList()) {
            t.paint(g, figure, x, y);
            x += t.getTextExtents().width;
        }
        g.setBackgroundColor(this.getBackgroundColor());
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d = this.getTextExtents(this.parent);
        this.getInsets(this.parent);
        d.expand(this.insets.left + this.insets.right, this.insets.top + this.insets.bottom);
        return d;
    }

    private class Tab {
        private String label = "";
        private Object contents = null;
        private Dimension textExtents;
        private boolean active;

        public Tab(String text) {
            this.label = text;
        }

        public void setContents(Object contents) {
            this.contents = contents;
        }

        public Object getContents() {
            return this.contents;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String text) {
            this.label = text == null ? "" : text;
            this.textExtents = null;
        }

        public Dimension calculateTextExtents() {
            this.textExtents = FigureUtilities.getTextExtents((String)(this.label == null ? "W" : this.label), (Font)TabbedTitleBarBorder.this.getFont());
            this.textExtents.width += TabbedTitleBarBorder.this.getPadding().getWidth();
            this.textExtents.height += TabbedTitleBarBorder.this.getPadding().getHeight();
            return this.textExtents;
        }

        public Dimension getTextExtents() {
            if (this.textExtents == null) {
                this.calculateTextExtents();
            }
            return this.textExtents.getCopy();
        }

        public void invalidate() {
            this.textExtents = null;
        }

        public void paint(Graphics g, IFigure f, int x, int y) {
            if (this.contents instanceof Composite) {
                return;
            }
            IFigure pane = (IFigure)this.contents;
            this.getTextExtents();
            Insets p = TabbedTitleBarBorder.this.getPadding();
            int w = this.textExtents.width;
            int h = this.textExtents.height;
            int radius = Math.max(p.getWidth(), p.getHeight()) + 2;
            if (TabbedTitleBarBorder.this.getTabList().size() > 1) {
                if (this.active) {
                    g.setBackgroundColor(pane == null ? ColorConstants.white : pane.getBackgroundColor());
                } else {
                    g.setBackgroundColor(TabbedTitleBarBorder.this.getBackgroundColor());
                }
                g.setForegroundColor(this.active ? ColorConstants.buttonDarkest : ColorConstants.buttonDarker);
                g.drawRectangle(x, y + h / 2, --w, h);
                g.fillRoundRectangle(new Rectangle(x, y, w, h), radius, radius);
                g.drawRoundRectangle(new Rectangle(x, y, w, h), radius, radius);
                g.fillRectangle(x + 1, y + h / 2, w - 1, h);
            } else {
                g.setBackgroundColor(TabbedTitleBarBorder.this.getBackgroundColor());
            }
            g.setFont(TabbedTitleBarBorder.this.getFont());
            g.setForegroundColor(TabbedTitleBarBorder.this.getTextColor());
            if (this.label != null) {
                g.drawString(this.label, x + ((TabbedTitleBarBorder)TabbedTitleBarBorder.this).padding.left + 1, y + ((TabbedTitleBarBorder)TabbedTitleBarBorder.this).padding.top);
            }
        }
    }
}

