/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.section;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PropertyMessages;
import org.eclipse.ui.views.properties.IPropertySource;

class SetPropertyValueCommand
extends Command {
    private Object propertyValue;
    private Object propertyID;
    private Object undoValue;
    private boolean resetOnUndo;
    private IPropertySource target;

    public SetPropertyValueCommand(String propLabel) {
        super(MessageFormat.format(PropertyMessages.property_Command_SetValue, propLabel).trim());
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        boolean wasPropertySet = this.getTarget().isPropertySet(this.propertyID);
        this.undoValue = this.getTarget().getPropertyValue(this.propertyID);
        if (this.undoValue instanceof IPropertySource) {
            this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
        }
        if (this.propertyValue instanceof IPropertySource) {
            this.propertyValue = ((IPropertySource)this.propertyValue).getEditableValue();
        }
        this.getTarget().setPropertyValue(this.propertyID, this.propertyValue);
        this.resetOnUndo = wasPropertySet ^ this.getTarget().isPropertySet(this.propertyID);
        if (this.resetOnUndo) {
            this.undoValue = null;
        }
    }

    private IPropertySource getTarget() {
        return this.target;
    }

    void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    void setPropertyId(Object pName) {
        this.propertyID = pName;
    }

    void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void undo() {
        if (this.resetOnUndo) {
            this.getTarget().resetPropertyValue(this.propertyID);
        } else {
            this.getTarget().setPropertyValue(this.propertyID, this.undoValue);
        }
    }
}

