/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCollectionValueModelTests
extends TestCase {
    private SimpleCollectionValueModel<String> bagHolder;
    CollectionChangeEvent bagEvent;
    String bagEventType;
    private SimpleCollectionValueModel<String> setHolder;
    CollectionChangeEvent setEvent;
    String setEventType;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String CHANGE = "change";
    private static final String CLEAR = "clear";

    public SimpleCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bagHolder = new SimpleCollectionValueModel(this.buildBag());
        this.setHolder = new SimpleCollectionValueModel(this.buildSet());
    }

    private Bag<String> buildBag() {
        HashBag result = new HashBag();
        this.addItemsTo((Collection<String>)result);
        return result;
    }

    private Set<String> buildSet() {
        HashSet<String> result = new HashSet<String>();
        this.addItemsTo(result);
        return result;
    }

    private void addItemsTo(Collection<String> c) {
        c.add("foo");
        c.add("bar");
        c.add("baz");
    }

    private Bag<String> buildAddItems() {
        HashBag result = new HashBag();
        result.add((Object)"joo");
        result.add((Object)"jar");
        result.add((Object)"jaz");
        return result;
    }

    private Bag<String> buildRemoveItems() {
        HashBag result = new HashBag();
        result.add((Object)"foo");
        result.add((Object)"baz");
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        SimpleCollectionValueModelTests.assertEquals(this.buildBag(), (Object)CollectionTools.bag((Iterator)this.bagHolder.iterator()));
        SimpleCollectionValueModelTests.assertEquals(this.buildSet(), (Object)CollectionTools.set((Iterator)this.setHolder.iterator()));
    }

    public void testSize() {
        SimpleCollectionValueModelTests.assertEquals((int)this.buildBag().size(), (int)CollectionTools.size((Iterator)this.bagHolder.iterator()));
        SimpleCollectionValueModelTests.assertEquals((int)this.buildSet().size(), (int)CollectionTools.size((Iterator)this.setHolder.iterator()));
    }

    private boolean bagHolderContains(Object item) {
        return CollectionTools.contains((Iterator)this.bagHolder.iterator(), (Object)item);
    }

    private boolean setHolderContains(Object item) {
        return CollectionTools.contains((Iterator)this.setHolder.iterator(), (Object)item);
    }

    private boolean bagHolderContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.bagHolder.iterator(), items);
    }

    private boolean setHolderContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.setHolder.iterator(), items);
    }

    private boolean bagHolderContainsAny(Collection<String> items) {
        HashBag bag = CollectionTools.bag((Iterator)this.bagHolder.iterator());
        for (String string : items) {
            if (!bag.contains((Object)string)) continue;
            return true;
        }
        return false;
    }

    private boolean setHolderContainsAny(Collection<String> items) {
        HashSet set = CollectionTools.set((Iterator)this.setHolder.iterator());
        for (String string : items) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void testAdd() {
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("joo"));
        this.bagHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("joo"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("joo"));
        this.setHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("joo"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
    }

    public void testAddAll() {
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContainsAny((Collection<String>)this.buildAddItems()));
        this.bagHolder.addAll(this.buildAddItems());
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContainsAll((Collection<String>)this.buildAddItems()));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContainsAny((Collection<String>)this.buildAddItems()));
        this.setHolder.addAll(this.buildAddItems());
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContainsAll((Collection<String>)this.buildAddItems()));
    }

    public void testRemove() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("bar"));
        this.bagHolder.remove((Object)"bar");
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("bar"));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        this.bagHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("bar"));
        this.setHolder.remove((Object)"bar");
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("bar"));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
        this.setHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
    }

    public void testRemoveAll() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContainsAll((Collection<String>)this.buildRemoveItems()));
        this.bagHolder.removeAll(this.buildRemoveItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContainsAny((Collection<String>)this.buildRemoveItems()));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContainsAll((Collection<String>)this.buildRemoveItems()));
        this.setHolder.removeAll(this.buildRemoveItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContainsAny((Collection<String>)this.buildRemoveItems()));
    }

    public void testSetCollection() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("bar"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("jar"));
        this.bagHolder.setCollection(this.buildAddItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("bar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("jar"));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        this.bagHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        this.bagHolder.setCollection((Collection)new HashBag());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("jar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("bar"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("jar"));
        this.setHolder.setCollection(this.buildAddItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("bar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("jar"));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
        this.setHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
        this.setHolder.setCollection((Collection)new HashBag());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("jar"));
    }

    public void testCollectionChange1() {
        this.bagHolder.addCollectionChangeListener(this.buildBagListener());
        this.verifyBagChange();
        this.setHolder.addCollectionChangeListener(this.buildSetListener());
        this.verifySetChange();
    }

    public void testCollectionChange2() {
        this.bagHolder.addCollectionChangeListener("values", this.buildBagListener());
        this.verifyBagChange();
        this.setHolder.addCollectionChangeListener("values", this.buildSetListener());
        this.verifySetChange();
    }

    private void verifyBagChange() {
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"foo");
        this.verifyBagEvent(ADD, "foo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"foo");
        this.verifyBagEvent(ADD, "foo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"joo");
        this.verifyBagEvent(ADD, "joo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add(null);
        this.verifyBagEvent(ADD, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add(null);
        this.verifyBagEvent(ADD, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.remove((Object)"joo");
        this.verifyBagEvent(REMOVE, "joo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.remove(null);
        this.verifyBagEvent(REMOVE, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.setCollection(this.buildBag());
        this.verifyBagEvent(CHANGE);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.addAll(this.buildBag());
        this.verifyBagEvent(ADD);
        SimpleCollectionValueModelTests.assertEquals(this.buildBag(), (Object)CollectionTools.bag((Iterator)this.bagEvent.items()));
    }

    private void verifySetChange() {
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"foo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"joo");
        this.verifySetEvent(ADD, "joo");
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add(null);
        this.verifySetEvent(ADD, null);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove((Object)"joo");
        this.verifySetEvent(REMOVE, "joo");
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove((Object)"joo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove(null);
        this.verifySetEvent(REMOVE, null);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.setCollection(this.buildSet());
        this.verifySetEvent(CHANGE);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.addAll(this.buildSet());
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
    }

    private CollectionChangeListener buildBagListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.ADD;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.REMOVE;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void collectionCleared(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.CLEAR;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.CHANGE;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }
        };
    }

    private CollectionChangeListener buildSetListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.ADD;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.REMOVE;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void collectionCleared(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.CLEAR;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.CHANGE;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }
        };
    }

    private void verifyBagEvent(String eventType) {
        SimpleCollectionValueModelTests.assertEquals((String)eventType, (String)this.bagEventType);
        SimpleCollectionValueModelTests.assertEquals(this.bagHolder, (Object)this.bagEvent.getSource());
        SimpleCollectionValueModelTests.assertEquals((String)"values", (String)this.bagEvent.getCollectionName());
    }

    private void verifyBagEvent(String eventType, Object item) {
        this.verifyBagEvent(eventType);
        SimpleCollectionValueModelTests.assertEquals((Object)item, this.bagEvent.items().next());
    }

    private void verifySetEvent(String eventType) {
        SimpleCollectionValueModelTests.assertEquals((String)eventType, (String)this.setEventType);
        SimpleCollectionValueModelTests.assertEquals(this.setHolder, (Object)this.setEvent.getSource());
        SimpleCollectionValueModelTests.assertEquals((String)"values", (String)this.setEvent.getCollectionName());
    }

    private void verifySetEvent(String eventType, Object item) {
        this.verifySetEvent(eventType);
        SimpleCollectionValueModelTests.assertEquals((Object)item, this.setEvent.items().next());
    }
}

