/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.BidiTransformer;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTransformationWritablePropertyValueModelTests
extends TestCase {
    private WritablePropertyValueModel<Person> objectHolder;
    PropertyChangeEvent event;
    private WritablePropertyValueModel<Person> transformationObjectHolder;
    PropertyChangeEvent transformationEvent;

    public CachingTransformationWritablePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)new Person("Karen", "Peggy", null));
        this.transformationObjectHolder = new CachingTransformationWritablePropertyValueModel(this.objectHolder, this.buildTransformer());
    }

    private BidiTransformer<Person, Person> buildTransformer() {
        return new BidiTransformer<Person, Person>(){

            public Person transform(Person p) {
                return p == null ? null : p.getParent();
            }

            public Person reverseTransform(Person p) {
                return p == null ? null : p.getChild();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        PropertyChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addPropertyChangeListener(listener);
        Person person = (Person)((Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)"Karen", (String)person.getName());
        Person parent = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)parent.getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)parent), (Object)this.transformationObjectHolder.getValue());
        Person person1 = new Person("Matt", "Mitch", null);
        this.objectHolder.setValue((Object)person1);
        Person parent2 = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person1.getParent().getName(), (String)parent2.getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person1.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)parent2), (Object)this.transformationObjectHolder.getValue());
        this.objectHolder.setValue(null);
        CachingTransformationWritablePropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        Person person3 = new Person("Karen", "Peggy", null);
        this.objectHolder.setValue((Object)person3);
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)"Karen", (String)person3.getName());
        Person parent3 = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person3.getParent().getName(), (String)parent3.getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person3.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)parent3), (Object)this.transformationObjectHolder.getValue());
    }

    public void testSetValue() {
        PropertyChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addPropertyChangeListener(listener);
        Person person = new Person("Chris", "Noel", null);
        this.transformationObjectHolder.setValue((Object)person.getParent());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)person), (Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
        Person person2 = new Person("Jon", "Elizabeth", null);
        this.transformationObjectHolder.setValue((Object)person2.getParent());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)person2), (Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person2.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person2.getParent()), (Object)this.transformationObjectHolder.getValue());
        this.transformationObjectHolder.setValue(null);
        CachingTransformationWritablePropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        this.transformationObjectHolder.setValue((Object)person.getParent());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)((Object)person), (Object)this.objectHolder.getValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)((Person)((Object)this.transformationObjectHolder.getValue())).getName());
        CachingTransformationWritablePropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
    }

    public void testLazyListening() {
        CachingTransformationWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        PropertyChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addPropertyChangeListener(listener);
        CachingTransformationWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removePropertyChangeListener(listener);
        CachingTransformationWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.transformationObjectHolder.addPropertyChangeListener("value", listener);
        CachingTransformationWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removePropertyChangeListener("value", listener);
        CachingTransformationWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addPropertyChangeListener(this.buildListener());
        this.transformationObjectHolder.addPropertyChangeListener(this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", this.buildListener());
        this.transformationObjectHolder.addPropertyChangeListener("value", this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.transformationEvent = null;
        Person oldPerson = (Person)((Object)this.objectHolder.getValue());
        Person oldParent = (Person)((Object)this.transformationObjectHolder.getValue());
        Person newPerson = new Person("Karen", "Peggy", null);
        this.objectHolder.setValue((Object)newPerson);
        Person newParent = (Person)((Object)this.transformationObjectHolder.getValue());
        this.verifyEvent(this.event, this.objectHolder, (Object)oldPerson, (Object)newPerson);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, (Object)oldParent, (Object)newParent);
    }

    private PropertyChangeListener buildListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationWritablePropertyValueModelTests.this.event = e;
            }
        };
    }

    private PropertyChangeListener buildTransformationListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationWritablePropertyValueModelTests.this.transformationEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)source, (Object)e.getSource());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((String)"value", (String)e.getPropertyName());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        CachingTransformationWritablePropertyValueModelTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }

    private class Person
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private String parentName;
        public static final String PARENT_NAME_PROPERTY = "parentName";
        private Person child;

        public Person(String name, String parentName, Person child) {
            this.name = name;
            this.parentName = parentName;
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            String oldName = this.name;
            this.name = newName;
            this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
        }

        public Person getParent() {
            return new Person(this.parentName, null, this);
        }

        public String getParentName() {
            return this.parentName;
        }

        public void setParentName(String newParentName) {
            String oldParentName = this.parentName;
            this.parentName = newParentName;
            this.firePropertyChanged(PARENT_NAME_PROPERTY, oldParentName, newParentName);
        }

        public Person getChild() {
            return this.child;
        }
    }
}

