/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class SynchronizedBooleanTests
extends TestCase {
    private volatile SynchronizedBoolean sb;
    private volatile boolean exCaught;
    private volatile boolean timeoutOccurred;
    private volatile long startTime;
    private volatile long endTime;

    public SynchronizedBooleanTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sb = new SynchronizedBoolean();
        this.exCaught = false;
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAccessors() throws Exception {
        this.sb.setValue(false);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.value());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
        this.sb.setFalse();
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.value());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
        this.sb.setTrue();
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
        SynchronizedBooleanTests.assertSame((Object)this.sb, (Object)this.sb.mutex());
    }

    public void testEquals() throws Exception {
        this.sb.setValue(false);
        SynchronizedBoolean sb2 = new SynchronizedBoolean(false);
        SynchronizedBooleanTests.assertEquals((Object)this.sb, (Object)sb2);
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.equals((Object)sb2));
        sb2.setValue(true);
        SynchronizedBooleanTests.assertEquals((Object)this.sb, (Object)sb2);
    }

    public void testHashCode() {
        this.sb.setValue(false);
        SynchronizedBooleanTests.assertEquals((int)0, (int)this.sb.hashCode());
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertEquals((int)1, (int)this.sb.hashCode());
    }

    public void testWaitUntilTrue() throws Exception {
        this.verifyWaitUntilTrue(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((this.elapsedTime() > 150L ? 1 : 0) != 0);
    }

    public void testWaitUntilTrueTimeout() throws Exception {
        this.verifyWaitUntilTrue(20L);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((this.elapsedTime() < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitUntilTrue(long timeout) throws Exception {
        this.sb.setFalse();
        Runnable r1 = this.buildRunnable(this.buildSetTrueCommand(), this.sb, 200L);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilTrueCommand(timeout), this.sb, 0L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedBooleanTests.assertFalse((boolean)this.exCaught);
    }

    public void testWaitToSetFalse() throws Exception {
        this.verifyWaitToSetFalse(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((this.elapsedTime() > 150L ? 1 : 0) != 0);
    }

    public void testWaitToSetFalseTimeout() throws Exception {
        this.verifyWaitToSetFalse(20L);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.value());
        SynchronizedBooleanTests.assertTrue((this.elapsedTime() < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitToSetFalse(long timeout) throws Exception {
        this.sb.setFalse();
        Runnable r1 = this.buildRunnable(this.buildSetTrueCommand(), this.sb, 200L);
        Runnable r2 = this.buildRunnable(this.buildWaitToSetFalseCommand(timeout), this.sb, 0L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedBooleanTests.assertFalse((boolean)this.exCaught);
    }

    private Command buildSetTrueCommand() {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) {
                syncBool.setTrue();
            }
        };
    }

    private Command buildWaitUntilTrueCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) throws Exception {
                SynchronizedBooleanTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedBooleanTests.this.setTimeoutOccurred(!syncBool.waitUntilTrue(timeout));
                SynchronizedBooleanTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Command buildWaitToSetFalseCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) throws Exception {
                SynchronizedBooleanTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedBooleanTests.this.setTimeoutOccurred(!syncBool.waitToSetFalse(timeout));
                SynchronizedBooleanTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedBoolean syncBool, final long sleep) {
        return new Runnable(){

            public void run() {
                try {
                    if (sleep != 0L) {
                        Thread.sleep(sleep);
                    }
                    command.execute(syncBool);
                }
                catch (Exception exception) {
                    SynchronizedBooleanTests.this.setExCaught(true);
                }
            }
        };
    }

    void setExCaught(boolean exCaught) {
        this.exCaught = exCaught;
    }

    void setTimeoutOccurred(boolean timeoutOccurred) {
        this.timeoutOccurred = timeoutOccurred;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    long elapsedTime() {
        return this.endTime - this.startTime;
    }

    private static interface Command {
        public void execute(SynchronizedBoolean var1) throws Exception;
    }
}

