/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.Filter;

public class FilterTests
extends TestCase {
    public FilterTests(String name) {
        super(name);
    }

    public void testNullFilter() {
        Filter filter = Filter.Null.instance();
        FilterTests.assertTrue((boolean)filter.accept((Object)""));
        FilterTests.assertTrue((boolean)filter.accept((Object)"foo"));
        FilterTests.assertTrue((boolean)filter.accept((Object)"bar"));
    }

    public void testOpaqueFilter() {
        Filter filter = Filter.Opaque.instance();
        FilterTests.assertFalse((boolean)filter.accept((Object)""));
        FilterTests.assertFalse((boolean)filter.accept((Object)"foo"));
        FilterTests.assertFalse((boolean)filter.accept((Object)"bar"));
    }

    public void testDisabledFilter() {
        Filter filter = Filter.Disabled.instance();
        boolean exCaught = false;
        try {
            FilterTests.assertFalse((boolean)filter.accept((Object)"foo"));
            FilterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        FilterTests.assertTrue((boolean)exCaught);
    }
}

