/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentSearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLSearchPattern;
import org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher;
import org.eclipse.wst.xml.core.internal.search.matching.SAXSearchElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSearchPatternMatcher
extends PatternMatcher {
    private SearchParticipant searchParticipant;
    XMLSearchPattern searchPattern;
    static /* synthetic */ Class class$0;

    public XMLSearchPatternMatcher(SearchParticipant searchParticipant) {
        this.searchParticipant = searchParticipant;
    }

    protected String computeNamespaceForPrefix(Element element, String prefix) {
        String result = null;
        Node node = element;
        while (node != null) {
            String attributeName;
            Element e;
            if (node.getNodeType() == 1 && (result = (e = node).getAttribute(attributeName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns")) != null) break;
            node = node.getParentNode();
        }
        return result;
    }

    protected void initialize(XMLSearchPattern pattern, Element domElement) {
        pattern.setElementName(domElement.getLocalName());
        pattern.setElementNamespace(domElement.getNamespaceURI());
        String actualValue = domElement.getAttribute(pattern.getAttributeName());
        if (actualValue != null) {
            int n = actualValue.indexOf(":");
            if (n > 0) {
                String prefix = actualValue.substring(0, n);
                pattern.setSearchName(actualValue.substring(n + 1));
                String namespace = this.computeNamespaceForPrefix(domElement, prefix);
                pattern.setSearchNamespace(namespace);
            } else {
                pattern.setSearchName(actualValue);
                pattern.setSearchNamespace(domElement.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace"));
            }
        }
    }

    protected void initialize(XMLSearchPattern pattern, SAXSearchElement saxElement) {
        pattern.setElementName(saxElement.getElementName());
        pattern.setElementNamespace(saxElement.getElementNamespace());
        pattern.setDepth(saxElement.getDepth());
        pattern.setParentName(saxElement.getParentName());
        String actualValue = saxElement.getAttributes().getValue(pattern.getAttributeName());
        if (actualValue != null) {
            int n = actualValue.indexOf(":");
            if (n > 0) {
                String prefix = actualValue.substring(0, n);
                pattern.setSearchName(actualValue.substring(n + 1));
                pattern.setSearchNamespace((String)saxElement.getNamespaceMap().get(prefix));
            } else {
                pattern.setSearchName(actualValue);
                pattern.setSearchNamespace(saxElement.getTargetNamespace());
            }
        }
    }

    public XMLSearchPatternMatcher() {
    }

    public void locateMatches(SearchPattern pattern, IFile file, Element element, SearchRequestor requestor) {
        if (pattern instanceof XMLComponentSearchPattern) {
            XMLSearchPattern[] childPatterns = ((XMLComponentSearchPattern)pattern).getChildren(this.searchParticipant);
            if (childPatterns == null) {
                return;
            }
            int i = 0;
            while (i < childPatterns.length) {
                PatternMatcher matcher;
                XMLSearchPattern xMLSearchPattern = childPatterns[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((matcher = (PatternMatcher)xMLSearchPattern.getAdapter(clazz)) == null) {
                    matcher = this;
                }
                if (matcher != null) {
                    matcher.locateMatches(childPatterns[i], file, element, requestor);
                }
                ++i;
            }
        } else if (pattern instanceof XMLSearchPattern && this.matches(pattern, element)) {
            Attr attribute = element.getAttributeNode(((XMLSearchPattern)pattern).getAttributeName());
            this.addMatch(pattern, file, attribute, requestor);
        }
    }

    public boolean matches(SearchPattern pattern, Object element) {
        if (pattern instanceof XMLComponentSearchPattern) {
            XMLSearchPattern[] childPatterns = ((XMLComponentSearchPattern)pattern).getChildren(this.searchParticipant);
            if (childPatterns == null) {
                return false;
            }
            int i = 0;
            while (i < childPatterns.length) {
                PatternMatcher matcher;
                XMLSearchPattern xMLSearchPattern = childPatterns[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((matcher = (PatternMatcher)xMLSearchPattern.getAdapter(clazz)) == null) {
                    matcher = this;
                }
                if (matcher != null && matcher.matches(childPatterns[i], element)) {
                    return true;
                }
                ++i;
            }
        } else if (pattern instanceof XMLSearchPattern) {
            XMLSearchPattern possibleMatch = new XMLSearchPattern();
            possibleMatch.setAttributeName(((XMLSearchPattern)pattern).getAttributeName());
            if (element instanceof Element) {
                this.initialize(possibleMatch, (Element)element);
            } else if (element instanceof SAXSearchElement) {
                this.initialize(possibleMatch, (SAXSearchElement)element);
            }
            this.searchPattern = (XMLSearchPattern)pattern;
            return this.matchesPattern(possibleMatch);
        }
        return false;
    }

    protected boolean matchesPattern(SearchPattern pattern) {
        if (this.searchPattern != null && pattern instanceof XMLSearchPattern) {
            XMLSearchPattern decodedPattern = (XMLSearchPattern)pattern;
            if (this.searchPattern.getElementName().equals(decodedPattern.getElementName()) && this.searchPattern.getElementNamespace().equals(decodedPattern.getElementNamespace())) {
                if (this.searchPattern.getParentName() != null && decodedPattern.getParentName() != null && !this.searchPattern.getParentName().equals(decodedPattern.getParentName())) {
                    return false;
                }
                if (this.searchPattern.getSearchName() == null) {
                    return false;
                }
                if ("*".equals(this.searchPattern.getSearchName())) {
                    return true;
                }
                if (this.searchPattern.getSearchNamespace() == null) {
                    return this.searchPattern.getSearchName().equals(decodedPattern.getSearchName());
                }
                return this.searchPattern.getSearchName().equals(decodedPattern.getSearchName()) && this.searchPattern.getSearchNamespace().equals(decodedPattern.getSearchNamespace());
            }
        }
        return false;
    }

    protected SearchMatch createSearchMatch(IFile file, Attr attributeNode) {
        SearchMatch match = super.createSearchMatch(file, attributeNode);
        if ("name".equals(attributeNode.getName())) {
            QualifiedName qualifiedName = new QualifiedName("todo-compute-targetNamespace", attributeNode.getValue());
            match.map.put("name", qualifiedName);
        }
        return match;
    }
}

