/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;

public class XMLFormattingPreferences {
    public static final String PRESERVE = "PRESERVE";
    public static final String COLLAPSE = "COLLAPSE";
    public static final String IGNORE = "IGNORE";
    public static final String INDENT = "INDENT";
    public static final String NEW_LINE = "NEW_LINE";
    public static final String INLINE = "INLINE";
    private int fMaxLineWidth = 72;
    private boolean fAlignFinalBracket = false;
    private boolean fSpaceBeforeEmptyCloseTag = true;
    private boolean fIndentMultipleAttributes = false;
    private String fPCDataWhitespaceStrategy = "PRESERVE";
    private String fTextIndentStrategy = "INLINE";
    private String fTextWhitespaceStrategy = "COLLAPSE";
    private String fElementIndentStrategy = "INDENT";
    private String fElementWhitespaceStrategy = "IGNORE";
    private String fMixedIndentStrategy = "INDENT";
    private String fMixedWhitespaceStrategy = "IGNORE";
    private String fOneIndent = "\t";
    private boolean fClearAllBlankLines = false;

    public XMLFormattingPreferences() {
        Preferences preferences = XMLCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            this.setMaxLineWidth(preferences.getInt("lineWidth"));
            this.setIndentMultipleAttributes(preferences.getBoolean("splitMultiAttrs"));
            this.setAlignFinalBracket(preferences.getBoolean("alignEndBracket"));
            this.setSpaceBeforeEmptyCloseTag(preferences.getBoolean("spaceBeforeEmptyCloseTag"));
            boolean preservepcdata = preferences.getBoolean("preserveCDATAContent");
            this.fPCDataWhitespaceStrategy = preservepcdata ? PRESERVE : COLLAPSE;
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            StringBuffer indent = new StringBuffer();
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
            this.setOneIndent(indent.toString());
            this.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
        }
    }

    public int getMaxLineWidth() {
        return this.fMaxLineWidth;
    }

    public boolean getAlignFinalBracket() {
        return this.fAlignFinalBracket;
    }

    public boolean getSpaceBeforeEmptyCloseTag() {
        return this.fSpaceBeforeEmptyCloseTag;
    }

    public boolean getIndentMultipleAttributes() {
        return this.fIndentMultipleAttributes;
    }

    public String getPCDataWhitespaceStrategy() {
        return this.fPCDataWhitespaceStrategy;
    }

    public String getTextIndentStrategy() {
        return this.fTextIndentStrategy;
    }

    public String getTextWhitespaceStrategy() {
        return this.fTextWhitespaceStrategy;
    }

    public String getElementIndentStrategy() {
        return this.fElementIndentStrategy;
    }

    public String getElementWhitespaceStrategy() {
        return this.fElementWhitespaceStrategy;
    }

    public void setSpaceBeforeEmptyCloseTag(boolean spaceBeforeEmptyCloseTag) {
        this.fSpaceBeforeEmptyCloseTag = spaceBeforeEmptyCloseTag;
    }

    public void setIndentMultipleAttributes(boolean indentMultipleAttributes) {
        this.fIndentMultipleAttributes = indentMultipleAttributes;
    }

    public void setPCDataWhitespaceStrategy(String dataWhitespaceStrategy) {
        this.fPCDataWhitespaceStrategy = dataWhitespaceStrategy;
    }

    public void setAlignFinalBracket(boolean alignFinalBracket) {
        this.fAlignFinalBracket = alignFinalBracket;
    }

    public String getMixedIndentStrategy() {
        return this.fMixedIndentStrategy;
    }

    public void setMixedIndentStrategy(String mixedIndentStrategy) {
        this.fMixedIndentStrategy = mixedIndentStrategy;
    }

    public String getMixedWhitespaceStrategy() {
        return this.fMixedWhitespaceStrategy;
    }

    public void setMixedWhitespaceStrategy(String mixedWhitespaceStrategy) {
        this.fMixedWhitespaceStrategy = mixedWhitespaceStrategy;
    }

    public String getOneIndent() {
        return this.fOneIndent;
    }

    protected void setMaxLineWidth(int maxLineWidth) {
        this.fMaxLineWidth = maxLineWidth;
    }

    protected void setOneIndent(String oneIndent) {
        this.fOneIndent = oneIndent;
    }

    public boolean getClearAllBlankLines() {
        return this.fClearAllBlankLines;
    }

    public void setClearAllBlankLines(boolean clearAllBlankLines) {
        this.fClearAllBlankLines = clearAllBlankLines;
    }
}

