/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.cleanup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.cleanup.NodeCleanupHandler;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementNodeCleanupHandler
extends NodeCleanupHandler {
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final String DOUBLE_QUOTES = "\"\"";
    protected static final String EMPTY_TAG_CLOSE = "/>";
    protected static final String END_TAG_OPEN = "</";
    protected static final char SINGLE_QUOTE = '\'';
    protected static final String SINGLE_QUOTES = "''";
    protected static final String START_TAG_OPEN = "<";
    protected static final String TAG_CLOSE = ">";

    public Node cleanup(Node node) {
        Node newNode = this.cleanupChildren(node);
        IDOMNode renamedNode = newNode instanceof IDOMNode ? (IDOMNode)newNode : null;
        if (!this.isCommentTag(renamedNode = this.quoteAttrValue(renamedNode)) && !this.isImplicitTag(renamedNode)) {
            IDOMModel structuredModel = renamedNode.getModel();
            int startTagStartOffset = renamedNode.getStartOffset();
            IStructuredDocumentRegion startTagStructuredDocumentRegion = renamedNode.getStartStructuredDocumentRegion();
            this.insertTagClose(structuredModel, startTagStructuredDocumentRegion);
            renamedNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
            startTagStructuredDocumentRegion = renamedNode.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion endTagStructuredDocumentRegion = renamedNode.getEndStructuredDocumentRegion();
            if (endTagStructuredDocumentRegion != startTagStructuredDocumentRegion) {
                this.insertTagClose(structuredModel, endTagStructuredDocumentRegion);
            }
        }
        renamedNode = this.insertMissingTags(renamedNode);
        renamedNode = this.compressEmptyElementTag(renamedNode);
        renamedNode = this.insertRequiredAttrs(renamedNode);
        return renamedNode;
    }

    protected Node cleanupChildren(Node node) {
        Node parentNode = node;
        if (node != null) {
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler(childNode);
                childNode = cleanupHandler.cleanup(childNode);
                parentNode = childNode.getParentNode();
                childNode = childNode.getNextSibling();
            }
        }
        return parentNode;
    }

    private IDOMNode compressEmptyElementTag(IDOMNode node) {
        NodeList childNodes;
        ITextRegionList regions;
        ITextRegion lastRegion;
        boolean compressEmptyElementTags = this.getCleanupPreferences().getCompressEmptyElementTags();
        IDOMNode newNode = node;
        IStructuredDocumentRegion startTagStructuredDocumentRegion = newNode.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion endTagStructuredDocumentRegion = newNode.getLastStructuredDocumentRegion();
        if (compressEmptyElementTags && startTagStructuredDocumentRegion != endTagStructuredDocumentRegion && startTagStructuredDocumentRegion != null && (lastRegion = (regions = startTagStructuredDocumentRegion.getRegions()).get(regions.size() - 1)).getType() != "XML_EMPTY_TAG_CLOSE" && ((childNodes = newNode.getChildNodes()) == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0)) {
            IDOMModel structuredModel = newNode.getModel();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            int startTagStartOffset = newNode.getStartOffset();
            int offset = endTagStructuredDocumentRegion.getStart();
            int length = endTagStructuredDocumentRegion.getLength();
            structuredDocument.replaceText((Object)structuredDocument, offset, length, "");
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
            offset = startTagStructuredDocumentRegion.getStart() + lastRegion.getStart();
            structuredDocument.replaceText((Object)structuredDocument, offset, 0, "/");
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        }
        return newNode;
    }

    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        short nodeType = node.getNodeType();
        NodeCleanupHandler cleanupHandler = null;
        switch (nodeType) {
            case 1: {
                cleanupHandler = new ElementNodeCleanupHandler();
                break;
            }
            case 3: {
                cleanupHandler = new NodeCleanupHandler();
                break;
            }
            default: {
                cleanupHandler = new NodeCleanupHandler();
            }
        }
        cleanupHandler.setCleanupPreferences(this.getCleanupPreferences());
        return cleanupHandler;
    }

    protected ModelQuery getModelQuery(Node node) {
        if (node.getNodeType() == 9) {
            return ModelQueryUtil.getModelQuery((Document)node);
        }
        return ModelQueryUtil.getModelQuery(node.getOwnerDocument());
    }

    protected List getRequiredAttrs(Node node) {
        CMElementDeclaration elementDecl;
        ArrayList<CMAttributeDeclaration> result = new ArrayList<CMAttributeDeclaration>();
        ModelQuery modelQuery = this.getModelQuery(node);
        if (modelQuery != null && (elementDecl = modelQuery.getCMElementDeclaration((Element)node)) != null) {
            CMNamedNodeMap attrMap = elementDecl.getAttributes();
            Iterator it = attrMap.iterator();
            CMAttributeDeclaration attr = null;
            while (it.hasNext()) {
                attr = (CMAttributeDeclaration)it.next();
                if (attr.getUsage() != 2) continue;
                result.add(attr);
            }
        }
        return result;
    }

    private IDOMNode insertEndTag(IDOMNode node) {
        IDOMNode newNode = node;
        IDOMElement element = (IDOMElement)node;
        if (element.isCommentTag()) {
            return node;
        }
        int startTagStartOffset = node.getStartOffset();
        IDOMModel structuredModel = node.getModel();
        if (this.isEmptyElement(element)) {
            ITextRegion regionBeforeTagClose;
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
            ITextRegionList regions = startStructuredDocumentRegion.getRegions();
            ITextRegion lastRegion = regions.get(regions.size() - 1);
            structuredDocument.replaceText((Object)structuredDocument, startStructuredDocumentRegion.getStartOffset(lastRegion), lastRegion.getLength(), EMPTY_TAG_CLOSE);
            if (regions.size() > 1 && (regionBeforeTagClose = regions.get(regions.size() - 1 - 1)).getTextLength() == regionBeforeTagClose.getLength()) {
                structuredDocument.replaceText((Object)structuredDocument, startStructuredDocumentRegion.getStartOffset(lastRegion), 0, " ");
            }
        } else {
            String tagName = node.getNodeName();
            String endTag = END_TAG_OPEN.concat(tagName).concat(TAG_CLOSE);
            IDOMNode lastChild = (IDOMNode)node.getLastChild();
            int endTagStartOffset = 0;
            endTagStartOffset = lastChild != null ? lastChild.getEndOffset() : node.getEndOffset();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            structuredDocument.replaceText((Object)structuredDocument, endTagStartOffset, 0, endTag);
        }
        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        return newNode;
    }

    private IDOMNode insertMissingTags(IDOMNode node) {
        boolean insertMissingTags = this.getCleanupPreferences().getInsertMissingTags();
        IDOMNode newNode = node;
        if (insertMissingTags) {
            IStructuredDocumentRegion startTagStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
            if (startTagStructuredDocumentRegion == null) {
                newNode = this.insertStartTag(node);
                startTagStructuredDocumentRegion = newNode.getStartStructuredDocumentRegion();
            }
            IStructuredDocumentRegion endTagStructuredDocumentRegion = newNode.getEndStructuredDocumentRegion();
            ITextRegionList startStructuredDocumentRegionRegions = startTagStructuredDocumentRegion.getRegions();
            if (startTagStructuredDocumentRegion == null || startStructuredDocumentRegionRegions == null || startStructuredDocumentRegionRegions.get(startStructuredDocumentRegionRegions.size() - 1).getType() != "XML_EMPTY_TAG_CLOSE") {
                if (startTagStructuredDocumentRegion == null) {
                    if (this.isStartTagRequired(newNode)) {
                        newNode = this.insertStartTag(newNode);
                    }
                } else if (endTagStructuredDocumentRegion == null && this.isEndTagRequired(newNode)) {
                    newNode = this.insertEndTag(newNode);
                }
            }
        }
        return newNode;
    }

    private IDOMNode insertRequiredAttrs(IDOMNode node) {
        List requiredAttrs;
        boolean insertRequiredAttrs = this.getCleanupPreferences().getInsertRequiredAttrs();
        IDOMNode newNode = node;
        if (insertRequiredAttrs && (requiredAttrs = this.getRequiredAttrs(newNode)).size() > 0) {
            NamedNodeMap currentAttrs = node.getAttributes();
            ArrayList insertAttrs = new ArrayList();
            if (currentAttrs.getLength() == 0) {
                insertAttrs.addAll(requiredAttrs);
            } else {
                int i = 0;
                while (i < requiredAttrs.size()) {
                    String requiredAttrName = ((CMAttributeDeclaration)requiredAttrs.get(i)).getAttrName();
                    boolean found = false;
                    int j = 0;
                    while (j < currentAttrs.getLength()) {
                        String currentAttrName = currentAttrs.item(j).getNodeName();
                        if (requiredAttrName.compareToIgnoreCase(currentAttrName) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        insertAttrs.add(requiredAttrs.get(i));
                    }
                    ++i;
                }
            }
            if (insertAttrs.size() > 0) {
                IStructuredDocumentRegion startStructuredDocumentRegion = newNode.getStartStructuredDocumentRegion();
                int index = startStructuredDocumentRegion.getEndOffset();
                ITextRegion lastRegion = startStructuredDocumentRegion.getLastRegion();
                if (lastRegion.getType() == "XML_TAG_CLOSE") {
                    lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(--index - 1);
                } else if (lastRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
                    lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset((index -= 2) - 1);
                }
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                try {
                    int i = insertAttrs.size() - 1;
                    while (i >= 0) {
                        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)insertAttrs.get(i);
                        String requiredAttributeName = attrDecl.getAttrName();
                        String defaultValue = attrDecl.getDefaultValue();
                        if (defaultValue == null) {
                            defaultValue = "";
                        }
                        String nameAndDefaultValue = " ";
                        if (i == 0 && lastRegion.getLength() > lastRegion.getTextLength()) {
                            nameAndDefaultValue = "";
                        }
                        nameAndDefaultValue = String.valueOf(nameAndDefaultValue) + requiredAttributeName + "=\"" + defaultValue + "\"";
                        multiTextEdit.addChild((TextEdit)new InsertEdit(index, nameAndDefaultValue));
                        --i;
                    }
                    multiTextEdit.apply((IDocument)newNode.getStructuredDocument());
                }
                catch (BadLocationException e) {
                    Logger.log(1, e.getMessage());
                }
            }
        }
        return newNode;
    }

    private IDOMNode insertStartTag(IDOMNode node) {
        IDOMNode newNode = node;
        if (this.isCommentTag(node)) {
            return node;
        }
        String tagName = node.getNodeName();
        String startTag = START_TAG_OPEN.concat(tagName).concat(TAG_CLOSE);
        int startTagStartOffset = node.getStartOffset();
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        structuredDocument.replaceText((Object)structuredDocument, startTagStartOffset, 0, startTag);
        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        return newNode;
    }

    private void insertTagClose(IDOMModel structuredModel, IStructuredDocumentRegion flatNode) {
        String regionType;
        ITextRegion lastRegion;
        ITextRegionList flatnodeRegions;
        if (flatNode != null && (flatnodeRegions = flatNode.getRegions()) != null && (lastRegion = flatnodeRegions.get(flatnodeRegions.size() - 1)) != null && (regionType = lastRegion.getType()) != "XML_EMPTY_TAG_CLOSE" && regionType != "XML_TAG_CLOSE") {
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            structuredDocument.replaceText((Object)structuredDocument, flatNode.getTextEndOffset(lastRegion), 0, TAG_CLOSE);
        }
    }

    private boolean isCommentTag(Node renamedNode) {
        boolean result = false;
        if (renamedNode instanceof IDOMElement) {
            IDOMElement element = (IDOMElement)renamedNode;
            result = element.isCommentTag();
        }
        return result;
    }

    private boolean isEmptyElement(IDOMElement element) {
        Document document = element.getOwnerDocument();
        if (document == null) {
            return false;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(document);
        if (modelQuery == null) {
            return false;
        }
        CMElementDeclaration decl = modelQuery.getCMElementDeclaration(element);
        if (decl == null) {
            return false;
        }
        return decl.getContentType() == 1;
    }

    private boolean isEndTagRequired(IDOMNode node) {
        if (node == null) {
            return false;
        }
        return node.isContainer();
    }

    private boolean isImplicitTag(IDOMNode renamedNode) {
        return renamedNode.getStartStructuredDocumentRegion() == null;
    }

    private boolean isStartTagRequired(IDOMNode node) {
        if (node == null) {
            return false;
        }
        return node.isContainer();
    }

    private boolean isXMLType(IDOMModel structuredModel) {
        IDOMDocument document;
        boolean result = false;
        if (structuredModel != null && structuredModel != null && (document = structuredModel.getDocument()) != null) {
            result = document.isXMLType();
        }
        return result;
    }

    private IDOMNode quoteAttrValue(IDOMNode node) {
        NamedNodeMap attributes;
        IDOMNode newNode = node;
        if (this.isCommentTag(node)) {
            return node;
        }
        boolean quoteAttrValues = this.getCleanupPreferences().getQuoteAttrValues();
        if (quoteAttrValues && (attributes = newNode.getAttributes()) != null) {
            int attributesLength = attributes.getLength();
            ISourceGenerator generator = node.getModel().getGenerator();
            int i = 0;
            while (i < attributesLength) {
                String newAttrValue;
                attributes = newNode.getAttributes();
                attributesLength = attributes.getLength();
                IDOMAttr eachAttr = (IDOMAttr)attributes.item(i);
                String oldAttrValue = eachAttr.getValueRegionText();
                if (oldAttrValue == null) {
                    IDOMModel structuredModel = node.getModel();
                    if (this.isXMLType(structuredModel)) {
                        newAttrValue = "\"" + eachAttr.getNameRegionText() + "\"";
                        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                        if (eachAttr.getEqualRegion() != null) {
                            structuredDocument.replaceText((Object)structuredDocument, eachAttr.getEndOffset(), 0, newAttrValue);
                        } else {
                            structuredDocument.replaceText((Object)structuredDocument, eachAttr.getNameRegionTextEndOffset(), 0, "=".concat(newAttrValue));
                        }
                        newNode = (IDOMNode)structuredModel.getIndexedRegion(node.getStartOffset());
                    }
                } else {
                    char quote = StringUtils.isQuoted((String)oldAttrValue) ? (char)oldAttrValue.charAt(0) : (char)'\"';
                    newAttrValue = generator.generateAttrValue(eachAttr, quote);
                    if (oldAttrValue.length() == 1) {
                        char firstChar = oldAttrValue.charAt(0);
                        if (firstChar == '\'') {
                            newAttrValue = SINGLE_QUOTES;
                        } else if (firstChar == '\"') {
                            newAttrValue = DOUBLE_QUOTES;
                        }
                    }
                    if (newAttrValue != null && newAttrValue.compareTo(oldAttrValue) != 0) {
                        int attrValueStartOffset = eachAttr.getValueRegionStartOffset();
                        int attrValueLength = oldAttrValue.length();
                        int startTagStartOffset = node.getStartOffset();
                        IDOMModel structuredModel = node.getModel();
                        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                        structuredDocument.replaceText((Object)structuredDocument, attrValueStartOffset, attrValueLength, newAttrValue);
                        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
                    }
                }
                ++i;
            }
        }
        return newNode;
    }
}

