/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.facet.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;

public class Axis2RuntimeUtils {
    public static final int ZIP = 0;
    public static final int UNZIP = 1;
    protected static int mode = 1;
    static ZipFile zipFile;
    protected static byte[] b;
    static SortedSet createdDirs;
    static String outputPath;
    static Axis2EmitterContext context;

    public static String copyAxis2War(IProgressMonitor monitor, String Axis2Home) throws FileNotFoundException, IOException {
        context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        String tempWarFile = null;
        String tempWarLocation = null;
        String tempUnzipLocation = null;
        try {
            if (new File(Axis2CoreUtils.tempAxis2Directory()).isDirectory()) {
                tempWarLocation = Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "tempwar");
                File tempWarLocationFile = new File(tempWarLocation);
                if (tempWarLocationFile.exists()) {
                    FileUtils.deleteDirectories(tempWarLocationFile);
                }
                tempWarLocationFile.mkdirs();
                tempWarFile = Axis2CoreUtils.addAnotherNodeToPath(tempWarLocation, "axis2.war");
                new File(tempWarFile).createNewFile();
                String axis2RuntimrLocation = null;
                if (context.getAxis2RuntimeLocation() != null) {
                    axis2RuntimrLocation = context.getAxis2RuntimeLocation();
                } else {
                    Axis2EmitterContext context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
                    axis2RuntimrLocation = context.getAxis2RuntimeLocation();
                }
                String axis2WarFile = Axis2CoreUtils.addAnotherNodeToPath(axis2RuntimrLocation, "axis2.war");
                FileChannel srcChannel = new FileInputStream(axis2WarFile).getChannel();
                FileChannel dstChannel = new FileOutputStream(tempWarFile).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                tempUnzipLocation = FileUtils.addAnotherNodeToPath(tempWarLocation, "nzip");
                File tempUnzipLocationFile = new File(tempUnzipLocation);
                if (!tempUnzipLocationFile.exists()) {
                    tempUnzipLocationFile.mkdirs();
                }
                Axis2RuntimeUtils.unzipAxis2War(tempWarFile, tempUnzipLocation);
            }
            IPath tempWebXMLLocationPath = new Path(tempUnzipLocation).append("WEB-INF").append("web.xml");
            new File(tempWebXMLLocationPath.toOSString()).delete();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return tempUnzipLocation;
    }

    private static void unzipAxis2War(String fileName, String outputPath) {
        b = new byte[8092];
        Axis2RuntimeUtils.setOutputPath(outputPath);
        if (!fileName.endsWith(".war")) {
            throw new IllegalStateException("Wrong file type" + fileName);
        }
        Axis2RuntimeUtils.unZip(fileName);
    }

    public static void unZip(String fileName) {
        createdDirs = new TreeSet();
        try {
            zipFile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                Axis2RuntimeUtils.unzipFile(all.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void unzipFile(ZipEntry e) throws IOException {
        boolean warnedMkDir = false;
        String zipName = e.getName();
        switch (mode) {
            case 1: {
                File d;
                String dirName;
                if (zipName.startsWith("/")) {
                    if (!warnedMkDir) {
                        warnedMkDir = true;
                    }
                    zipName = zipName.substring(1);
                }
                if (zipName.endsWith("/")) {
                    return;
                }
                int ix = zipName.lastIndexOf(47);
                if (!(ix <= 0 || createdDirs.contains(dirName = zipName.substring(0, ix)) || (d = new File(String.valueOf(Axis2RuntimeUtils.getOutputPath()) + File.separator + dirName)).exists() && d.isDirectory())) {
                    if (!d.mkdirs()) {
                        throw new IllegalStateException("Warning: unable to mkdir " + dirName);
                    }
                    createdDirs.add(dirName);
                }
                FileOutputStream os = new FileOutputStream(String.valueOf(Axis2RuntimeUtils.getOutputPath()) + File.separator + zipName);
                InputStream is = zipFile.getInputStream(e);
                int n = 0;
                while ((n = is.read(b)) > 0) {
                    os.write(b, 0, n);
                }
                is.close();
                os.close();
                break;
            }
            default: {
                throw new IllegalStateException("mode value (" + mode + ") bad");
            }
        }
    }

    public static String getOutputPath() {
        return outputPath;
    }

    public static void setOutputPath(String outputPath) {
        Axis2RuntimeUtils.outputPath = outputPath;
    }
}

