/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.ResultSetIterator;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.DatabaseObject;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDTPDriverAdapter
implements DTPDriverAdapter {
    final Database database;
    final CatalogStrategy catalogStrategy;
    final FoldingStrategy foldingStrategy;

    AbstractDTPDriverAdapter(Database database) {
        this.database = database;
        this.catalogStrategy = this.buildCatalogStrategy();
        this.foldingStrategy = this.buildFoldingStrategy();
    }

    abstract CatalogStrategy buildCatalogStrategy();

    abstract FoldingStrategy buildFoldingStrategy();

    @Override
    public boolean supportsCatalogs() {
        return this.catalogStrategy.supportsCatalogs();
    }

    @Override
    public List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.catalogStrategy.getCatalogs();
    }

    @Override
    public final Iterable<String> getDefaultCatalogNames() {
        return this.supportsCatalogs() ? this.getDefaultCatalogNames_() : Collections.emptyList();
    }

    final Iterable<String> getDefaultCatalogNames_() {
        ArrayList<String> names = new ArrayList<String>();
        this.addDefaultCatalogNamesTo(names);
        return names;
    }

    void addDefaultCatalogNamesTo(ArrayList<String> names) {
        names.add(this.getUserName());
    }

    @Override
    public List<org.eclipse.datatools.modelbase.sql.schema.Schema> getDTPSchemas() {
        try {
            return this.catalogStrategy.getSchemas();
        }
        catch (Exception ex) {
            throw new RuntimeException("driver adapter: " + this, ex);
        }
    }

    @Override
    public final Iterable<String> getDefaultSchemaNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.addDefaultSchemaNamesTo(names);
        return names;
    }

    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(this.getUserName());
    }

    @Override
    public String convertNameToIdentifier(String name) {
        if (this.treatIdentifiersAsDelimited()) {
            return name;
        }
        if (this.nameRequiresDelimiters(name)) {
            return this.delimitName(name);
        }
        return name;
    }

    @Override
    public String convertNameToIdentifier(String name, String defaultName) {
        if (!this.treatIdentifiersAsDelimited() && this.nameRequiresDelimiters(name)) {
            return this.delimitName(name);
        }
        if (this.regularNamesMatch(name, defaultName)) {
            return null;
        }
        return name;
    }

    boolean nameRequiresDelimiters(String name) {
        return name.length() == 0 || this.nameIsReservedWord(name) || this.nameContainsAnySpecialCharacters(name) || this.nameIsNotFolded(name);
    }

    boolean nameIsReservedWord(String name) {
        return this.getDTPDefinition().isSQLKeyword(name);
    }

    DatabaseDefinition getDTPDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.database.getDTPDatabase());
    }

    boolean nameContainsAnySpecialCharacters(String name) {
        char[] string = name.toCharArray();
        if (this.characterIsNonRegularNameStart(string[0])) {
            return true;
        }
        int i = string.length;
        while (i-- > 1) {
            if (!this.characterIsNonRegularNamePart(string[i])) continue;
            return true;
        }
        return false;
    }

    boolean characterIsNonRegularNameStart(char c) {
        return !this.characterIsRegularNameStart(c);
    }

    boolean characterIsRegularNameStart(char c) {
        return Character.isLetter(c) || this.characterIsExtendedRegularNameStart(c);
    }

    boolean characterIsExtendedRegularNameStart(char c) {
        return this.arrayContains(this.getExtendedRegularNameStartCharacters(), c);
    }

    char[] getExtendedRegularNameStartCharacters() {
        return null;
    }

    boolean characterIsNonRegularNamePart(char c) {
        return !this.characterIsRegularNamePart(c);
    }

    boolean characterIsRegularNamePart(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || this.characterIsExtendedRegularNameStart(c) || this.characterIsExtendedRegularNamePart(c);
    }

    boolean characterIsExtendedRegularNamePart(char c) {
        return this.arrayContains(this.getExtendedRegularNamePartCharacters(), c);
    }

    char[] getExtendedRegularNamePartCharacters() {
        return null;
    }

    boolean nameIsNotFolded(String name) {
        return !this.foldingStrategy.nameIsFolded(name);
    }

    boolean regularNamesMatch(String name1, String name2) {
        return name1.equalsIgnoreCase(name2);
    }

    String delimitName(String name) {
        return StringTools.quote((String)name);
    }

    @Override
    public String convertIdentifierToName(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (this.treatIdentifiersAsDelimited()) {
            return identifier;
        }
        if (this.identifierIsDelimited(identifier)) {
            return StringTools.undelimit((String)identifier);
        }
        return this.foldingStrategy.fold(identifier);
    }

    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsQuoted((String)identifier);
    }

    @Override
    public Catalog selectCatalogForIdentifier(Iterable<Catalog> catalogs, String identifier) {
        return this.selectDatabaseObjectForIdentifier(catalogs, identifier);
    }

    @Override
    public Schema selectSchemaForIdentifier(Iterable<Schema> schemata, String identifier) {
        return this.selectDatabaseObjectForIdentifier(schemata, identifier);
    }

    @Override
    public Table selectTableForIdentifier(Iterable<Table> tables, String identifier) {
        return this.selectDatabaseObjectForIdentifier(tables, identifier);
    }

    @Override
    public Sequence selectSequenceForIdentifier(Iterable<Sequence> sequences, String identifier) {
        return this.selectDatabaseObjectForIdentifier(sequences, identifier);
    }

    @Override
    public Column selectColumnForIdentifier(Iterable<Column> columns, String identifier) {
        return this.selectDatabaseObjectForIdentifier(columns, identifier);
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(Iterable<T> databaseObjects, String identifier) {
        return this.selectDatabaseObjectNamed(databaseObjects, this.convertIdentifierToName(identifier));
    }

    <T extends DatabaseObject> T selectDatabaseObjectNamed(Iterable<T> databaseObjects, String name) {
        return this.selectDatabaseObjectNamedRespectCase(databaseObjects, name);
    }

    <T extends DatabaseObject> T selectDatabaseObjectNamedRespectCase(Iterable<T> databaseObjects, String name) {
        for (DatabaseObject databaseObject : databaseObjects) {
            if (!databaseObject.getName().equals(name)) continue;
            return (T)databaseObject;
        }
        return null;
    }

    <T extends DatabaseObject> T selectDatabaseObjectNamedIgnoreCase(Iterable<T> databaseObjects, String name) {
        for (DatabaseObject databaseObject : databaseObjects) {
            if (!databaseObject.getName().equalsIgnoreCase(name)) continue;
            return (T)databaseObject;
        }
        return null;
    }

    List<Map<String, Object>> execute(String sql) {
        try {
            return this.execute_(sql);
        }
        catch (SQLException ex) {
            JptJpaDbPlugin.log("SQL: " + sql, ex);
            return Collections.emptyList();
        }
    }

    List<Map<String, Object>> execute_(String sql) throws SQLException {
        Statement jdbcStatement = this.createJDBCStatement();
        List<Map<String, Object>> rows = Collections.emptyList();
        try {
            jdbcStatement.execute(sql);
            rows = this.buildRows(jdbcStatement.getResultSet());
        }
        finally {
            jdbcStatement.close();
        }
        return rows;
    }

    Statement createJDBCStatement() throws SQLException {
        return this.getConnectionProfile().getJDBCConnection().createStatement();
    }

    List<Map<String, Object>> buildRows(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        CollectionTools.addAll(rows, this.buildResultSetIterator(resultSet));
        return rows;
    }

    Iterator<Map<String, Object>> buildResultSetIterator(ResultSet resultSet) throws SQLException {
        return new ResultSetIterator(resultSet, (ResultSetIterator.Adapter)new ListResultSetIteratorAdapter(resultSet.getMetaData()));
    }

    String getUserName() {
        return this.convertIdentifierToName(this.getConnectionProfile().getUserName());
    }

    boolean treatIdentifiersAsDelimited() {
        return this.getConnectionProfile().treatIdentifiersAsDelimited();
    }

    ConnectionProfile getConnectionProfile() {
        return this.database.getConnectionProfile();
    }

    boolean arrayContains(char[] array, char c) {
        return array != null && ArrayTools.contains((char[])array, (char)c);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.database);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListResultSetIteratorAdapter
    implements ResultSetIterator.Adapter<Map<String, Object>> {
        private final int columnCount;
        private final String[] columnNames;

        ListResultSetIteratorAdapter(ResultSetMetaData rsMetaData) throws SQLException {
            this.columnCount = rsMetaData.getColumnCount();
            this.columnNames = new String[this.columnCount + 1];
            int i = 1;
            while (i <= this.columnCount) {
                this.columnNames[i] = rsMetaData.getColumnName(i);
                ++i;
            }
        }

        public Map<String, Object> buildNext(ResultSet rs) throws SQLException {
            HashMap<String, Object> row = new HashMap<String, Object>(this.columnCount);
            int i = 1;
            while (i <= this.columnCount) {
                row.put(this.columnNames[i], rs.getObject(i));
                ++i;
            }
            return row;
        }
    }
}

