/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.eclipse.wst.server.ui.internal.wizard.ModifyModulesWizard;

public class ModuleSloshAction
extends AbstractServerAction {
    public ModuleSloshAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionModifyModules);
        this.setToolTipText(Messages.actionModifyModulesToolTip);
        this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ETOOL_MODIFY_MODULES"));
        this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CTOOL_MODIFY_MODULES"));
        this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DTOOL_MODIFY_MODULES"));
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception e) {
            ServerUIPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.server.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public boolean accept(IServer server) {
        return server.getServerType() != null;
    }

    public void perform(IServer server) {
        IModule[] modules2;
        if (server == null) {
            return;
        }
        ArrayList<IModule> deployed = new ArrayList<IModule>();
        ArrayList<IModule> modules = new ArrayList<IModule>();
        IModule[] currentModules = server.getModules();
        if (currentModules != null) {
            int size = currentModules.length;
            int i = 0;
            while (i < size) {
                deployed.add(currentModules[i]);
                ++i;
            }
        }
        if ((modules2 = ServerUtil.getModules((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes())) != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IStatus status;
                IModule module = modules2[i];
                if (!deployed.contains(module) && (status = server.canModifyModules(new IModule[]{module}, null, null)) != null && status.getSeverity() != 4) {
                    modules.add(module);
                }
                ++i;
            }
        }
        if (deployed.isEmpty() && modules.isEmpty()) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogAddRemoveModulesNone);
            return;
        }
        ModifyModulesWizard wizard = new ModifyModulesWizard(server);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.open();
    }
}

