/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.versionstatistics;

import org.eclipse.wtp.releng.tools.versionstatistics.FullJarNameParser;
import org.osgi.framework.Version;

public class VersionedId {
    private final String id;
    private final Version version;

    public static VersionedId parse(String spec) {
        FullJarNameParser parser = new FullJarNameParser();
        parser.parse(spec);
        String id = parser.getProjectString();
        String version = parser.getVersionString();
        return new VersionedId(id, version);
    }

    public VersionedId(String id, String version) {
        this.id = id;
        this.version = Version.parseVersion((String)version);
    }

    public VersionedId(String id, Version version) {
        this.id = id;
        this.version = version == null ? Version.emptyVersion : version;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionedId)) {
            return false;
        }
        VersionedId vname = (VersionedId)obj;
        return this.id.equals(vname.id) && this.version.equals((Object)vname.version);
    }

    public int hashCode() {
        return this.id.hashCode() * 31 + this.version.hashCode();
    }
}

