/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.internal.impl.Webservice_clientFactoryImpl;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.JavaMOFUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ClientHandlersWidgetOutputCommand
extends AbstractDataModelOperation {
    private HandlerServiceRefHolder[] handlerServiceRefHolder_;
    private Hashtable oldWSServiceRefsToHandlersTable_;
    private Hashtable newWSServiceRefsToHandlersTable_;
    private IProject project_;
    private boolean isMultipleSelection_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.isMultipleSelection_) {
                if (this.handlerServiceRefHolder_ != null) {
                    int i = 0;
                    while (i < this.handlerServiceRefHolder_.length) {
                        this.handlerServiceRefHolder_[i].addHandlerToServiceRef();
                        this.saveEditModel(this.handlerServiceRefHolder_[i].getProject());
                        ++i;
                    }
                }
            } else {
                this.oldWSServiceRefsToHandlersTable_ = new Hashtable();
                this.newWSServiceRefsToHandlersTable_ = new Hashtable();
                if (this.handlerServiceRefHolder_ != null) {
                    int i = 0;
                    while (i < this.handlerServiceRefHolder_.length) {
                        ServiceRef wsServiceRef = this.handlerServiceRefHolder_[i].getServiceRef();
                        EList wsHandlers = wsServiceRef.getHandlers();
                        this.oldWSServiceRefsToHandlersTable_.put(wsServiceRef, wsHandlers);
                        this.newWSServiceRefsToHandlersTable_.put(wsServiceRef, new ArrayList());
                        ++i;
                    }
                    int j = 0;
                    while (j < this.handlerServiceRefHolder_.length) {
                        List handlerTableItems_ = this.handlerServiceRefHolder_[j].getHandlerList();
                        if (handlerTableItems_ != null) {
                            int i2 = 0;
                            while (i2 < handlerTableItems_.size()) {
                                HandlerTableItem hti = (HandlerTableItem)handlerTableItems_.get(i2);
                                Object wsModelRef = hti.getWsDescRef();
                                if (wsModelRef != null && wsModelRef instanceof ServiceRef) {
                                    ServiceRef wsRef = (ServiceRef)wsModelRef;
                                    Object handler = hti.getHandler();
                                    if (handler != null && handler instanceof Handler) {
                                        Handler clonedHandler = (Handler)EtoolsCopyUtility.createCopy((EObject)((Handler)handler));
                                        ((List)this.newWSServiceRefsToHandlersTable_.get(wsRef)).add(clonedHandler);
                                    } else {
                                        Webservice_clientFactoryImpl wsClientFactory = new Webservice_clientFactoryImpl();
                                        Handler newHandler = wsClientFactory.createHandler();
                                        newHandler.setHandlerName(hti.getHandlerName());
                                        JavaClass javaClass = JavaMOFUtils.getJavaClass((String)hti.getHandlerClassName(), (IProject)this.project_);
                                        if (javaClass != null) {
                                            newHandler.setHandlerClass(javaClass);
                                        }
                                        ((List)this.newWSServiceRefsToHandlersTable_.get(wsRef)).add(newHandler);
                                    }
                                }
                                ++i2;
                            }
                        }
                        ++j;
                    }
                    this.addHandlersToServiceRefs();
                }
                this.saveEditModel();
            }
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Throwable)e);
        }
        return status;
    }

    private void saveEditModel() {
        WebArtifactEdit artifactEdit = null;
        try {
            if (J2EEUtils.isWebComponent((IProject)this.project_)) {
                artifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.project_);
            } else if (J2EEUtils.isEJBComponent((IProject)this.project_)) {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.project_);
            } else if (J2EEUtils.isAppClientComponent((IProject)this.project_)) {
                artifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IProject)this.project_);
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.save(null);
                artifactEdit.dispose();
            }
        }
    }

    private void saveEditModel(IProject project) {
        this.project_ = project;
        this.saveEditModel();
    }

    private void addHandlersToServiceRefs() {
        try {
            Enumeration refsToHandlers = this.newWSServiceRefsToHandlersTable_.keys();
            while (refsToHandlers.hasMoreElements()) {
                ServiceRef serviceRef = (ServiceRef)refsToHandlers.nextElement();
                if (serviceRef == null) continue;
                List handlers = (List)this.newWSServiceRefsToHandlersTable_.get(serviceRef);
                List modelHandlers = (List)this.oldWSServiceRefsToHandlersTable_.get(serviceRef);
                modelHandlers.clear();
                modelHandlers.addAll(handlers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setClientProject(IProject project) {
        this.project_ = project;
    }

    public void setHandlerServiceRefHolder(HandlerServiceRefHolder[] handlerHolders) {
        this.handlerServiceRefHolder_ = handlerHolders;
    }

    public void setIsMultipleSelection(boolean isMulitpleSelection) {
        this.isMultipleSelection_ = isMulitpleSelection;
    }
}

