/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.analyzer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.osgi.framework.Bundle;

class ServletBeanProxyContributor
extends ConfigurationContributorAdapter {
    private final JSFVersion _jsfVersion;

    public ServletBeanProxyContributor(IProject project) {
        this._jsfVersion = ServletBeanProxyContributor.getProjectVersion(project);
        if (this._jsfVersion == null) {
            throw new IllegalArgumentException("jsfVersion must not be null");
        }
    }

    public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
        if (this._jsfVersion != null && this._jsfVersion.compareTo(JSFVersion.V1_2) < 0) {
            Bundle servletBundle = Platform.getBundle((String)"javax.servlet");
            controller.contributeClasspath(servletBundle, null, 0, true);
            Bundle jspBundle = Platform.getBundle((String)"javax.servlet.jsp");
            controller.contributeClasspath(jspBundle, null, 0, true);
        } else {
            Bundle coreBundle = JSFCorePlugin.getDefault().getBundle();
            controller.contributeClasspath(coreBundle, "/jars/fake_jsp_21.jar", 0, false);
            controller.contributeClasspath(coreBundle, "/jars/fake_el.jar", 0, false);
        }
    }

    static JSFVersion getProjectVersion(IProject project) {
        return JSFVersion.valueOfProject(project);
    }
}

