/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jee.archive.AbstractArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.IArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;

public class ZipStreamArchiveSaveAdapterImpl
extends AbstractArchiveSaveAdapter {
    protected OutputStream destinationStream;
    protected ZipOutputStream zipOutputStream;

    public ZipStreamArchiveSaveAdapterImpl(OutputStream out) {
        this.setDestinationStream(out);
        this.setZipOutputStream(new ZipOutputStream(out));
    }

    public void close() throws IOException {
        this.getDestinationStream().close();
    }

    protected IArchiveSaveAdapter createNestedSaveAdapter(IArchive anArchive) {
        return new ZipStreamArchiveSaveAdapterImpl(this.getZipOutputStream());
    }

    public void finish() throws IOException {
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            this.getDestinationStream().close();
        }
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getZipOutputStream();
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    protected void save(IArchiveResource resource) throws ArchiveSaveFailureException {
        try {
            IPath path = resource.getPath();
            if (resource.getType() == 1 && !path.hasTrailingSeparator()) {
                path = path.addTrailingSeparator();
            }
            ZipEntry entry = new ZipEntry(path.toString());
            if (resource.getLastModified() > 0L) {
                entry.setTime(resource.getLastModified());
            }
            this.getZipOutputStream().putNextEntry(entry);
            if (resource.getType() != 1) {
                ArchiveUtil.copy(resource.getInputStream(), this.getZipOutputStream());
            }
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException(e);
        }
    }

    public void setDestinationStream(OutputStream newDestinationStream) {
        this.destinationStream = newDestinationStream;
    }

    protected void setZipOutputStream(ZipOutputStream newZipOutputStream) {
        this.zipOutputStream = newZipOutputStream;
    }
}

