/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public abstract class SourceCompleteColumnAnnotation
extends SourceBaseColumnAnnotation
implements ColumnAnnotation {
    protected final DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildIntegerElementAdapter(this.getLengthElementName());
    protected final AnnotationElementAdapter<Integer> lengthAdapter = this.buildShortCircuitIntegerElementAdapter(this.lengthDeclarationAdapter);
    protected Integer length;
    protected final DeclarationAnnotationElementAdapter<Integer> precisionDeclarationAdapter = this.buildIntegerElementAdapter(this.getPrecisionElementName());
    protected final AnnotationElementAdapter<Integer> precisionAdapter = this.buildShortCircuitIntegerElementAdapter(this.precisionDeclarationAdapter);
    protected Integer precision;
    protected final DeclarationAnnotationElementAdapter<Integer> scaleDeclarationAdapter = this.buildIntegerElementAdapter(this.getScaleElementName());
    protected final AnnotationElementAdapter<Integer> scaleAdapter = this.buildShortCircuitIntegerElementAdapter(this.scaleDeclarationAdapter);
    protected Integer scale;

    protected SourceCompleteColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.length = this.buildLength(astRoot);
        this.precision = this.buildPrecision(astRoot);
        this.scale = this.buildScale(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncLength(this.buildLength(astRoot));
        this.syncPrecision(this.buildPrecision(astRoot));
        this.syncScale(this.buildScale(astRoot));
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        if (this.attributeValueHasChanged(this.length, length)) {
            this.length = length;
            this.lengthAdapter.setValue(length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return this.lengthAdapter.getValue(astRoot);
    }

    public TextRange getLengthTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.lengthDeclarationAdapter, astRoot);
    }

    protected abstract String getLengthElementName();

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        if (this.attributeValueHasChanged(this.precision, precision)) {
            this.precision = precision;
            this.precisionAdapter.setValue(precision);
        }
    }

    private void syncPrecision(Integer astPrecision) {
        Integer old = this.precision;
        this.precision = astPrecision;
        this.firePropertyChanged("precision", old, astPrecision);
    }

    private Integer buildPrecision(CompilationUnit astRoot) {
        return this.precisionAdapter.getValue(astRoot);
    }

    public TextRange getPrecisionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.precisionDeclarationAdapter, astRoot);
    }

    protected abstract String getPrecisionElementName();

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        if (this.attributeValueHasChanged(this.scale, scale)) {
            this.scale = scale;
            this.scaleAdapter.setValue(scale);
        }
    }

    private void syncScale(Integer astScale) {
        Integer old = this.scale;
        this.scale = astScale;
        this.firePropertyChanged("scale", old, astScale);
    }

    private Integer buildScale(CompilationUnit astRoot) {
        return this.scaleAdapter.getValue(astRoot);
    }

    public TextRange getScaleTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.scaleDeclarationAdapter, astRoot);
    }

    protected abstract String getScaleElementName();
}

