/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.Breakpoint;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.FunctionSource;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.LineData;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.mozilla.javascript.debug.DebuggableScript;

public class ScriptSource {
    static final LineData[] NO_LINES = new LineData[0];
    private Long scriptId;
    private final Map properties;
    private final String source;
    private final boolean generated;
    private ArrayList functionNames = null;
    private Integer firstLine = null;
    private URI uri = null;
    private FunctionSource[] functionSources = null;
    private LineData[] lines = null;
    private HashMap scriptToFunction = new HashMap();

    public ScriptSource(DebuggableScript script, String source, URI uri, boolean generated, Map properties) {
        this.uri = uri;
        this.source = source;
        this.properties = properties;
        this.generated = generated;
        if (this.isStdIn()) {
            return;
        }
        int[] rootlines = script.getLineNumbers();
        DebuggableScript[] functions = this.collectFunctions(script);
        int flength = functions.length;
        int max = 0;
        int min = Integer.MAX_VALUE;
        HashSet<Integer> lineNumbers = new HashSet<Integer>(flength + rootlines.length + 1);
        int i = 0;
        while (i < rootlines.length) {
            int line = rootlines[i];
            if (line > max) {
                max = line;
            }
            if (line < min) {
                min = line;
            }
            lineNumbers.add(new Integer(line));
            ++i;
        }
        if (flength > 0) {
            this.functionSources = new FunctionSource[flength];
            this.functionNames = new ArrayList(flength);
            int start = 0;
            int end = 0;
            int i2 = 0;
            while (i2 < functions.length) {
                String name;
                int[] lines = functions[i2].getLineNumbers();
                if (lines != null && lines.length > 0) {
                    start = lines[0] + 1;
                    int j = 0;
                    while (j < lines.length) {
                        int currentLine = lines[j];
                        if (currentLine > max) {
                            max = currentLine;
                        }
                        if (currentLine < min) {
                            min = currentLine;
                        }
                        if (currentLine < start) {
                            start = currentLine;
                        } else if (currentLine > end) {
                            end = currentLine;
                        }
                        lineNumbers.add(new Integer(currentLine));
                        ++j;
                    }
                }
                name = (name = functions[i2].getFunctionName()) == null ? "" : name;
                this.functionSources[i2] = new FunctionSource(this, name, this.computeFunctionSource(0, 0, source), start);
                this.functionNames.add(name);
                this.scriptToFunction.put(functions[i2], this.functionSources[i2]);
                start = 0;
                ++i2;
            }
        }
        if (max == 0) {
            this.lines = NO_LINES;
        } else {
            this.lines = new LineData[max + 1];
            Iterator iter = lineNumbers.iterator();
            while (iter.hasNext()) {
                Integer value = (Integer)iter.next();
                this.lines[value.intValue()] = new LineData();
                iter.remove();
            }
            lineNumbers = null;
        }
        this.firstLine = new Integer(min);
    }

    public Integer firstLine() {
        return this.firstLine;
    }

    public boolean isStdIn() {
        return this.uri.toString().endsWith("stdin");
    }

    void clearBreakpoints(RhinoDebuggerImpl debugger) {
        if (this.lines != null) {
            int i = 0;
            while (i < this.lines.length) {
                Breakpoint bp;
                if (this.lines[i] != null && (bp = this.lines[i].breakpoint) != null) {
                    debugger.clearBreakpoint(bp.breakpointId);
                }
                ++i;
            }
        }
    }

    DebuggableScript[] collectFunctions(DebuggableScript root) {
        ArrayList functions = new ArrayList();
        this.collectFunctions(root, functions);
        int size = functions.size();
        if (size < 1) {
            return RhinoDebuggerImpl.NO_SCRIPTS;
        }
        DebuggableScript[] funcs = new DebuggableScript[size];
        functions.toArray(funcs);
        return funcs;
    }

    void collectFunctions(DebuggableScript root, List collector) {
        if (root.isFunction()) {
            collector.add(root);
        }
        int i = 0;
        while (i < root.getFunctionCount()) {
            this.collectFunctions(root.getFunction(i), collector);
            ++i;
        }
    }

    String computeFunctionSource(int start, int end, String source) {
        if (start > -1 && end <= source.length()) {
            return source.substring(start, end);
        }
        return null;
    }

    public void setId(Long id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.scriptId = id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScriptSource) {
            return this.uri.toString().equals(((ScriptSource)obj).uri.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.uri.toString().hashCode();
    }

    public Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("scriptId", this.scriptId);
        result.put("location", this.uri.toString());
        result.put("properties", this.properties);
        result.put("source", this.source);
        result.put("generated", this.generated);
        if (this.lines != null) {
            HashSet<Integer> lineNumbers = new HashSet<Integer>();
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null) {
                    lineNumbers.add(new Integer(i));
                }
                ++i;
            }
            result.put("lines", lineNumbers == null ? Collections.EMPTY_SET : lineNumbers);
        } else {
            result.put("lines", Collections.EMPTY_SET);
        }
        result.put("functions", this.functionNames == null ? Collections.EMPTY_LIST : this.functionNames);
        return result;
    }

    public Long getId() {
        return this.scriptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breakpoint getBreakpoint(Integer line, String functionName) {
        LineData[] lineDataArray = this.lines;
        synchronized (this.lines) {
            int index;
            FunctionSource func;
            int value;
            if (line != null && (value = line.intValue()) > -1 && value < this.lines.length && this.lines[value] != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.lines[value].breakpoint;
            }
            if (this.functionNames != null && (func = this.functionAt(index = this.functionNames.indexOf(functionName))) != null && this.lines[func.linenumber()] != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.lines[func.linenumber()].breakpoint;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Integer line, String functionName) {
        LineData[] lineDataArray = this.lines;
        synchronized (this.lines) {
            int index;
            FunctionSource func;
            int value;
            if (line != null && (value = line.intValue()) > -1 && value < this.lines.length) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.lines[value] != null;
            }
            if (this.functionNames != null && (func = this.functionAt(index = this.functionNames.indexOf(functionName))) != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.lines[func.linenumber()] != null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBreakpoint(Breakpoint breakpoint) {
        LineData[] lineDataArray = this.lines;
        synchronized (this.lines) {
            int index;
            FunctionSource func;
            Integer lineNumber = breakpoint.lineNumber;
            if (lineNumber != null) {
                int value = lineNumber;
                if (this.lines[value] != null) {
                    this.lines[value].breakpoint = breakpoint;
                }
            } else if (this.functionNames != null && (func = this.functionAt(index = this.functionNames.indexOf(breakpoint.functionName))) != null && this.lines[func.linenumber] != null) {
                this.lines[func.linenumber].breakpoint = breakpoint;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBreakpoint(Breakpoint breakpoint) {
        LineData[] lineDataArray = this.lines;
        synchronized (this.lines) {
            int index;
            FunctionSource func;
            Integer lineNumber = breakpoint.lineNumber;
            if (lineNumber != null) {
                int value = lineNumber;
                if (this.lines[value] != null) {
                    this.lines[value].breakpoint = null;
                }
            } else if (this.functionNames != null && (func = this.functionAt(index = this.functionNames.indexOf(breakpoint.functionName))) != null && this.lines[func.linenumber] != null) {
                this.lines[func.linenumber].breakpoint = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getLocation() {
        return this.uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionSource functionAt(int index) {
        FunctionSource[] functionSourceArray = this.functionSources;
        synchronized (this.functionSources) {
            if (this.functionSources != null && index < this.functionSources.length && index > -1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.functionSources[index];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionSource getFunction(DebuggableScript script) {
        HashMap hashMap = this.scriptToFunction;
        synchronized (hashMap) {
            return (FunctionSource)this.scriptToFunction.get(script);
        }
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("ScriptSource: [id - ").append(this.scriptId).append("] [uri - ").append(this.uri.toString()).append("]");
        buffer.append("[generated - ").append(this.generated).append("]\n");
        if (this.lines != null) {
            buffer.append("\tline numbers: {");
            i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null) {
                    buffer.append(i);
                    if (i < this.lines.length - 1) {
                        buffer.append(", ");
                    }
                }
                ++i;
            }
            buffer.append("}\n");
        }
        if (this.functionNames != null) {
            buffer.append("\tfunction names: {");
            i = 0;
            while (i < this.functionNames.size()) {
                buffer.append(this.functionNames.get(i));
                if (i < this.functionNames.size() - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            buffer.append("}\n");
        }
        if (this.functionSources != null) {
            buffer.append("\tfunction sources:\n");
            i = 0;
            while (i < this.functionSources.length) {
                buffer.append(this.functionSources[i]).append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }
}

