/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.jsf.designtime.internal.BasicExtensionFactory;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratableExtensionFactory<EXTENSIONTYPE>
extends BasicExtensionFactory<EXTENSIONTYPE> {
    private static final String DECORATOR_ATTRIBUTE_NAME = "forRuntimeClass";
    private final Map<String, List<String>> _forNameToId = new HashMap<String, List<String>>();

    public DecoratableExtensionFactory(Bundle bundle, String extName, String elementName, boolean alwaysPerProject) {
        super(bundle, extName, elementName, alwaysPerProject);
    }

    public List<String> getIdsForName(String name) {
        List ids = this._forNameToId.get(name);
        if (ids == null) {
            ids = Collections.EMPTY_LIST;
        }
        return ids;
    }

    public int getNumDecorativeResolvers() {
        return this._forNameToId.size();
    }

    @Override
    protected Map<String, BasicExtensionFactory.ExtensionData<EXTENSIONTYPE>> loadRegisteredExtensions() {
        Map extensions = super.loadRegisteredExtensions();
        for (Map.Entry<String, List<String>> entry : this._forNameToId.entrySet()) {
            Collections.sort(entry.getValue());
        }
        return extensions;
    }

    @Override
    protected BasicExtensionFactory.ExtensionData processExtension(IConfigurationElement element, boolean alwaysPerProject) {
        BasicExtensionFactory.ExtensionData data = super.processExtension(element, alwaysPerProject);
        String forRuntimeClass = element.getAttribute(DECORATOR_ATTRIBUTE_NAME);
        if (forRuntimeClass != null && !"".equals(forRuntimeClass.trim())) {
            this.addRuntimeClassMapping(data.getId(), forRuntimeClass);
        }
        return data;
    }

    private void addRuntimeClassMapping(String id, String forRuntimeClass) {
        List<String> mappings = this._forNameToId.get(forRuntimeClass);
        if (mappings == null) {
            mappings = new ArrayList<String>(2);
            this._forNameToId.put(forRuntimeClass, mappings);
        }
        mappings.add(id);
    }
}

