/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.metadata.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.MetadataPackage;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataTranslator;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.BooleanValue;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.StringValue;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.TraitTypesFactory;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.metadata.internal.INamespaceModelProvider;

public class NamespaceMetaDataTranslator
implements IMetaDataTranslator {
    private IMetaDataModelMergeAssistant _assistant;

    public void translate(IMetaDataModelMergeAssistant assistant) {
        this._assistant = assistant;
        Namespace ns = ((INamespaceModelProvider)this._assistant.getSourceModelProvider()).getNamespace();
        this.doTranslate(ns);
    }

    public boolean canTranslate(IMetaDataSourceModelProvider modelProvider) {
        return modelProvider != null && modelProvider instanceof INamespaceModelProvider;
    }

    protected void setAssistant(IMetaDataModelMergeAssistant assistant) {
        this._assistant = assistant;
    }

    protected void doTranslate(Namespace tagLib) {
        this.createTags(tagLib);
        this.createTagfileTraits(tagLib);
    }

    protected void createSimpleStringEntityTraitIfNecessary(Entity entity, String key, String value) {
        Trait t = this.findTraitOnEntityById(entity, key);
        if (t == null) {
            t = this.internalCreateTrait(entity, key);
            StringValue val = TraitTypesFactory.eINSTANCE.createStringValue();
            val.setValue(value);
            t.setValue((EObject)val);
        }
    }

    protected void createSimpleBooleanObjectEntityTraitIfNecessary(Entity entity, String key, boolean value) {
        Trait t = this.findTraitOnEntityById(entity, key);
        if (t == null) {
            t = this.internalCreateTrait(entity, key);
            BooleanValue val = TraitTypesFactory.eINSTANCE.createBooleanValue();
            val.setTrue(value);
            t.setValue((EObject)val);
        }
    }

    protected Trait internalCreateTrait(Entity entity, String key) {
        Trait t = MetadataFactory.eINSTANCE.createTrait();
        t.setId(key);
        t.setSourceModelProvider(this._assistant.getSourceModelProvider());
        entity.getTraits().add((Object)t);
        return t;
    }

    protected Trait findTraitOnEntityById(Entity entity, String key) {
        for (Trait t : entity.getTraits()) {
            if (!key.equals(t.getId())) continue;
            return t;
        }
        return null;
    }

    protected Entity findTagEntity(String nodeName) {
        for (Entity entity : this.getMergedModel().getChildEntities()) {
            if (!nodeName.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }

    protected Entity findAttributeEntityForTagEntity(Entity tag, String attributeName) {
        for (Entity attr : tag.getChildEntities()) {
            if (!attributeName.equals(attr.getId())) continue;
            return attr;
        }
        return null;
    }

    protected void createTags(Namespace tagLib) {
        for (ITagElement tag : tagLib.getViewElements()) {
            Entity entity = this.findTagEntity(tag.getName());
            if (entity == null) {
                entity = MetadataFactory.eINSTANCE.createEntity();
                entity.setId(this.getTagNodeName(tag));
                entity.setType("tag");
                this.getMergedModel().getChildEntities().add((Object)entity);
            }
            this.setTagEntityTraits(tag, entity);
        }
    }

    protected String getTagNodeName(ITagElement tag) {
        return tag.getName();
    }

    protected void setTagEntityTraits(ITagElement tag, Entity entity) {
        this.createSimpleStringEntityTraitIfNecessary(entity, "display-label", this.getTagDisplayName(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "description", this.getTagDescription(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "small-icon", this.getTagSmallIcon(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "large-icon", this.getTagLargeIcon(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "expert", this.getTagIsExpert(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "hidden", this.getTagIsHidden(tag));
        this.createAttributeEntities(entity, tag);
    }

    protected void createAttributeEntities(Entity tagEntity, ITagElement tag) {
        for (ITagAttribute tagAttr : tag.getAttributes().values()) {
            Entity attr = this.findAttributeEntityForTagEntity(tagEntity, tagAttr.getName());
            if (attr == null) {
                attr = MetadataFactory.eINSTANCE.createEntity();
                attr.setId(tagAttr.getName());
                tagEntity.getChildEntities().add((Object)attr);
            }
            this.createAttributeTraits(attr, tagAttr);
        }
    }

    protected void createAttributeTraits(Entity attr, ITagAttribute tagAttr) {
        this.createSimpleStringEntityTraitIfNecessary(attr, "description", this.getTagAttributeDescription(tagAttr));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(attr, "required", this.getTagAttributeIsRequired(tagAttr));
        this.createSimpleStringEntityTraitIfNecessary(attr, "default-value", this.getTagAttributeDefaultValue(tagAttr));
    }

    protected String getTagAttributeDescription(ITagAttribute tagAttr) {
        return tagAttr.getDescription();
    }

    protected boolean getTagAttributeIsRequired(ITagAttribute tagAttr) {
        return tagAttr.isRequired();
    }

    protected String getTagAttributeDefaultValue(ITagAttribute tagAttr) {
        return null;
    }

    protected boolean getTagIsHidden(ITagElement tag) {
        return false;
    }

    protected boolean getTagIsExpert(ITagElement tag) {
        return false;
    }

    protected String getTagLargeIcon(ITagElement tag) {
        return null;
    }

    protected String getTagSmallIcon(ITagElement tag) {
        return null;
    }

    protected String getTagDescription(ITagElement tag) {
        return null;
    }

    protected String getTagDisplayName(ITagElement tag) {
        return tag.getName();
    }

    protected void createTagfileTraits(Namespace ns) {
        Model model = this.getMergedModel();
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "display-label", this.getNamespaceDisplayLabel());
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "description", this.getNamespaceDescription());
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "default-prefix", this.getNamespaceDefaultPrefix());
        this.createSimpleBooleanObjectEntityTraitIfNecessary((Entity)model, "expert", this.getNamespaceExpert());
        this.createSimpleBooleanObjectEntityTraitIfNecessary((Entity)model, "hidden", this.getNamespaceHidden());
    }

    protected String getNamespaceDisplayLabel() {
        return this.getMergedModel().getId();
    }

    protected String getNamespaceDefaultPrefix() {
        return null;
    }

    protected String getNamespaceDescription() {
        return this.getMergedModel().getId();
    }

    protected boolean getNamespaceExpert() {
        return false;
    }

    protected boolean getNamespaceHidden() {
        return false;
    }

    protected Model getMergedModel() {
        Model model = (Model)this._assistant.getMergedModel().getRoot();
        if (model == null) {
            Model tld = this.createTLDModel();
            this._assistant.getMergedModel().setRoot((Object)tld);
            model = (Model)this._assistant.getMergedModel().getRoot();
        }
        return model;
    }

    protected Model createTLDModel() {
        Model entity = this.getFactory().createModel();
        entity.setId(this._assistant.getMergedModel().getModelContext().getModelIdentifier());
        return entity;
    }

    private MetadataFactory getFactory() {
        return (MetadataFactory)MetadataPackage.eINSTANCE.getEFactoryInstance();
    }
}

