/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmGeneratedValue
extends AbstractOrmXmlContextNode
implements OrmGeneratedValue {
    protected XmlGeneratedValue resourceGeneratedValue;
    protected GenerationType specifiedStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;

    public GenericOrmGeneratedValue(XmlContextNode parent, XmlGeneratedValue resourceGeneratedValue) {
        super(parent);
        this.initialize(resourceGeneratedValue);
    }

    protected void initialize(XmlGeneratedValue xmlGeneratedValue) {
        this.resourceGeneratedValue = xmlGeneratedValue;
        this.specifiedStrategy = this.buildStrategy();
        this.specifiedGenerator = xmlGeneratedValue.getGenerator();
        this.defaultGenerator = null;
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    @Override
    public GenerationType getStrategy() {
        return this.specifiedStrategy != null ? this.specifiedStrategy : this.getDefaultStrategy();
    }

    @Override
    public GenerationType getDefaultStrategy() {
        return GeneratedValue.DEFAULT_STRATEGY;
    }

    @Override
    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    @Override
    public void setSpecifiedStrategy(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.resourceGeneratedValue.setStrategy(GenerationType.toOrmResourceModel(strategy));
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    protected void setSpecifiedStrategy_(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    @Override
    public String getGenerator() {
        return this.specifiedGenerator != null ? this.specifiedGenerator : this.defaultGenerator;
    }

    @Override
    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String generator) {
        String old = this.defaultGenerator;
        this.defaultGenerator = generator;
        this.firePropertyChanged("defaultGenerator", old, generator);
    }

    @Override
    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    @Override
    public void setSpecifiedGenerator(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.resourceGeneratedValue.setGenerator(generator);
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    protected void setSpecifiedGenerator_(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange validationTextRange = this.resourceGeneratedValue.getValidationTextRange();
        return validationTextRange != null ? validationTextRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getGeneratorTextRange() {
        TextRange textRange = this.resourceGeneratedValue.getGeneratorTextRange();
        return textRange != null ? textRange : this.getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        String generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        ListIterator<Generator> stream = this.getPersistenceUnit().generators();
        while (stream.hasNext()) {
            if (!generator.equals(((Generator)stream.next()).getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generator}, this.getParent(), this.getGeneratorTextRange()));
    }

    @Override
    public void update(XmlGeneratedValue xmlGeneratedValue) {
        this.resourceGeneratedValue = xmlGeneratedValue;
        this.setSpecifiedStrategy_(this.buildStrategy());
        this.setSpecifiedGenerator_(xmlGeneratedValue.getGenerator());
        this.setDefaultGenerator(null);
    }

    protected GenerationType buildStrategy() {
        return GenerationType.fromOrmResourceModel(this.resourceGeneratedValue.getStrategy());
    }
}

