/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.internal.modulecore.util.IJavaComponentDiscerner;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JavaModuleComponentUtility {
    private static IJavaComponentDiscerner[] discerners;

    protected static IJavaComponentDiscerner[] getDiscerners() {
        if (discerners == null) {
            discerners = JavaModuleComponentUtility.loadDiscerners();
        }
        return discerners == null ? new IJavaComponentDiscerner[]{} : discerners;
    }

    private static IJavaComponentDiscerner[] loadDiscerners() {
        ArrayList<IJavaComponentDiscerner> list = new ArrayList<IJavaComponentDiscerner>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.jst.common.frameworks", "JavaComponentDiscerner");
        int i = 0;
        while (i < cf.length) {
            try {
                list.add((IJavaComponentDiscerner)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return list.toArray(new IJavaComponentDiscerner[list.size()]);
    }

    public static IProject[] findParentProjects(IProject child) {
        IJavaComponentDiscerner[] extensions = JavaModuleComponentUtility.getDiscerners();
        ArrayList<IProject> list = new ArrayList<IProject>();
        int i = 0;
        while (i < extensions.length) {
            list.addAll(Arrays.asList(extensions[i].findParentProjects(child)));
            ++i;
        }
        return list.toArray(new IProject[list.size()]);
    }

    public static IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject) {
        IJavaComponentDiscerner[] extensions = JavaModuleComponentUtility.getDiscerners();
        ArrayList<IVirtualReference> list = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < extensions.length) {
            list.addAll(Arrays.asList(extensions[i].findPossibleManifestEntries(parentProject, childProject)));
            ++i;
        }
        return list.toArray(new IVirtualReference[list.size()]);
    }

    public static IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject, IVirtualReference[] current) {
        IJavaComponentDiscerner[] extensions = JavaModuleComponentUtility.getDiscerners();
        ArrayList<IVirtualReference> list = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < extensions.length) {
            list.addAll(Arrays.asList(extensions[i].findPossibleManifestEntries(parentProject, childProject, current)));
            ++i;
        }
        return list.toArray(new IVirtualReference[list.size()]);
    }

    public static IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject) {
        IJavaComponentDiscerner[] extensions = JavaModuleComponentUtility.getDiscerners();
        ArrayList<IVirtualReference> list = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < extensions.length) {
            list.addAll(Arrays.asList(extensions[i].findCurrentManifestEntries(parentProject, childProject)));
            ++i;
        }
        return list.toArray(new IVirtualReference[list.size()]);
    }
}

