/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.base;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaPlatformUiProvider;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.MappingResourceUiDefinition;
import org.eclipse.jpt.ui.ResourceUiDefinition;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.details.MappingUiDefinition;
import org.eclipse.jpt.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.ui.navigator.JpaNavigatorProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements JpaPlatformUi {
    private final JpaNavigatorProvider navigatorProvider;
    private final JpaPlatformUiProvider platformUiProvider;

    protected BaseJpaPlatformUi(JpaNavigatorProvider navigatorProvider, JpaPlatformUiProvider platformUiProvider) {
        this.navigatorProvider = navigatorProvider;
        this.platformUiProvider = platformUiProvider;
    }

    @Override
    public JpaNavigatorProvider getNavigatorProvider() {
        return this.navigatorProvider;
    }

    @Override
    public JpaStructureProvider getStructureProvider(JpaFile jpaFile) {
        JpaResourceType resourceType = jpaFile.getResourceModel().getResourceType();
        return resourceType == null ? null : this.getStructureProvider(resourceType);
    }

    protected JpaStructureProvider getStructureProvider(JpaResourceType resourceType) {
        ResourceUiDefinition definition;
        try {
            definition = this.getResourceUiDefinition(resourceType);
        }
        catch (IllegalArgumentException iae) {
            JptUiPlugin.log(iae);
            return null;
        }
        return definition.getStructureProvider();
    }

    @Override
    public JpaDetailsPage<? extends JpaStructureNode> buildJpaDetailsPage(Composite parent, JpaStructureNode structureNode, WidgetFactory widgetFactory) {
        JpaDetailsProvider jpaDetailsProvider = this.getDetailsProvider(structureNode);
        return jpaDetailsProvider == null ? null : jpaDetailsProvider.buildDetailsPage(parent, widgetFactory);
    }

    protected JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        for (JpaDetailsProvider provider : CollectionTools.iterable(this.detailsProviders())) {
            if (!provider.providesDetails(structureNode)) continue;
            return provider;
        }
        return null;
    }

    protected ListIterator<JpaDetailsProvider> detailsProviders() {
        return this.platformUiProvider.detailsProviders();
    }

    @Override
    public JpaComposite buildTypeMappingComposite(JpaResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<TypeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildTypeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public JpaComposite buildAttributeMappingComposite(JpaResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<AttributeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildAttributeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public DefaultMappingUiDefinition<PersistentAttribute, ? extends AttributeMapping> getDefaultAttributeMappingUiDefinition(JpaResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultAttributeMappingUiDefinition(mappingKey);
    }

    @Override
    public Iterator<MappingUiDefinition<PersistentAttribute, ? extends AttributeMapping>> attributeMappingUiDefinitions(JpaResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).attributeMappingUiDefinitions();
    }

    @Override
    public DefaultMappingUiDefinition<PersistentType, ? extends TypeMapping> getDefaultTypeMappingUiDefinition(JpaResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultTypeMappingUiDefinition();
    }

    @Override
    public Iterator<MappingUiDefinition<PersistentType, ? extends TypeMapping>> typeMappingUiDefinitions(JpaResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).typeMappingUiDefinitions();
    }

    protected ListIterator<ResourceUiDefinition> resourceUiDefinitions() {
        return this.platformUiProvider.resourceUiDefinitions();
    }

    @Override
    public ResourceUiDefinition getResourceUiDefinition(JpaResourceType resourceType) {
        for (ResourceUiDefinition definition : CollectionTools.iterable(this.resourceUiDefinitions())) {
            if (!definition.providesUi(resourceType)) continue;
            return definition;
        }
        throw new IllegalArgumentException("No resource UI definition for the resource type: " + resourceType);
    }

    public MappingResourceUiDefinition getMappingResourceUiDefinition(JpaResourceType resourceType) {
        try {
            return (MappingResourceUiDefinition)this.getResourceUiDefinition(resourceType);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("No mapping resource UI definition for the resource type: " + resourceType, cce);
        }
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    protected void displayMessage(String title, String message) {
        Shell currentShell = Display.getCurrent().getActiveShell();
        MessageDialog.openInformation((Shell)currentShell, (String)title, (String)message);
    }
}

