/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;
import org.osgi.framework.Bundle;

public class InstallableRuntime
implements IInstallableRuntime {
    private IConfigurationElement element;
    private static Object LOCK = new Object();

    public InstallableRuntime(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return String.valueOf(this.getPath());
    }

    public String getFeatureVersion() {
        try {
            return this.element.getAttribute("featureVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureId() {
        try {
            return this.element.getAttribute("featureId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBundleId() {
        try {
            return this.element.getAttribute("bundleId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBundleVersion() {
        try {
            return this.element.getAttribute("bundleVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPath() {
        try {
            return this.element.getAttribute("path");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFromSite() {
        try {
            return this.element.getAttribute("featureSite");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return null;
        }
        ISite site = InstallableRuntime.getSite(fromSite, monitor);
        ISiteFeatureReference[] featureRefs = site.getFeatureReferences();
        int i = 0;
        while (i < featureRefs.length) {
            String ver = featureRefs[i].getVersionedIdentifier().toString();
            int ind = ver.indexOf("_");
            if (ind >= 0) {
                ver = ver.substring(ind + 1);
            }
            if (featureId.equals(featureRefs[i].getVersionedIdentifier().getIdentifier()) && featureVersion.equals(ver)) {
                IFeature feature = featureRefs[i].getFeature(monitor);
                IURLEntry license = feature.getLicense();
                if (license != null) {
                    return license.getAnnotation();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    protected Bundle getBundleVersion(Bundle[] bundles, String version) {
        if (bundles == null) {
            return null;
        }
        int size = bundles.length;
        return bundles[size - 1];
    }

    public void install(final IPath path) {
        Job installRuntimeJob = new Job(Messages.jobInstallingRuntime){

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    public static ISite getSite(String fromSite, IProgressMonitor monitor) {
        block6: {
            try {
                URL siteURL = new URL(fromSite);
                return SiteManager.getSite((URL)siteURL, (IProgressMonitor)monitor);
            }
            catch (MalformedURLException e) {
                if (Trace.WARNING) {
                    Trace.trace("/warning", "Could not parse site", e);
                }
            }
            catch (CoreException e) {
                if (Trace.WARNING) {
                    Trace.trace("/warning", "Could not parse site", e);
                }
            }
            catch (Exception e) {
                if (!Trace.WARNING) break block6;
                Trace.trace("/warning", "Could not parse site", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISite getSite(URL fromSiteURL, IProgressMonitor monitor) throws IOException {
        try {
            Object object = LOCK;
            synchronized (object) {
                return SiteManager.getSite((URL)fromSiteURL, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            if (Trace.WARNING) {
                Trace.trace("/warning", "Could not parse site", e);
            }
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            if (Trace.WARNING) {
                Trace.trace("/warning", "Could not parse site", e);
            }
            throw new IOException(e.getMessage());
        }
    }

    protected static String getMirror(String fromSite, ISite site, int mirror) {
        String mirrorSite;
        if (site != null && (mirrorSite = InstallableRuntime.getMirror(site, mirror)) != null) {
            return mirrorSite;
        }
        if (mirror > 0) {
            return null;
        }
        return fromSite;
    }

    protected static String getMirror(ISite site, int mirror) {
        block4: {
            if (site != null && site instanceof ISiteWithMirrors) {
                try {
                    IURLEntry[] urlEntries = ((ISiteWithMirrors)site).getMirrorSiteEntries();
                    if (urlEntries.length > mirror) {
                        return urlEntries[mirror].getURL().toExternalForm();
                    }
                }
                catch (CoreException e) {
                    if (!Trace.WARNING) break block4;
                    Trace.trace("/warning", "Could not find mirror site", e);
                }
            }
        }
        return null;
    }

    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return;
        }
        int mirror = 0;
        ISite site = InstallableRuntime.getSite(fromSite, monitor);
        fromSite = InstallableRuntime.getMirror(fromSite, site, mirror);
        boolean install = false;
        if (this.getBundleId() != null) {
            install = Platform.getBundles((String)this.getBundleId(), (String)this.getBundleVersion()) == null;
        } else if (this.getPath() != null) {
            boolean bl = install = !new File(this.getFeatureArchivePath()).exists();
        }
        if (install) {
            boolean complete = false;
            while (!complete) {
                try {
                    monitor.setTaskName("Installing feature");
                    InstallCommand command = new InstallCommand(featureId, featureVersion, fromSite, null, "false");
                    boolean b = command.run(monitor);
                    if (!b) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorInstallingServerFeature, null));
                    }
                    command.applyChangesNow();
                    complete = true;
                }
                catch (ConnectException connectException) {
                    fromSite = InstallableRuntime.getMirror(fromSite, site, ++mirror);
                    if (fromSite != null) continue;
                    complete = true;
                }
                catch (Exception e) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error installing feature", e);
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
                }
            }
        }
        try {
            URL url = null;
            if (this.getBundleId() != null) {
                Bundle[] bundles = Platform.getBundles((String)this.getBundleId(), (String)this.getBundleVersion());
                Bundle bundle = this.getBundleVersion(bundles, this.getBundleVersion());
                url = bundle.getEntry(this.getPath());
                url = FileLocator.resolve((URL)url);
            } else {
                url = new File(this.getFeatureArchivePath()).toURL();
            }
            InputStream in = url.openStream();
            this.unzip(in, path, monitor);
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error unzipping runtime", e);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
    }

    private void unzip(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        byte[] buf = new byte[8192];
        while (entry != null) {
            String name = entry.getName();
            monitor.setTaskName("Unzipping: " + name);
            if (entry.isDirectory()) {
                path.append(name).toFile().mkdirs();
            } else {
                FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                int r = zin.read(buf);
                while (r >= 0) {
                    fout.write(buf, 0, r);
                    r = zin.read(buf);
                }
            }
            zin.closeEntry();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    private String getFeatureArchivePath() {
        String feature = String.valueOf(this.getFeatureId()) + "_" + this.getFeatureVersion();
        String platformLoc = Platform.getInstallLocation().getURL().getFile();
        return platformLoc.concat(String.valueOf(File.separator) + "features/" + feature + File.separator + this.getPath());
    }

    public String toString() {
        return "InstallableRuntime[" + this.getId() + "]";
    }
}

