/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryPersistentMember
extends BinaryNode
implements JavaResourcePersistentMember {
    final Adapter adapter;
    final Vector<Annotation> annotations = new Vector();
    boolean persistable;
    private static final IAnnotation[] EMPTY_JDT_ANNOTATION_ARRAY = new IAnnotation[0];

    public BinaryPersistentMember(JavaResourceNode parent, Adapter adapter) {
        super(parent);
        this.adapter = adapter;
        this.initializeAnnotations();
        this.persistable = this.buildPersistable();
    }

    private void initializeAnnotations() {
        IAnnotation[] iAnnotationArray = this.getJdtAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.addAnnotation(annotation);
            ++n2;
        }
    }

    private void addAnnotation(IAnnotation jdtAnnotation) {
        if (this.annotationIsValid(jdtAnnotation)) {
            this.annotations.add(this.buildAnnotation(jdtAnnotation));
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateAnnotations();
        this.setPersistable(this.buildPersistable());
    }

    private void updateAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Annotation> annotations() {
        return this.getAnnotations().iterator();
    }

    private Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int annotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullAnnotation(annotationName);
    }

    @Override
    public Iterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.getNestedAnnotations().iterator();
        }
        NestableAnnotation nestableAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        return nestableAnnotation == null ? EmptyListIterator.instance() : new SingleElementIterator((Object)nestableAnnotation);
    }

    private NestableAnnotation getNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getAnnotation(annotationName);
    }

    private ContainerAnnotation<NestableAnnotation> getContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getAnnotation(annotationName);
    }

    private boolean annotationIsValid(IAnnotation jdtAnnotation) {
        return CollectionTools.contains(this.validAnnotationNames(), (Object)jdtAnnotation.getElementName());
    }

    abstract Iterator<String> validAnnotationNames();

    abstract Annotation buildAnnotation(IAnnotation var1);

    abstract Annotation buildNullAnnotation(String var1);

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void setPersistable(boolean persistable) {
        boolean old = this.persistable;
        this.persistable = persistable;
        this.firePropertyChanged("persistable", old, persistable);
    }

    private boolean buildPersistable() {
        return this.adapter.isPersistable();
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    IMember getMember() {
        return this.adapter.getMember();
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> annotationList, String annotationName) {
        for (Annotation annotation : annotationList) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        return new FilteringIterator<T>(members){

            protected boolean accept(T m) {
                return m.isPersistable();
            }
        };
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return typeSignature == null ? null : BinaryPersistentMember.convertTypeSignatureToTypeName_(typeSignature);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return Signature.toString((String)Signature.getTypeErasure((String)typeSignature));
    }

    private IAnnotation[] getJdtAnnotations() {
        try {
            return this.adapter.getAnnotations();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_JDT_ANNOTATION_ARRAY;
        }
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter {
        public IMember getMember();

        public boolean isPersistable();

        public IAnnotation[] getAnnotations() throws JavaModelException;
    }
}

