/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.operations.AbstractJpaFileCreationOperation;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmFileCreationOperation
extends AbstractJpaFileCreationOperation
implements OrmFileCreationDataModelProperties {
    public OrmFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.execute(monitor, info);
        if (status.isOK()) {
            this.addMappingFileToPersistenceXml();
        }
        return OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() throws ExecutionException {
        String pUnitName = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            throw new ExecutionException("Project does not have a persistence.xml file");
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            throw new ExecutionException("persistence.xml does not have a persistence node.");
        }
        ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
        while (stream.hasNext()) {
            PersistenceUnit pUnit = (PersistenceUnit)stream.next();
            if (!pUnitName.equals(pUnit.getName())) continue;
            return pUnit;
        }
        throw new ExecutionException("persistence.xml does not have persistence unit named '" + pUnitName + "'");
    }

    protected void addMappingFileToPersistenceXml() throws ExecutionException {
        if (!this.getDataModel().getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return;
        }
        JpaProject jpaProject = JptCorePlugin.getJpaProject(this.createdFile.getProject());
        JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        final PersistenceUnit pUnit = this.getPersistenceUnit();
        resource.modify(new Runnable(){

            public void run() {
                String filePath = OrmFileCreationOperation.this.getDataModel().getStringProperty("JpaFileCreationDataModelProperties.FILE_PATH");
                ListIterator<MappingFileRef> stream = pUnit.specifiedMappingFileRefs();
                while (stream.hasNext()) {
                    if (!filePath.equals(((MappingFileRef)stream.next()).getFileName())) continue;
                    return;
                }
                MappingFileRef mfRef = pUnit.addSpecifiedMappingFileRef();
                mfRef.setFileName(new Path(filePath).toPortableString());
            }
        });
    }

    protected AbstractXmlResourceProvider getXmlResourceProvider(IFile file) {
        return OrmXmlResourceProvider.getXmlResourceProvider(file);
    }
}

