/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionUpdateRule;

public class XMLContentRegion
implements ITextRegion {
    private static final String fType = "XML_CONTENT";
    private int fLength;
    private int fStart;

    public XMLContentRegion() {
    }

    public XMLContentRegion(int start, int length) {
        this();
        this.fStart = start;
        this.fLength = length;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.fStart += i;
    }

    public void adjustTextLength(int i) {
    }

    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
    }

    public int getEnd() {
        return this.fStart + this.fLength;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTextEnd() {
        return this.fStart + this.fLength;
    }

    public int getTextLength() {
        return this.fLength;
    }

    public String getType() {
        return fType;
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        RegionChangedEvent result = null;
        boolean canHandle = false;
        canHandle = changes == null || changes.length() == 0 ? this.fStart < this.getTextEnd() && Math.abs(lengthToReplace) < this.getTextEnd() - this.getStart() : RegionUpdateRule.canHandleAsWhiteSpace(this, parent, changes, requestStart, lengthToReplace) || RegionUpdateRule.canHandleAsLetterOrDigit(this, parent, changes, requestStart, lengthToReplace);
        if (canHandle) {
            int lengthDifference = Utilities.calculateLengthDifference((String)changes, (int)lengthToReplace);
            this.fLength += lengthDifference;
            result = new RegionChangedEvent(parent.getParentDocument(), requester, parent, (ITextRegion)this, changes, requestStart, lengthToReplace);
        }
        return result;
    }
}

