/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.breakpoints;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.BreakpointEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ScriptLoadEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.core.model.Script;

public abstract class JavaScriptBreakpoint
extends Breakpoint
implements IJavaScriptBreakpoint,
IJavaScriptEventListener {
    public static final String INSTALL_COUNT = "org.eclipse.wst.jsdt.debug.core.install_count";
    private HashSet targets = null;
    private HashMap requestspertarget = new HashMap(4);

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.setAttribute(INSTALL_COUNT, 0);
    }

    protected void setAttribute(final String attributeName, final boolean value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaScriptBreakpoint.this.ensureMarker().setAttribute(attributeName, value);
            }
        };
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void setAttribute(final String attributeName, final Object value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaScriptBreakpoint.this.ensureMarker().setAttribute(attributeName, value);
            }
        };
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getModelIdentifier() {
        return "org.eclipse.wst.jsdt.debug.model";
    }

    public boolean shouldSkipBreakpoint() throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        return plugin != null && this.isRegistered() && !plugin.getBreakpointManager().isEnabled();
    }

    public void addToTarget(JavaScriptDebugTarget target) throws CoreException {
        if (target.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        ScriptLoadRequest request = target.getEventRequestManager().createScriptLoadRequest();
        request.setEnabled(this.isEnabled());
        this.registerRequest(target, request);
        String scriptPath = this.getScriptPath();
        if (scriptPath == null) {
            return;
        }
        try {
            List scripts = target.underlyingScripts(Script.resolveName(URIUtil.fromString((String)scriptPath)));
            boolean success = true;
            Iterator iter = scripts.iterator();
            while (iter.hasNext()) {
                ScriptReference script = (ScriptReference)iter.next();
                if (!this.scriptPathMatches(script)) continue;
                success &= this.createRequest(target, script);
            }
            if (success) {
                if (this.targets == null) {
                    this.targets = new HashSet();
                }
                this.targets.add(target);
            }
        }
        catch (URISyntaxException urise) {
            JavaScriptDebugPlugin.log(urise);
        }
    }

    protected abstract boolean createRequest(JavaScriptDebugTarget var1, ScriptReference var2) throws CoreException;

    protected void configureRequest(BreakpointRequest request) throws CoreException {
        request.addHitCountFilter(this.getHitCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFromTarget(JavaScriptDebugTarget target) {
        ArrayList requests = this.getRequests(target);
        if (requests != null) {
            Iterator iter = requests.iterator();
            while (iter.hasNext()) {
                Object var5_5;
                EventRequest request = null;
                try {
                    request = (EventRequest)iter.next();
                    if (target.isAvailable()) {
                        target.getEventRequestManager().deleteEventRequest(request);
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    this.deregisterRequest(target, request);
                    throw throwable;
                }
                {
                    var5_5 = null;
                    this.deregisterRequest(target, request);
                }
            }
        }
        HashMap hashMap = this.requestspertarget;
        synchronized (hashMap) {
            this.requestspertarget.remove(target);
        }
        if (this.targets == null) {
            return;
        }
        this.targets.remove(target);
    }

    protected void recreateBreakpoint() throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null) {
            IDebugTarget[] targets = plugin.getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i].getModelIdentifier().equals("org.eclipse.wst.jsdt.debug.model")) {
                    this.recreateBreakpointFor((JavaScriptDebugTarget)targets[i]);
                }
                ++i;
            }
        }
    }

    void recreateBreakpointFor(JavaScriptDebugTarget target) throws CoreException {
        if (target.isAvailable() && target.getBreakpoints().contains(this)) {
            this.removeFromTarget(target);
            this.addToTarget(target);
        }
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (this.isEnabled() != enabled) {
            this.setAttribute("org.eclipse.debug.core.enabled", enabled);
            this.recreateBreakpoint();
        }
    }

    public void setSuspendPolicy(int policy) throws CoreException {
        if (this.getSuspendPolicy() != policy) {
            this.setAttribute("org.eclipse.wst.jsdt.debug.core.suspend_policy", policy);
            this.recreateBreakpoint();
        }
    }

    public int getSuspendPolicy() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.suspend_policy", 1);
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0) > 0;
    }

    protected void incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.ensureMarker().setAttribute(INSTALL_COUNT, count + 1);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0);
    }

    protected void decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.ensureMarker().setAttribute(INSTALL_COUNT, count - 1);
        }
    }

    public void setHitCount(int count) throws CoreException, IllegalArgumentException {
        if (count != this.getHitCount()) {
            this.setAttribute("org.eclipse.wst.jsdt.debug.core.hit_count", count);
            this.recreateBreakpoint();
        }
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.hit_count", -1);
    }

    public String getScriptPath() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.script_path", "");
    }

    public String getTypeName() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.type_name", null);
    }

    protected void registerRequest(JavaScriptDebugTarget target, EventRequest request) {
        this.addRequestForTarget(target, request);
        if (!(request instanceof ScriptLoadRequest)) {
            try {
                this.incrementInstallCount();
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addRequestForTarget(JavaScriptDebugTarget target, EventRequest request) {
        ArrayList<EventRequest> requests = this.getRequests(target);
        if (requests == null) {
            HashMap hashMap = this.requestspertarget;
            synchronized (hashMap) {
                requests = new ArrayList<EventRequest>(2);
                this.requestspertarget.put(target, requests);
            }
        }
        requests.add(request);
        target.addJSDIEventListener(this, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getRequests(JavaScriptDebugTarget target) {
        ArrayList list = null;
        HashMap hashMap = this.requestspertarget;
        synchronized (hashMap) {
            list = (ArrayList)this.requestspertarget.get(target);
        }
        return list;
    }

    protected void deregisterRequest(JavaScriptDebugTarget target, EventRequest request) {
        target.removeJSDIEventListener(this, request);
        if (!(request instanceof ScriptLoadRequest)) {
            try {
                this.decrementInstallCount();
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    public boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        JavaScriptThread thread;
        if (event instanceof BreakpointEvent && (thread = target.findThread(((BreakpointEvent)event).thread())) != null) {
            return !thread.suspendForBreakpoint(this, suspendVote);
        }
        if (event instanceof ScriptLoadEvent) {
            ScriptLoadEvent sevent = (ScriptLoadEvent)event;
            ScriptReference script = sevent.script();
            try {
                if (this.scriptPathMatches(script)) {
                    this.createRequest(target, script);
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
        return true;
    }

    protected boolean scriptPathMatches(ScriptReference script) throws CoreException {
        URI sourceURI = script.sourceURI();
        if ("file".equals(sourceURI.getScheme())) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            URI workspaceURI = workspaceRoot.getRawLocationURI();
            sourceURI = workspaceURI.relativize(sourceURI);
        }
        return this.getScriptPath().equals(sourceURI.toString());
    }

    boolean typeNamesEqual(String tname1, String tname2) {
        if (tname1 == null && tname2 == null) {
            return true;
        }
        return tname1 != null && tname1.equals(tname2);
    }

    boolean pathsEqual(IPath p1, IPath p2) {
        if (p1.segmentCount() == p2.segmentCount()) {
            String[] segments = p1.segments();
            int i = 0;
            while (i < segments.length) {
                if (!segments[i].equals(p2.segment(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
        JavaScriptThread thread;
        if (event instanceof BreakpointEvent && (thread = target.findThread(((BreakpointEvent)event).thread())) != null) {
            thread.suspendForBreakpointComplete(this, suspend, eventSet);
        }
    }

    public void setJavaScriptElementHandle(String handle) throws CoreException {
        this.ensureMarker().setAttribute("org.eclipse.wst.jsdt.debug.core.handle", (Object)handle);
    }

    public String getJavaScriptElementHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.handle", null);
    }
}

