/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.core.util.UIContextDetermination;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddReferencesOp
extends AbstractDataModelOperation {
    public AddReferencesOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.validateEdit().isOK()) {
            return Status.CANCEL_STATUS;
        }
        this.addReferencedComponents(monitor);
        this.addProjectReferences(monitor);
        return OK_STATUS;
    }

    protected IStatus validateEdit() {
        IStatus status = OK_STATUS;
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT");
        IProject project = sourceComp.getProject();
        if (status.isOK()) {
            StructureEdit sEdit = null;
            try {
                sEdit = StructureEdit.getStructureEditForWrite(project);
                status = validator.validateState((EditModel)sEdit.getModuleStructuralModel());
            }
            finally {
                if (sEdit != null) {
                    sEdit.dispose();
                }
            }
        }
        IFile[] files = new IFile[]{project.getFile(".project")};
        status = ResourcesPlugin.getWorkspace().validateEdit(files, null);
        return status;
    }

    public static List<IVirtualReference> getListFromModel(IDataModel model) {
        Object value = model.getProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
        List<IVirtualReference> modList = value instanceof List ? (List<IVirtualReference>)value : Arrays.asList((IVirtualReference)value);
        return modList;
    }

    protected void addProjectReferences() {
        this.addProjectReferences(null);
    }

    protected void addProjectReferences(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT");
        List<IVirtualReference> modList = AddReferencesOp.getListFromModel(this.model);
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent virtualComponent = modList.get(i).getReferencedComponent();
            if (!virtualComponent.isBinary()) {
                IProject targetProject = virtualComponent.getProject();
                targetprojectList.add(targetProject);
            }
            ++i;
        }
        try {
            ProjectUtilities.addReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
            IFacetedProject sourceProject = ProjectFacetsManager.create((IProject)sourceComp.getProject());
            IRuntime sourceRuntime = sourceProject.getPrimaryRuntime();
            Iterator tplItr = targetprojectList.iterator();
            while (tplItr.hasNext()) {
                IFacetedProject moduleFacetedProject = ProjectFacetsManager.create((IProject)((IProject)tplItr.next()));
                if (moduleFacetedProject == null || AddReferencesOp.equals(sourceRuntime, moduleFacetedProject.getPrimaryRuntime())) continue;
                boolean supports = true;
                if (sourceRuntime != null) {
                    for (IProjectFacetVersion fver : moduleFacetedProject.getProjectFacets()) {
                        if (sourceRuntime.supports(fver)) continue;
                        supports = false;
                        break;
                    }
                }
                if (!supports) continue;
                moduleFacetedProject.setRuntime(sourceRuntime, AddReferencesOp.submon(monitor, 1));
            }
        }
        catch (CoreException e) {
            ModulecorePlugin.logError(e);
        }
    }

    protected void addReferencedComponents(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT");
        List<IVirtualReference> refList = AddReferencesOp.getListFromModel(this.model);
        IVirtualReference[] refs = refList.toArray(new IVirtualReference[refList.size()]);
        sourceComp.addReferences(refs);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

