/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.DragNodeCommand;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeContentProvider;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTreeExtension;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLTableTreeViewer
extends TreeViewer
implements IDesignViewer {
    protected CellEditor cellEditor;
    protected XMLTreeExtension treeExtension;
    private ISelectionProvider fSelectionProvider = new SelectionProvider();

    public XMLTableTreeViewer(Composite parent) {
        super(parent, 66306);
        this.treeExtension = new XMLTreeExtension(this.getTree());
        XMLTableTreeContentProvider provider = new XMLTableTreeContentProvider();
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        this.createContextMenu();
        DragSource dragSource = new DragSource(this.getControl(), 3);
        dragSource.addDragListener(this.createDragSourceListener());
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        DropTarget dropTarget = new DropTarget(this.getControl(), 3);
        dropTarget.addDropListener(this.createDropTargetListener());
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)new NodeActionMenuListener());
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private DragSourceListener createDragSourceListener() {
        return new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(XMLTableTreeViewer.this.getSelection());
            }
        };
    }

    private DropTargetListener createDropTargetListener() {
        return new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.operations != 0 && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
                    this.dragOver(event);
                    IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                    if (selection != null && !selection.isEmpty() && event.item != null && event.item.getData() != null) {
                        float feedbackFloat = this.getHeightInItem(event);
                        DragNodeCommand command = new DragNodeCommand(event.item.getData(), feedbackFloat, event.operations, event.detail, selection.toList(), XMLTableTreeViewer.this);
                        if (command != null && command.canExecute()) {
                            SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, command){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ DragNodeCommand val$command;
                                {
                                    this.this$1 = var1_1;
                                    this.val$command = dragNodeCommand;
                                }

                                public void run() throws Exception {
                                    this.val$command.execute();
                                }
                            });
                        }
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 1;
                float feedbackFloat = this.getHeightInItem(event);
                if ((double)feedbackFloat > 0.75) {
                    event.feedback = 4;
                } else if ((double)feedbackFloat < 0.25) {
                    event.feedback = 2;
                }
                event.feedback |= 0x18;
            }

            private float getHeightInItem(DropTargetEvent event) {
                if (event.item == null) {
                    return 0.5f;
                }
                if (event.item instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)event.item;
                    Tree control = treeItem.getParent();
                    Point point = control.toControl(new Point(event.x, event.y));
                    Rectangle bounds = treeItem.getBounds();
                    return (float)(point.y - bounds.y) / (float)bounds.height;
                }
                if (event.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)event.item;
                    Table control = tableItem.getParent();
                    Point point = control.toControl(new Point(event.x, event.y));
                    Rectangle bounds = tableItem.getBounds(0);
                    return (float)(point.y - bounds.y) / (float)bounds.height;
                }
                return 0.0f;
            }
        };
    }

    protected void doRefresh(Object o, boolean fromDelayed) {
        this.treeExtension.resetCachedData();
        super.refresh(o);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public String getTitle() {
        return XMLEditorMessages.XMLTableTreeViewer_0;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.treeExtension.dispose();
        this.setDocument(null);
    }

    public void refresh() {
        this.treeExtension.resetCachedData();
        super.refresh();
    }

    public void refresh(Object o) {
        this.treeExtension.resetCachedData();
        super.refresh(o);
    }

    public void refresh(boolean updateLabels) {
        this.treeExtension.resetCachedData();
        super.refresh(updateLabels);
        this.getControl().redraw();
    }

    public void refresh(Object element, boolean updateLabels) {
        this.treeExtension.resetCachedData();
        super.refresh(element, updateLabels);
        this.getControl().redraw();
    }

    /*
     * Exception decompiling
     */
    public void setDocument(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class NodeActionMenuListener
    implements IMenuListener {
        NodeActionMenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            XMLNodeActionManager nodeActionManager = new XMLNodeActionManager(this, (IStructuredModel)((IDOMDocument)XMLTableTreeViewer.this.getInput()).getModel(), (Viewer)XMLTableTreeViewer.this){
                final /* synthetic */ NodeActionMenuListener this$1;
                {
                    this.this$1 = nodeActionMenuListener;
                }

                public void beginNodeAction(NodeAction action) {
                    super.beginNodeAction(action);
                }

                public void endNodeAction(NodeAction action) {
                    super.endNodeAction(action);
                }
            };
            nodeActionManager.fillContextMenu(menuManager, XMLTableTreeViewer.this.getSelection());
        }
    }

    private class SelectionProvider
    implements IPostSelectionProvider {
        private SelectionProvider() {
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.addPostSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.removePostSelectionChangedListener(listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            return XMLTableTreeViewer.this.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
            boolean selectionSet = false;
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (selection instanceof ITextSelection) {
                    IDOMNode domNode;
                    IStructuredDocumentRegion startStructuredDocumentRegion;
                    ITextSelection textSelection = (ITextSelection)selection;
                    if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof IDOMNode && (startStructuredDocumentRegion = (domNode = (IDOMNode)structuredSelection.getFirstElement()).getStartStructuredDocumentRegion()) != null) {
                        ITextRegion matchingRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(textSelection.getOffset());
                        int allowedIterations = 40;
                        while (matchingRegion != null && !matchingRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME") && allowedIterations > 0) {
                            matchingRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(startStructuredDocumentRegion.getStartOffset(matchingRegion) - 1);
                            --allowedIterations;
                        }
                        if (matchingRegion != null && matchingRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                            Node attr;
                            String attrName = startStructuredDocumentRegion.getText(matchingRegion);
                            NamedNodeMap attributes = domNode.getAttributes();
                            if (attributes != null && attrName.length() > 0 && (attr = attributes.getNamedItem(attrName)) != null) {
                                selectionSet = true;
                                XMLTableTreeViewer.this.setSelection((ISelection)new StructuredSelection((Object)attr));
                            }
                        }
                    }
                }
            }
            if (!selectionSet) {
                XMLTableTreeViewer.this.setSelection(selection);
            }
        }
    }
}

