/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;

public abstract class FacetedProjectWizard
extends ModifyFacetedProjectWizard
implements INewWizard {
    private final IFacetedProjectTemplate template = this.getTemplate();
    private WizardNewProjectCreationPage firstPage;

    public FacetedProjectWizard() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        fpjwc.setSelectedPreset(this.template.getInitialPreset().getId());
        fpjwc.setFixedProjectFacets(this.template.getFixedProjectFacets());
        this.setWindowTitle(String.valueOf(Resources.newPrefix) + this.template.getLabel());
        ImageDescriptor defImageDescriptor = this.getDefaultPageImageDescriptor();
        if (defImageDescriptor != null) {
            this.setDefaultPageImageDescriptor(defImageDescriptor);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.firstPage = new WizardNewProjectCreationPage("first.page");
        this.firstPage.setTitle(this.template.getLabel());
        this.firstPage.setDescription(this.getPageDescription());
        this.addPage((IWizardPage)this.firstPage);
        super.addPages();
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && super.canFinish();
    }

    public IWizardPage[] getPages() {
        IWizardPage[] base = super.getPages();
        IWizardPage[] pages = new IWizardPage[base.length + 1];
        pages[0] = this.firstPage;
        System.arraycopy(base, 0, pages, 1, base.length);
        return pages;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.firstPage) {
            IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
            fpjwc.setProjectName(this.firstPage.getProjectName());
            fpjwc.setProjectLocation(this.firstPage.getLocationPath());
        }
        return super.getNextPage(page);
    }

    protected abstract IFacetedProjectTemplate getTemplate();

    protected abstract String getPageDescription();

    protected abstract ImageDescriptor getDefaultPageImageDescriptor();

    private static final class Resources
    extends NLS {
        public static String newPrefix;

        static {
            Resources.initializeMessages((String)FacetedProjectWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

